/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mseed;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfParameterMgr.ParameterRef;
import edu.iris.Fissures.IfRealTimeCollector.DataChunk;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.Property;
import edu.iris.Fissures.IfTimeSeries.EncodedData;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesDataSel;
import edu.iris.Fissures.IfTimeSeries.TimeSeriesType;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.UnitBase;
import edu.iris.Fissures.model.ISOTime;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.SamplingImpl;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.database.DataCenterUtil;
import edu.sc.seis.fissuresUtil.display.IntRange;
import edu.sc.seis.fissuresUtil.display.SimplePlotUtil;
import edu.sc.seis.fissuresUtil.hibernate.PlottableChunk;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.mseed.Blockette;
import edu.sc.seis.seisFile.mseed.Blockette100;
import edu.sc.seis.seisFile.mseed.Blockette1000;
import edu.sc.seis.seisFile.mseed.Btime;
import edu.sc.seis.seisFile.mseed.BtimeRange;
import edu.sc.seis.seisFile.mseed.DataHeader;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;

public class FissuresConvert {
    public static final byte RECORD_SIZE_4096_POWER = 12;
    public static int RECORD_SIZE_4096 = (int)Math.pow(2.0, 12.0);
    public static final byte RECORD_SIZE_1024_POWER = 10;
    public static int RECORD_SIZE_1024 = (int)Math.pow(2.0, 10.0);
    public static final byte RECORD_SIZE_512_POWER = 9;
    public static int RECORD_SIZE_512 = (int)Math.pow(2.0, 9.0);
    public static final byte RECORD_SIZE_256_POWER = 8;
    public static int RECORD_SIZE_256 = (int)Math.pow(2.0, 8.0);
    public static final TimeInterval DAY = new TimeInterval(1.0, UnitImpl.DAY);
    private static final Logger logger = Logger.getLogger(FissuresConvert.class);

    private FissuresConvert() {
    }

    public static DataRecord[] toMSeed(LocalSeismogram seis) throws SeedFormatException {
        return FissuresConvert.toMSeed(seis, 1);
    }

    public static DataRecord[] toMSeed(LocalSeismogram seis, int seqStart) throws SeedFormatException {
        LinkedList<Object> outRecords = new LinkedList();
        MicroSecondDate start = new MicroSecondDate(seis.begin_time);
        if (seis.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] eData = seis.data.encoded_values();
            outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            try {
                outRecords = FissuresConvert.toMSeed(FissuresConvert.toEncodedData(seis.get_as_longs()), seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting integer data", (Throwable)e);
            }
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_FLOAT)) {
            try {
                EncodedData[] eData = new EncodedData[(int)Math.ceil((float)seis.num_points * 4.0f / 3968.0f)];
                float[] data = seis.get_as_floats();
                for (int i = 0; i < eData.length; ++i) {
                    int j;
                    byte[] dataBytes = new byte[3968];
                    for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                        int val = Float.floatToIntBits(data[j + 992 * i]);
                        dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                        dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                        dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                        dataBytes[4 * j + 3] = (byte)(val & 0xFF);
                    }
                    if (j == 0) {
                        throw new SeedFormatException("try to put 0 float samples into an encodedData object j=" + j + " i=" + i + " seis.num_ppoints=" + seis.num_points);
                    }
                    eData[i] = new EncodedData(4, dataBytes, j, false);
                }
                outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting float data", (Throwable)e);
            }
        } else if (seis.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            try {
                EncodedData[] eData = new EncodedData[(int)Math.ceil((float)seis.num_points * 4.0f / 3968.0f)];
                int[] data = seis.get_as_longs();
                for (int i = 0; i < eData.length; ++i) {
                    int j;
                    byte[] dataBytes = new byte[3968];
                    for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                        int val = data[j + 992 * i];
                        dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                        dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                        dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                        dataBytes[4 * j + 3] = (byte)(val & 0xFF);
                    }
                    if (j == 0) {
                        throw new SeedFormatException("try to put 0 int samples into an encodedData object j=" + j + " i=" + i + " seis.num_ppoints=" + seis.num_points);
                    }
                    eData[i] = new EncodedData(3, dataBytes, j, false);
                }
                outRecords = FissuresConvert.toMSeed(eData, seis.channel_id, start, (SamplingImpl)seis.sampling_info, seqStart);
            }
            catch (FissuresException e) {
                throw new SeedFormatException("Problem getting float data", (Throwable)e);
            }
        } else {
            throw new SeedFormatException("Can only handle EncodedData now, type=" + seis.data.discriminator().value());
        }
        return outRecords.toArray(new DataRecord[0]);
    }

    public static DataRecord[] toMSeed(DataChunk chunk) throws SeedFormatException {
        if (!chunk.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            throw new SeedFormatException("Can only handle EncodedData now");
        }
        LinkedList<DataRecord> outRecords = FissuresConvert.toMSeed(chunk.data.encoded_values(), chunk.channel, new MicroSecondDate(chunk.begin_time), DataCenterUtil.getSampling(chunk), chunk.seq_num);
        return outRecords.toArray(new DataRecord[0]);
    }

    public static LinkedList<DataRecord> toMSeed(EncodedData[] eData, ChannelId channel_id, MicroSecondDate start, SamplingImpl sampling_info, int seqStart) throws SeedFormatException {
        return FissuresConvert.toMSeed(eData, channel_id, start, sampling_info, seqStart, 'M');
    }

    public static LinkedList<DataRecord> toMSeed(EncodedData[] eData, ChannelId channel_id, MicroSecondDate start, SamplingImpl sampling_info, int seqStart, char typeCode) throws SeedFormatException {
        Blockette100 b100;
        Blockette1000 b1000;
        DataHeader header;
        int i;
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        int recordSize = RECORD_SIZE_4096;
        int recordSizePower = 12;
        int minRecordSize = 0;
        for (i = 0; i < eData.length; ++i) {
            header = new DataHeader(seqStart++, typeCode, false);
            b1000 = new Blockette1000();
            b100 = new Blockette100();
            if (minRecordSize >= eData[i].values.length + header.getSize() + b1000.getSize()) continue;
            minRecordSize = eData[i].values.length + header.getSize() + b1000.getSize();
        }
        if (minRecordSize < RECORD_SIZE_4096) {
            recordSize = RECORD_SIZE_4096;
            recordSizePower = 12;
        }
        if (minRecordSize < RECORD_SIZE_1024) {
            recordSize = RECORD_SIZE_1024;
            recordSizePower = 10;
        }
        if (minRecordSize < RECORD_SIZE_512) {
            recordSize = RECORD_SIZE_512;
            recordSizePower = 9;
        }
        for (i = 0; i < eData.length; ++i) {
            header = new DataHeader(seqStart++, 'D', false);
            b1000 = new Blockette1000();
            b100 = new Blockette100();
            if (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize() >= recordSize) {
                if (eData[i].values.length + header.getSize() + b1000.getSize() < recordSize) {
                    b100 = null;
                } else {
                    throw new SeedFormatException("Can't fit data into record of size " + recordSize + " " + (eData[i].values.length + header.getSize() + b1000.getSize() + b100.getSize()) + " " + eData[i].values.length + " " + (header.getSize() + b1000.getSize() + b100.getSize()));
                }
            }
            header.setStationIdentifier(channel_id.station_code);
            header.setLocationIdentifier(channel_id.site_code);
            header.setChannelIdentifier(channel_id.channel_code);
            header.setNetworkCode(channel_id.network_id.network_code);
            header.setStartBtime(FissuresConvert.getBtime(start));
            header.setNumSamples((short)eData[i].num_points);
            TimeInterval sampPeriod = sampling_info.getPeriod();
            start = start.add((TimeInterval)sampPeriod.multiplyBy((double)eData[i].num_points));
            short[] multiAndFactor = FissuresConvert.calcSeedMultipilerFactor(sampling_info);
            header.setSampleRateFactor(multiAndFactor[0]);
            header.setSampleRateMultiplier(multiAndFactor[1]);
            b1000.setEncodingFormat((byte)eData[i].compression);
            if (eData[i].byte_order) {
                b1000.setWordOrder((byte)0);
            } else {
                b1000.setWordOrder((byte)1);
            }
            b1000.setDataRecordLength((byte)recordSizePower);
            DataRecord dr = new DataRecord(header);
            dr.addBlockette((Blockette)b1000);
            QuantityImpl hertz = sampling_info.getFrequency().convertTo(UnitImpl.HERTZ);
            if (b100 != null) {
                b100.setActualSampleRate((float)hertz.getValue());
                dr.addBlockette((Blockette)b100);
            }
            dr.setData(eData[i].values);
            list.add(dr);
        }
        return list;
    }

    public static short[] calcSeedMultipilerFactor(SamplingImpl sampling) {
        TimeInterval sampPeriod = sampling.getPeriod();
        double sps = 1.0 / sampPeriod.convertTo(UnitImpl.SECOND).getValue();
        return DataHeader.calcSeedMultipilerFactor((double)sps);
    }

    public static LocalSeismogramImpl toFissures(String filename) throws SeedFormatException, IOException, FissuresException {
        ArrayList<DataRecord> data = new ArrayList<DataRecord>();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));
        try {
            while (true) {
                SeedRecord sr;
                if (!((sr = SeedRecord.read((DataInput)dis, (int)4096)) instanceof DataRecord)) {
                    continue;
                }
                data.add((DataRecord)sr);
            }
        }
        catch (EOFException eOFException) {
            return FissuresConvert.toFissures(data.toArray(new DataRecord[0]));
        }
    }

    public static List<LocalSeismogramImpl> toFissures(List<DataRecord> seed) throws SeedFormatException, FissuresException {
        ArrayList<LocalSeismogramImpl> out = new ArrayList<LocalSeismogramImpl>();
        ArrayList<DataRecord> contiguous = new ArrayList<DataRecord>();
        DataRecord prev = null;
        for (DataRecord dr : seed) {
            if (prev != null && !RangeTool.areContiguous(FissuresConvert.getTimeRange(prev.getHeader().getBtimeRange()), FissuresConvert.getTimeRange(dr.getHeader().getBtimeRange()), FissuresConvert.convertSampleRate(prev).getPeriod())) {
                LocalSeismogramImpl seis = FissuresConvert.toFissuresSeismogram(contiguous);
                out.add(seis);
                contiguous.clear();
            }
            contiguous.add(dr);
            prev = dr;
        }
        if (contiguous.size() != 0) {
            LocalSeismogramImpl seis = FissuresConvert.toFissuresSeismogram(contiguous);
            out.add(seis);
        }
        return out;
    }

    public static LocalSeismogramImpl toFissuresSeismogram(List<DataRecord> seed) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = null;
        for (DataRecord dataRecord : seed) {
            if (seis == null) {
                seis = FissuresConvert.toFissures(dataRecord);
                continue;
            }
            FissuresConvert.append(seis, dataRecord);
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord[] seed) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = FissuresConvert.toFissures(seed[0]);
        for (int i = 1; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord[] seed, byte defaultCompression, byte defaultByteOrder) throws SeedFormatException, FissuresException {
        DataRecord[] seedCopy = new DataRecord[seed.length];
        for (int i = 0; i < seed.length; ++i) {
            if (seed[i].getBlockettes(1000).length == 0) {
                seedCopy[i] = new DataRecord(seed[i]);
                Blockette1000 fakeB1000 = new Blockette1000();
                fakeB1000.setEncodingFormat(defaultCompression);
                fakeB1000.setWordOrder(defaultByteOrder);
                fakeB1000.setDataRecordLength((byte)30);
                seedCopy[i].setRecordSize(seed[i].getRecordSize() * 2);
                seedCopy[i].addBlockette((Blockette)fakeB1000);
                continue;
            }
            seedCopy[i] = seed[i];
        }
        return FissuresConvert.toFissures(seedCopy);
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord[] seed) throws SeedFormatException, FissuresException {
        for (int i = 0; i < seed.length; ++i) {
            FissuresConvert.append(seis, seed[i]);
        }
        return seis;
    }

    public static LocalSeismogramImpl append(LocalSeismogramImpl seis, DataRecord seed) throws SeedFormatException, FissuresException {
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        EncodedData[] edata = bits.encoded_values();
        for (int j = 0; j < edata.length; ++j) {
            if (edata[j] == null) {
                throw new RuntimeException("encoded data is null " + j);
            }
            seis.append_encoded(edata[j]);
            MicroSecondDate drEnd = FissuresConvert.getMicroSecondTime(seed.getHeader().getLastSampleBtime());
            seis.sampling_info = new SamplingImpl(seis.getNumPoints() - 1, drEnd.subtract(seis.getBeginTime()));
        }
        return seis;
    }

    public static LocalSeismogramImpl toFissures(DataRecord seed) throws SeedFormatException {
        DataHeader header = seed.getHeader();
        String isoTime = FissuresConvert.getISOTime(header.getStartBtime());
        ChannelId channelId = new ChannelId(new NetworkId(header.getNetworkCode().trim(), new Time(isoTime)), header.getStationIdentifier().trim(), Channel.fixLocCode((String)header.getLocationIdentifier()), header.getChannelIdentifier().trim(), new Time(isoTime));
        String seisId = channelId.network_id.network_code + ":" + channelId.station_code + ":" + channelId.site_code + ":" + channelId.channel_code + ":" + FissuresConvert.getISOTime(header.getStartBtime());
        Property[] props = new Property[]{new Property("Name", seisId)};
        SamplingImpl sampling = FissuresConvert.convertSampleRate(seed);
        TimeSeriesDataSel bits = FissuresConvert.convertData(seed);
        return new LocalSeismogramImpl(seisId, props, new Time(isoTime), header.getNumSamples(), (Sampling)sampling, (Unit)UnitImpl.COUNT, channelId, new ParameterRef[0], (Quantity[])new QuantityImpl[0], (Sampling[])new SamplingImpl[0], bits);
    }

    public static List<DataRecord> toMSeed(List<PlottableChunk> chunkList) throws SeedFormatException {
        ArrayList<DataRecord> out = new ArrayList<DataRecord>();
        int seqStart = 0;
        for (PlottableChunk chunk : chunkList) {
            ChannelId chan = new ChannelId(new NetworkId(chunk.getNetworkCode(), chunk.getBeginTime().getFissuresTime()), chunk.getStationCode(), chunk.getSiteCode(), chunk.getChannelCode(), chunk.getBeginTime().getFissuresTime());
            SamplingImpl samp = new SamplingImpl(chunk.getPixelsPerDay() * 2, DAY);
            LinkedList<DataRecord> drList = FissuresConvert.toMSeed(FissuresConvert.toEncodedData(chunk.getYData()), chan, chunk.getBeginTime().add((TimeInterval)samp.getPeriod().multiplyBy((double)chunk.getBeginPixel())), samp, seqStart);
            logger.debug((Object)("Plot toMSeed begin: " + ((DataRecord)drList.get(0)).getHeader().getStartTime()));
            out.addAll(drList);
            seqStart += drList.size();
        }
        return out;
    }

    public static List<PlottableChunk> toPlottable(List<DataRecord> drList) throws SeedFormatException, FissuresException {
        ArrayList<PlottableChunk> out = new ArrayList<PlottableChunk>();
        for (DataRecord dr : drList) {
            out.add(FissuresConvert.toPlottable(dr));
        }
        return out;
    }

    public static PlottableChunk toPlottable(DataRecord dr) throws SeedFormatException, FissuresException {
        LocalSeismogramImpl seis = FissuresConvert.toFissures(new DataRecord[]{dr});
        int[] yData = seis.get_as_longs();
        int[] xData = new int[yData.length];
        for (int i = 0; i < xData.length; ++i) {
            xData[i] = i / 2;
        }
        Plottable pData = new Plottable(xData, yData);
        int pixelsPerDay = Math.round((float)(DAY.divideBy((QuantityImpl)seis.getSampling().getPeriod()).getValue(UnitImpl.DIMENSIONLESS) / 2.0));
        IntRange seisPixelRange = SimplePlotUtil.getDayPixelRange((LocalSeismogram)seis, pixelsPerDay, seis.getBeginTime());
        PlottableChunk chunk = new PlottableChunk(pData, 0, seis.getBeginTime(), pixelsPerDay, seis.getChannelID().network_id.network_code, seis.getChannelID().station_code, seis.getChannelID().site_code, seis.getChannelID().channel_code);
        logger.debug((Object)("chunk " + ChannelIdUtil.toStringNoDates((ChannelId)seis.getChannelID()) + " " + chunk.getBeginTime() + " " + chunk.getEndTime() + " " + chunk.getBeginPixel() + " " + chunk.getNumDataPoints() + " " + chunk.getNumPixels() + " " + chunk.getPixelsPerDay()));
        return chunk;
    }

    public static SamplingImpl convertSampleRate(DataRecord seed) {
        SamplingImpl sampling;
        Blockette[] blocketts = seed.getBlockettes(100);
        if (blocketts.length != 0) {
            Blockette100 b100 = (Blockette100)blocketts[0];
            float f = b100.getActualSampleRate();
            int numPerSampling = 1;
            TimeInterval timeInterval = new TimeInterval((double)(1.0f / f), UnitImpl.SECOND);
            sampling = new SamplingImpl(numPerSampling, timeInterval);
        } else {
            DataHeader header = seed.getHeader();
            sampling = FissuresConvert.convertSampleRate(header.getSampleRateMultiplier(), header.getSampleRateFactor());
        }
        return sampling;
    }

    public static SamplingImpl convertSampleRate(int multi, int factor) {
        TimeInterval timeInterval;
        int numPerSampling;
        if (factor > 0) {
            numPerSampling = factor;
            timeInterval = new TimeInterval(1.0, UnitImpl.SECOND);
            if (multi > 0) {
                numPerSampling *= multi;
            } else {
                timeInterval = (TimeInterval)timeInterval.multiplyBy((double)(-1 * multi));
            }
        } else {
            numPerSampling = 1;
            timeInterval = new TimeInterval((double)(-1 * factor), UnitImpl.SECOND);
            if (multi > 0) {
                numPerSampling *= multi;
            } else {
                timeInterval = (TimeInterval)timeInterval.multiplyBy((double)(-1 * multi));
            }
        }
        SamplingImpl sampling = new SamplingImpl(numPerSampling, timeInterval);
        return sampling;
    }

    public static TimeSeriesDataSel convertData(DataRecord seed) throws SeedFormatException {
        Blockette1000 b1000 = (Blockette1000)seed.getUniqueBlockette(1000);
        EncodedData eData = new EncodedData((short)b1000.getEncodingFormat(), seed.getData(), seed.getHeader().getNumSamples(), !b1000.isBigEndian());
        EncodedData[] eArray = new EncodedData[]{eData};
        TimeSeriesDataSel bits = new TimeSeriesDataSel();
        bits.encoded_values(eArray);
        return bits;
    }

    public static EncodedData[] toEncodedData(int[] data) {
        if (data.length == 0) {
            return new EncodedData[0];
        }
        EncodedData[] eData = new EncodedData[(int)Math.ceil((float)data.length * 4.0f / 3968.0f)];
        for (int i = 0; i < eData.length; ++i) {
            int j;
            byte[] dataBytes = new byte[3968];
            for (j = 0; j + 992 * i < data.length && j < 992; ++j) {
                int val = data[j + 992 * i];
                dataBytes[4 * j] = (byte)((val & 0xFF000000) >> 24);
                dataBytes[4 * j + 1] = (byte)((val & 0xFF0000) >> 16);
                dataBytes[4 * j + 2] = (byte)((val & 0xFF00) >> 8);
                dataBytes[4 * j + 3] = (byte)(val & 0xFF);
            }
            eData[i] = new EncodedData(3, dataBytes, j, false);
        }
        return eData;
    }

    public static SeismogramAttrImpl convertAttributes(DataRecord seed) throws SeedFormatException {
        return FissuresConvert.toFissures(seed);
    }

    public static String getISOTime(Btime startStruct) {
        float fSecond = (float)startStruct.sec + (float)startStruct.tenthMilli / 10000.0f;
        return ISOTime.getISOString((int)startStruct.year, (int)startStruct.jday, (int)startStruct.hour, (int)startStruct.min, (float)fSecond);
    }

    public static MicroSecondDate getMicroSecondTime(Btime startStruct) {
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.set(startStruct.year, 0, startStruct.jday, startStruct.hour, startStruct.min, startStruct.sec);
        cal.set(14, 0);
        MicroSecondDate d = new MicroSecondDate(cal.getTime()).add(new TimeInterval((double)(startStruct.tenthMilli * 100), UnitImpl.MICROSECOND));
        return d;
    }

    public static Btime getBtime(MicroSecondDate date) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime((Date)date);
        Btime btime = new Btime();
        btime.tenthMilli = cal.get(14) * 10 + (int)Math.round((double)date.getMicroSeconds() / 100.0);
        btime.year = cal.get(1);
        btime.jday = cal.get(6);
        btime.hour = cal.get(11);
        btime.min = cal.get(12);
        btime.sec = cal.get(13);
        return btime;
    }

    public static MicroSecondTimeRange getTimeRange(BtimeRange bTime) {
        return new MicroSecondTimeRange(FissuresConvert.getMicroSecondTime(bTime.getBegin()), FissuresConvert.getMicroSecondTime(bTime.getEnd()));
    }

    public static byte[] toBytes(UnitImpl obj) {
        ByteArrayOutputStream byteHolder = new ByteArrayOutputStream();
        try {
            ObjectOutputStream fissuresWriter = new ObjectOutputStream(byteHolder);
            fissuresWriter.writeObject(obj);
            return byteHolder.toByteArray();
        }
        catch (IOException io) {
            throw new RuntimeException("Didn't think it was possible to get an IO exception dealing entirely with in memory streams", io);
        }
    }

    public static UnitImpl fromBytes(byte[] bytes) throws IOException {
        UnitImpl impl;
        try {
            impl = (UnitImpl)new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (ClassNotFoundException cnf) {
            throw new IllegalArgumentException("The serialized bytes passed to fromBytes must contain a serialized UnitImpl, instead it was a class we couldn't find: " + cnf.getMessage());
        }
        FissuresConvert.singletonizeUnitBase(impl);
        return impl;
    }

    private static void singletonizeUnitBase(UnitImpl impl) {
        impl.the_unit_base = UnitBase.from_int((int)impl.the_unit_base.value());
        for (int i = 0; i < impl.elements.length; ++i) {
            FissuresConvert.singletonizeUnitBase((UnitImpl)impl.elements[i]);
        }
    }
}

