/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC;

import edu.iris.Fissures.IfSeismogramDC.DataCenter;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.mockFissures.IfSeismogramDC.MockDC;
import org.omg.CORBA.UNKNOWN;

public class NamedMockSeisDC {
    public static final String SOMETIMES_AVAIL_UNKNOWN = "SometimesAvailUnknown";
    private static AvailUnknown avUn = new AvailUnknown();

    public static DataCenter create(String name) {
        if (name.equals("SometimesNoAvail")) {
            return new AvailAvailAgain();
        }
        if (name.equals(SOMETIMES_AVAIL_UNKNOWN)) {
            return avUn;
        }
        if (name.equals("Simple")) {
            return new MockDC();
        }
        if (name.equals("SometimesNoData")) {
            return new SometimesNoData();
        }
        throw new RuntimeException("No mock dc by the name of " + name + " known");
    }

    private static class SometimesNoData
    extends FailCounter {
        private SometimesNoData() {
        }

        @Override
        public LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) {
            if (this.failThisTime()) {
                return new LocalSeismogramImpl[0];
            }
            return super.retrieve_seismograms(a_filterseq);
        }
    }

    private static class AvailUnknown
    extends FailCounter {
        private AvailUnknown() {
        }

        @Override
        public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
            if (this.failThisTime()) {
                throw new UNKNOWN("The void consumes you");
            }
            return super.available_data(a_filterseq);
        }
    }

    private static class AvailAvailAgain
    extends FailCounter {
        private AvailAvailAgain() {
        }

        @Override
        public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
            if (this.failThisTime()) {
                return new RequestFilter[0];
            }
            return super.available_data(a_filterseq);
        }
    }

    private static class FailCounter
    extends MockDC {
        private int numRequests;
        private int failEvery = 10;

        private FailCounter() {
        }

        public boolean failThisTime() {
            return this.numRequests++ % this.failEvery == 0;
        }
    }
}

