/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.mockFissures.IfNetwork;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkAttr;
import edu.iris.Fissures.IfNetwork.NetworkDC;
import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockChannel;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkAccess;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkAttr;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkDC;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockNetworkFinder;
import edu.sc.seis.fissuresUtil.mockFissures.IfNetwork.MockStation;
import org.omg.CORBA.UNKNOWN;

public class NamedNetDC {
    public static final String VECTOR = "Vector";
    public static final String SINGLE_CHANNEL = "SingleChannel";
    public static final String DODGY = "Dodgy";
    public static final String EVERYBODY = "Everbody";

    public static NetworkDC create(String name) {
        if (name.equals(SINGLE_CHANNEL)) {
            return new SingleChannel();
        }
        if (name.equals(VECTOR)) {
            return new Vector();
        }
        if (name.equals(DODGY)) {
            return new Dodgy();
        }
        if (name.equals(EVERYBODY)) {
            return new Everybody();
        }
        throw new RuntimeException("No mock net dc by the name of " + name + " known");
    }

    public static class Everybody
    extends MockNetworkDC {
        public Everybody() {
            ((MockNetworkFinder)this.finder).nets = new NetworkAccess[]{MockNetworkAccess.createNetworkAccess(), MockNetworkAccess.createOtherNetworkAccess(), MockNetworkAccess.createManySplendoredNetworkAccess()};
        }
    }

    public static class Dodgy
    extends MockNetworkDC {
        public Dodgy() {
            MockNetworkAccess net = new MockNetworkAccess((NetworkAttr)MockNetworkAttr.createNetworkAttr(), (Station)MockStation.createStation(), new Channel[]{MockChannel.createChannel()}){
                int numcalls;
                {
                    this.numcalls = 0;
                }

                @Override
                public Station[] retrieve_stations() {
                    if (this.numcalls++ % 2 == 0) {
                        throw new UNKNOWN("Try again!");
                    }
                    return super.retrieve_stations();
                }
            };
            ((MockNetworkFinder)this.finder).nets = new NetworkAccess[]{net};
        }
    }

    public static class Vector
    extends MockNetworkDC {
        public Vector() {
            NetworkAccess net = MockNetworkAccess.createNetworkAccess();
            ((MockNetworkFinder)this.finder).nets = new NetworkAccess[]{net};
        }
    }

    public static class SingleChannel
    extends MockNetworkDC {
        public SingleChannel() {
            MockNetworkAccess net = new MockNetworkAccess((NetworkAttr)MockNetworkAttr.createNetworkAttr(), (Station)MockStation.createStation(), new Channel[]{MockChannel.createChannel()});
            ((MockNetworkFinder)this.finder).nets = new NetworkAccess[]{net};
        }
    }
}

