/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.map.tools;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.event.CenterEvent;
import com.bbn.openmap.event.ZoomEvent;
import com.bbn.openmap.event.ZoomListener;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.event.OriginImpl;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.map.OpenMap;
import edu.sc.seis.fissuresUtil.map.layers.ChannelChooserLayer;
import edu.sc.seis.fissuresUtil.map.tools.OpenMapTool;
import java.awt.event.MouseEvent;
import javax.swing.event.EventListenerList;

public class ZoomTool
extends OpenMapTool {
    private float zoomFactor;
    private OpenMap map;
    private EventListenerList listenerList = new EventListenerList();
    private String id = "Zoom";

    public ZoomTool(OpenMap om, float factor, String id) {
        this.zoomFactor = factor;
        this.map = om;
        if (id != null) {
            this.id = id;
        }
    }

    public void addZoomListener(ZoomListener zl) {
        this.listenerList.add(ZoomListener.class, zl);
    }

    public void removeZoomListener(ZoomListener zl) {
        this.listenerList.remove(ZoomListener.class, zl);
    }

    private void fireZoomChanged(ZoomEvent ze) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ZoomListener.class || ze == null) continue;
            ((ZoomListener)listeners[i + 1]).zoom(ze);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.isActive()) {
            MapBean mapBean = this.map.getMapBean();
            LatLonPoint llp = mapBean.getCoordinates(e);
            mapBean.center(new CenterEvent((Object)this, llp.getLatitude(), llp.getLongitude()));
            this.zoom();
        }
    }

    public void zoom() {
        this.fireZoomChanged(new ZoomEvent((Object)this, 302, this.map.getMapBean().getScale() / this.zoomFactor));
    }

    public void reset() {
        LatLonPoint center = this.map.getOriginalCenter();
        if (this.map.getEventLayer() != null && this.map.getEventLayer().getSelectedEvents().length > 0 && this.map.getWidthDegrees() > 300.0f) {
            EventAccessOperations event = this.map.getEventLayer().getSelectedEvents()[0];
            OriginImpl orig = EventUtil.extractOrigin(event);
            center.setLatitude(0.0f);
            center.setLongitude(orig.getLocation().longitude);
        }
        this.map.getMapBean().setCenter(center);
        this.fireZoomChanged(new ZoomEvent((Object)this, 302, this.map.getOriginalScale()));
        Layer[] layers = this.map.getLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!(layers[i] instanceof ChannelChooserLayer)) continue;
            ((ChannelChooserLayer)layers[i]).getChannelChooser().recheckNetworkAvailability();
            break;
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
    }

    public String getID() {
        return this.id;
    }

    public String getPrettyName() {
        return this.id;
    }
}

