/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.bag.Cut;
import edu.sc.seis.fissuresUtil.cache.CacheEvent;
import edu.sc.seis.fissuresUtil.database.NotFound;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.fissuresUtil.hibernate.EventSeismogramFileReference;
import edu.sc.seis.fissuresUtil.hibernate.NetworkDB;
import edu.sc.seis.fissuresUtil.hibernate.PrintIfNotCalledOff;
import edu.sc.seis.fissuresUtil.hibernate.SeismogramFileReference;
import edu.sc.seis.fissuresUtil.rt130.FileNameParser;
import edu.sc.seis.fissuresUtil.rt130.LeapSecondApplier;
import edu.sc.seis.fissuresUtil.rt130.PacketType;
import edu.sc.seis.fissuresUtil.rt130.RT130FileReader;
import edu.sc.seis.fissuresUtil.rt130.RT130FormatException;
import edu.sc.seis.fissuresUtil.rt130.RT130ToLocalSeismogram;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import edu.sc.seis.fissuresUtil.xml.SeismogramFileTypes;
import edu.sc.seis.fissuresUtil.xml.URLDataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.UnsupportedFileTypeException;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeismogramFileRefDB
extends AbstractHibernateDB {
    private static SeismogramFileRefDB singleton;
    protected NetworkDB chanTable = NetworkDB.getSingleton();
    private static final TimeInterval ONE_SECOND;
    private static final Logger logger;

    public void saveSeismogramToDatabase(ChannelImpl channel, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) {
        this.saveSeismogramToDatabase(new SeismogramFileReference(channel, seis, fileLocation, filetype));
    }

    public void saveSeismogramToDatabase(SeismogramFileReference seisRef) {
        SeismogramFileRefDB.getSession().save((Object)seisRef);
    }

    public void saveSeismogramToDatabase(CacheEvent event, ChannelImpl channel, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) {
        this.saveSeismogramToDatabase(new EventSeismogramFileReference(event, channel, seis, fileLocation, filetype));
    }

    public void saveSeismogramToDatabase(EventSeismogramFileReference seisRef) {
        SeismogramFileRefDB.getSession().save((Object)seisRef);
    }

    public List<EventSeismogramFileReference> getSeismogramsForEvent(CacheEvent event) {
        String query = "from " + EventSeismogramFileReference.class.getName() + " where event = :event";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        q.setEntity("event", (Object)event);
        return q.list();
    }

    public List<EventSeismogramFileReference> getSeismogramsForEventForChannel(CacheEvent event, ChannelId chan) {
        String query = "from " + EventSeismogramFileReference.class.getName() + " where event = :event and " + " networkCode = :netCode and stationCode = :staCode and siteCode = :siteCode and channelCode = :chanCode ";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        q.setEntity("event", (Object)event);
        q.setString("netCode", chan.network_id.network_code);
        q.setString("staCode", chan.station_code);
        q.setString("siteCode", chan.site_code);
        q.setString("chanCode", chan.channel_code);
        logger.debug("Before query for event: " + event.getDbid() + "  " + ChannelIdUtil.toStringNoDates((ChannelId)chan));
        List esRefList = q.list();
        logger.debug("After query for event: " + event.getDbid() + "  " + ChannelIdUtil.toStringNoDates((ChannelId)chan) + "  found:" + esRefList.size());
        return esRefList;
    }

    public URLDataSetSeismogram getDataSetSeismogram(ChannelId chan, CacheEvent event, RequestFilter rf) {
        logger.debug("getDataSetSeismogram: " + SeismogramFileRefDB.getTXID() + "  " + ChannelIdUtil.toStringNoDates((ChannelId)chan) + "  " + event + "  " + rf.start_time.date_time + "  " + rf.end_time.date_time);
        PrintIfNotCalledOff delayMessage = new PrintIfNotCalledOff(" long running getDataSetSeismogram: " + SeismogramFileRefDB.getTXID() + "  " + ChannelIdUtil.toStringNoDates((ChannelId)chan) + "  " + event + "  " + rf.start_time.date_time + "  " + rf.end_time.date_time);
        List<EventSeismogramFileReference> esRefList = this.getSeismogramsForEventForChannel(event, chan);
        ArrayList<URL> urlList = new ArrayList<URL>();
        ArrayList<SeismogramFileTypes> ftList = new ArrayList<SeismogramFileTypes>();
        for (EventSeismogramFileReference esRef : esRefList) {
            urlList.add(esRef.getFilePathAsURL());
            try {
                ftList.add(SeismogramFileTypes.fromInt(esRef.getFileType()));
            }
            catch (UnsupportedFileTypeException e) {
                throw new RuntimeException("Should not happen as only valid file types should get into the db via hibernate.", e);
            }
        }
        delayMessage.callOff();
        return new URLDataSetSeismogram(urlList.toArray(new URL[0]), ftList.toArray(new SeismogramFileTypes[0]), null, ChannelIdUtil.toStringFormatDates((ChannelId)chan), rf);
    }

    public RequestFilter[] findMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) {
        List results = this.queryDatabaseForSeismograms(requestArray, false, ignoreNetworkTimes);
        RequestFilter[] request = results.toArray(new RequestFilter[results.size()]);
        RequestFilter[] reduced = ReduceTool.merge(request);
        return reduced;
    }

    public LocalSeismogramImpl[] getMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) {
        List results = this.queryDatabaseForSeismograms(requestArray, true, ignoreNetworkTimes);
        LocalSeismogramImpl[] seis = results.toArray(new LocalSeismogramImpl[0]);
        LocalSeismogramImpl[] reduced = ReduceTool.merge(seis);
        return reduced;
    }

    public List queryDatabaseForSeismograms(RequestFilter[] request, boolean returnSeismograms, boolean ignoreNetworkTimes) {
        RequestFilter[] minimalRequest = ReduceTool.merge(request);
        ArrayList resultCollector = new ArrayList();
        for (int i = 0; i < minimalRequest.length; ++i) {
            this.queryDatabaseForSeismogram(resultCollector, minimalRequest[i], returnSeismograms, ignoreNetworkTimes);
        }
        return resultCollector;
    }

    private void queryDatabaseForSeismogram(List resultCollector, RequestFilter request, boolean returnSeismograms, boolean ignoreNetworkTimes) {
        ChannelImpl chanId;
        Cut cutter = new Cut(request);
        try {
            chanId = ignoreNetworkTimes ? this.chanTable.getChannel(request.channel_id.network_id.network_code, request.channel_id.station_code, request.channel_id.site_code, request.channel_id.channel_code, new MicroSecondDate(request.start_time)) : this.chanTable.getChannel(request.channel_id);
        }
        catch (NotFound e) {
            logger.warn("Can not find channel ID in database.");
            return;
        }
        MicroSecondDate adjustedBeginTime = new MicroSecondDate(request.start_time).subtract(ONE_SECOND);
        MicroSecondDate adjustedEndTime = new MicroSecondDate(request.end_time).add(ONE_SECOND);
        String query = "from " + SeismogramFileReference.class.getName() + " where networkCode = :netCode and stationCode = :staCode and siteCode = :siteCode and channelCode = :chanCode " + " and beginTime < :end and endTime >= :begin";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        ChannelId chanIdxxx = chanId.getId();
        q.setString("netCode", chanIdxxx.network_id.network_code);
        q.setString("staCode", chanIdxxx.station_code);
        q.setString("siteCode", chanIdxxx.site_code);
        q.setString("chanCode", chanIdxxx.channel_code);
        q.setTimestamp("end", (Date)adjustedEndTime.getTimestamp());
        q.setTimestamp("begin", (Date)adjustedBeginTime.getTimestamp());
        List databaseResults = q.list();
        if (returnSeismograms) {
            for (SeismogramFileReference seisRef : databaseResults) {
                try {
                    LocalSeismogramImpl[] curSeis;
                    File seismogramFile = new File(seisRef.getFilePath());
                    SeismogramFileTypes filetype = SeismogramFileTypes.fromInt(seisRef.getFileType());
                    if (filetype.equals(SeismogramFileTypes.RT_130)) {
                        List refTekSeis = this.getMatchingSeismogramsFromRefTek(seismogramFile.getCanonicalPath(), request.channel_id, adjustedBeginTime, adjustedEndTime);
                        curSeis = refTekSeis.toArray(new LocalSeismogramImpl[refTekSeis.size()]);
                    } else {
                        URLDataSetSeismogram urlSeis = new URLDataSetSeismogram(seismogramFile.toURL(), filetype);
                        curSeis = urlSeis.getSeismograms();
                    }
                    for (int j = 0; j < curSeis.length; ++j) {
                        LocalSeismogramImpl seis = cutter.applyEncoded(curSeis[j]);
                        if (seis == null) continue;
                        resultCollector.add(seis);
                    }
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem occured while returning seismograms from the database.\nThe problem file is located at " + seisRef.getFilePath(), e);
                }
            }
        } else {
            for (SeismogramFileReference seisRef : databaseResults) {
                RequestFilter req = new RequestFilter(chanIdxxx, new MicroSecondDate(seisRef.getBeginTime()).getFissuresTime(), new MicroSecondDate(seisRef.getEndTime()).getFissuresTime());
                if ((req = cutter.apply(req)) == null) continue;
                resultCollector.add(req);
            }
        }
    }

    private List getMatchingSeismogramsFromRefTek(String seismogramFile, ChannelId chanId, MicroSecondDate beginTime, MicroSecondDate endTime) throws IOException, RT130FormatException {
        RT130FileReader toSeismogramDataPacket = new RT130FileReader();
        File file = new File(seismogramFile);
        String fileName = file.getName();
        String unitIdNumber = file.getParentFile().getParentFile().getName();
        String yearAndDay = file.getParentFile().getParentFile().getParentFile().getName();
        MicroSecondDate fileBeginTime = FileNameParser.getBeginTime(yearAndDay, fileName);
        fileBeginTime = LeapSecondApplier.applyLeapSecondCorrection(unitIdNumber, fileBeginTime);
        PacketType[] seismogramDataPacketArray = toSeismogramDataPacket.processRT130Data(seismogramFile, true, new MicroSecondTimeRange(fileBeginTime, endTime));
        RT130ToLocalSeismogram toSeismogram = new RT130ToLocalSeismogram();
        LocalSeismogramImpl[] seis = toSeismogram.convert(seismogramDataPacketArray);
        ArrayList<LocalSeismogramImpl> matchingSeis = new ArrayList<LocalSeismogramImpl>();
        for (int i = 0; i < seis.length; ++i) {
            if (!seis[i].channel_id.channel_code.equals(chanId.channel_code) || !seis[i].getBeginTime().before((Date)endTime) || !seis[i].getEndTime().after((Date)beginTime)) continue;
            seis[i].channel_id = chanId;
            matchingSeis.add(seis[i]);
        }
        return matchingSeis;
    }

    public int removeSeismogramFromDatabase(String seisFile) {
        String query = "delete  " + SeismogramFileReference.class.getName() + " where filePath = " + seisFile;
        return SeismogramFileRefDB.getSession().createQuery(query).executeUpdate();
    }

    public static SeismogramFileRefDB getSingleton() {
        if (singleton == null) {
            singleton = new SeismogramFileRefDB();
        }
        return singleton;
    }

    static {
        ONE_SECOND = new TimeInterval(1.0, UnitImpl.SECOND);
        logger = LoggerFactory.getLogger(SeismogramFileRefDB.class);
    }
}

