/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.hibernate;

import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.hibernate.AbstractHibernateDB;
import edu.sc.seis.fissuresUtil.hibernate.PlottableChunk;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.RangeTool;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.cfg.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlottableDB
extends AbstractHibernateDB {
    private static PlottableDB singleton;
    protected static int MIN_CHUNK_SIZE;
    static String configFile;
    private static Logger logger;

    protected PlottableDB() {
    }

    public static PlottableDB getSingleton() {
        if (singleton == null) {
            singleton = new PlottableDB();
        }
        return singleton;
    }

    public List<PlottableChunk> get(MicroSecondTimeRange requestRange, ChannelId channel, int pixelsPerDay) {
        return this.get(requestRange, channel.network_id.network_code, channel.station_code, channel.site_code, channel.channel_code, pixelsPerDay);
    }

    public List<PlottableChunk> get(MicroSecondTimeRange requestRange, String network, String station, String site, String channel, int pixelsPerDay) {
        Query q = PlottableDB.getSession().createQuery("from " + PlottableChunk.class.getName() + " where " + " networkCode = :net and stationCode = :sta and siteCode = :site and channelCode = :chan " + " and pixelsPerDay = :pixelsPerDay " + " and ( beginTimestamp <= :end and endTimestamp >= :begin )");
        q.setString("net", network);
        q.setString("sta", station);
        q.setString("site", site);
        q.setString("chan", channel);
        q.setInteger("pixelsPerDay", pixelsPerDay);
        q.setTimestamp("end", (Date)requestRange.getEndTime().getTimestamp());
        q.setTimestamp("begin", (Date)requestRange.getBeginTime().getTimestamp());
        List chunks = q.list();
        return chunks;
    }

    public void put(List<PlottableChunk> chunks) {
        if (chunks.size() == 0) {
            return;
        }
        MicroSecondTimeRange stuffInDB = PlottableDB.getDroppingRange(chunks);
        List<PlottableChunk> dbChunks = this.get(stuffInDB, chunks.get(0).getNetworkCode(), chunks.get(0).getStationCode(), chunks.get(0).getSiteCode(), chunks.get(0).getChannelCode(), chunks.get(0).getPixelsPerDay());
        List<PlottableChunk> everything = new ArrayList<PlottableChunk>();
        everything.addAll(dbChunks);
        everything.addAll(chunks);
        everything = ReduceTool.merge(everything);
        everything = this.breakIntoDays(everything);
        PlottableChunk first = chunks.get(0);
        int rowsDropped = this.drop(stuffInDB, first.getNetworkCode(), first.getStationCode(), first.getSiteCode(), first.getChannelCode(), first.getPixelsPerDay());
        for (PlottableChunk plottableChunk : everything) {
            PlottableDB.getSession().save((Object)plottableChunk);
        }
    }

    public int drop(MicroSecondTimeRange requestRange, String network, String station, String site, String channel, int samplesPerDay) {
        List<PlottableChunk> indb = this.get(requestRange, network, station, site, channel, samplesPerDay);
        for (PlottableChunk plottableChunk : indb) {
            PlottableDB.getSession().delete((Object)plottableChunk);
        }
        return indb.size();
    }

    protected PlottableChunk[] getSmallChunks(MicroSecondTimeRange requestRange, String network, String station, String site, String channel, int pixelsPerDay) {
        throw new RuntimeException("Not yet implemented");
    }

    private List<PlottableChunk> breakIntoDays(List<PlottableChunk> everything) {
        ArrayList<PlottableChunk> results = new ArrayList<PlottableChunk>();
        for (PlottableChunk chunk : everything) {
            results.addAll(chunk.breakIntoDays());
        }
        return results;
    }

    private static MicroSecondTimeRange getDroppingRange(List<PlottableChunk> chunks) {
        MicroSecondTimeRange stuffInDB = RangeTool.getFullTime(chunks);
        MicroSecondDate startTime = PlottableChunk.stripToDay((Date)stuffInDB.getBeginTime());
        MicroSecondDate strippedEnd = PlottableChunk.stripToDay((Date)stuffInDB.getEndTime());
        if (!strippedEnd.equals((Object)stuffInDB.getEndTime())) {
            strippedEnd = strippedEnd.add(PlottableChunk.ONE_DAY);
        }
        return new MicroSecondTimeRange(startTime, strippedEnd);
    }

    public static void configHibernate(Configuration config) {
        logger.debug("adding to HibernateUtil   " + configFile);
        config.addResource(configFile);
    }

    static {
        MIN_CHUNK_SIZE = 100;
        configFile = "edu/sc/seis/fissuresUtil/hibernate/Plottable.hbm.xml";
        logger = LoggerFactory.getLogger(PlottableDB.class);
    }
}

