/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.exceptionHandler;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.exceptionHandler.Extractor;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class ExceptionReporterUtils {
    private static final long MB = 0x100000L;

    public static String getTrace(Throwable exception) {
        String traceString = "";
        List extractors = GlobalExceptionHandler.getExtractors();
        for (Extractor ext : extractors) {
            if (!ext.canExtract(exception)) continue;
            traceString = traceString + ext.extract(exception) + "\n";
            Throwable t = ext.getSubThrowable(exception);
            if (t == null) continue;
            traceString = traceString + ExceptionReporterUtils.getTrace(t) + "\n";
        }
        traceString = traceString + ExceptionReporterUtils.extractTrace(exception);
        return traceString;
    }

    public static String getSysInfo() {
        String sysInfo = "";
        sysInfo = sysInfo + "Date : " + new Date().toString() + "\n";
        sysInfo = sysInfo + "Date(GMT) : " + new MicroSecondDate().toString() + "\n";
        try {
            sysInfo = sysInfo + "Server offset : " + ClockUtil.getServerTimeOffset() + "\n";
        }
        catch (IOException e) {
            sysInfo = sysInfo + "Server offset : " + e.toString() + "\n";
        }
        sysInfo = sysInfo + "os.name : " + System.getProperty("os.name") + "\n";
        sysInfo = sysInfo + "os.version : " + System.getProperty("os.version") + "\n";
        sysInfo = sysInfo + "os.arch : " + System.getProperty("os.arch") + "\n";
        sysInfo = sysInfo + "java.runtime.version : " + System.getProperty("java.runtime.version") + "\n";
        sysInfo = sysInfo + "java.class.version : " + System.getProperty("java.class.version") + "\n";
        sysInfo = sysInfo + "java.class.path : " + System.getProperty("java.class.path") + "\n";
        sysInfo = sysInfo + "edu.sc.seis.gee.configuration : " + System.getProperty("edu.sc.seis.gee.configuration") + "\n";
        sysInfo = sysInfo + "user.name : " + System.getProperty("user.name") + "\n";
        sysInfo = sysInfo + "user.timeZone : " + System.getProperty("user.timeZone") + "\n";
        sysInfo = sysInfo + "user.region : " + System.getProperty("user.region") + "\n";
        sysInfo = sysInfo + "Memory : " + ExceptionReporterUtils.getMemoryUsage() + "\n";
        sysInfo = sysInfo + "\n\n\n Other Properties:\n";
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Properties props = System.getProperties();
        props.list(printWriter);
        printWriter.close();
        sysInfo = sysInfo + stringWriter.getBuffer();
        return sysInfo;
    }

    private static String extractTrace(Throwable e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        e.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String getClassName(Object o) {
        String defaultName = o.getClass().toString();
        int lastPeriod = defaultName.lastIndexOf(".");
        if (lastPeriod != -1) {
            defaultName = defaultName.substring(++lastPeriod);
        }
        return defaultName;
    }

    public static String getMemoryUsage() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L + "/" + Runtime.getRuntime().totalMemory() / 0x100000L + "/" + Runtime.getRuntime().maxMemory() / 0x100000L + " Mb";
    }
}

