/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.TimeInterval;
import edu.sc.seis.fissuresUtil.cache.EventUtil;
import edu.sc.seis.fissuresUtil.display.registrar.RelativeTimeConfig;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;

public class OriginAlignedTimeConfig
extends RelativeTimeConfig {
    @Override
    public MicroSecondTimeRange getInitialTime(DataSetSeismogram seis) {
        DataSet ds = seis.getDataSet();
        EventAccessOperations eao = ds.getEvent();
        if (eao != null) {
            TimeInterval interval;
            MicroSecondDate originTime = new MicroSecondDate(EventUtil.extractOrigin(eao).getOriginTime());
            if (this.initialTime != null) {
                interval = this.initialTime.getInterval();
            } else {
                MicroSecondDate seisEndTime = new MicroSecondDate(seis.getRequestFilter().end_time);
                interval = new TimeInterval(originTime, seisEndTime);
            }
            MicroSecondTimeRange originRange = new MicroSecondTimeRange(originTime, interval);
            return originRange.shale(this.shift, this.scale);
        }
        return super.getInitialTime(seis);
    }

    @Override
    public String getTypeOfRelativity() {
        return "Time since earthquake (h:min:s)";
    }
}

