/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display.registrar;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.BasicAmpConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LazyAmpEvent
implements AmpEvent {
    private boolean calculated = false;
    private BasicAmpConfig config;
    private AmpEvent event;
    private List calculateListeners = new ArrayList();

    public LazyAmpEvent(BasicAmpConfig config) {
        this.config = config;
    }

    @Override
    public UnitRangeImpl getAmp(DataSetSeismogram seismo) {
        this.calculate();
        return this.event.getAmp(seismo);
    }

    @Override
    public boolean contains(DataSetSeismogram seismo) {
        this.calculate();
        return this.event.contains(seismo);
    }

    @Override
    public UnitRangeImpl getAmp() {
        this.calculate();
        return this.event.getAmp();
    }

    private synchronized void calculate() {
        if (!this.calculated) {
            this.event = this.config.calculate();
            this.calculated = true;
            Iterator it = this.calculateListeners.iterator();
            while (it.hasNext()) {
                ((AmpListener)it.next()).updateAmp(this.event);
            }
        }
    }

    public synchronized void addCalculateListener(AmpListener listener) {
        if (!this.calculated) {
            this.calculateListeners.add(listener);
        } else {
            listener.updateAmp(this.event);
        }
    }

    @Override
    public DataSetSeismogram[] getSeismograms() {
        this.calculate();
        return this.event.getSeismograms();
    }
}

