/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public abstract class TextInfoDisplay
extends JPanel {
    JTextPane textPane;
    JScrollPane paneScrollPane;

    public TextInfoDisplay() {
        this.setLayout(new BorderLayout());
        this.textPane = new JTextPane();
        this.textPane.setEditable(false);
        this.paneScrollPane = new JScrollPane(this.textPane);
        this.paneScrollPane.setVerticalScrollBarPolicy(22);
        this.paneScrollPane.setMinimumSize(new Dimension(10, 15));
        this.add((Component)this.paneScrollPane, "Center");
        this.initStylesForTextPane(this.textPane);
    }

    public void appendLabelValue(Document doc, String label, String value) throws BadLocationException {
        doc.insertString(doc.getLength(), label, this.textPane.getStyle("label"));
        doc.insertString(doc.getLength(), value + "\n", this.textPane.getStyle("value"));
    }

    public void appendLine(Document doc, String value) throws BadLocationException {
        doc.insertString(doc.getLength(), value + "\n", this.textPane.getStyle("value"));
    }

    public void appendHeader(Document doc, String value) throws BadLocationException {
        doc.insertString(doc.getLength(), value + "\n", this.textPane.getStyle("header"));
    }

    public void displayProblem(String problem) {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.appendProblem(doc, problem);
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    public void appendProblem(Document doc, String problem) throws BadLocationException {
        doc.insertString(doc.getLength(), "Problem: ", this.textPane.getStyle("label"));
        doc.insertString(doc.getLength(), problem + "\n", this.textPane.getStyle("problem"));
    }

    public Document getDocument() {
        return this.textPane.getDocument();
    }

    public void clear() {
        Document doc = this.textPane.getDocument();
        try {
            doc.remove(0, doc.getLength());
            this.toTop();
        }
        catch (BadLocationException ble) {
            System.err.println("Couldn't insert message.");
        }
    }

    public void toTop() {
        int min = this.paneScrollPane.getVerticalScrollBar().getMinimum();
        this.paneScrollPane.getVerticalScrollBar().setValue(min);
        this.repaint();
    }

    protected void initStylesForTextPane(JTextPane textPane) {
        Style def = StyleContext.getDefaultStyleContext().getStyle("default");
        Style header = textPane.addStyle("header", def);
        StyleConstants.setFontFamily(header, "SansSerif");
        StyleConstants.setFontSize(header, 18);
        StyleConstants.setForeground(header, Color.green);
        Style regular = textPane.addStyle("regular", def);
        StyleConstants.setFontFamily(regular, "Serif");
        StyleConstants.setFontFamily(regular, "MonoSpaced");
        Style s = textPane.addStyle("label", regular);
        StyleConstants.setBold(s, true);
        s = textPane.addStyle("value", regular);
        s = textPane.addStyle("problem", regular);
        StyleConstants.setBold(s, true);
        StyleConstants.setForeground(s, Color.red);
        Style mono = StyleContext.getDefaultStyleContext().getStyle("default");
        StyleConstants.setFontFamily(mono, "MonoSpaced");
        mono = textPane.addStyle("mono", mono);
    }
}

