/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.UnitRangeImpl;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplayProvider;
import edu.sc.seis.fissuresUtil.display.borders.DistanceBorder;
import edu.sc.seis.fissuresUtil.display.borders.TimeBorder;
import edu.sc.seis.fissuresUtil.display.drawable.CurrentTimeFlag;
import edu.sc.seis.fissuresUtil.display.drawable.Drawable;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableSeismogram;
import edu.sc.seis.fissuresUtil.display.registrar.AmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.AmpEvent;
import edu.sc.seis.fissuresUtil.display.registrar.AmpListener;
import edu.sc.seis.fissuresUtil.display.registrar.BasicLayoutConfig;
import edu.sc.seis.fissuresUtil.display.registrar.IndividualizedAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutConfig;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutData;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutEvent;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutListener;
import edu.sc.seis.fissuresUtil.display.registrar.LayoutScaler;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.RelativeTimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeEvent;
import edu.sc.seis.fissuresUtil.display.registrar.TimeListener;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSectionDisplay
extends SeismogramDisplay
implements TimeListener,
AmpListener,
LayoutListener {
    private Map drawablePositions = new HashMap();
    private boolean swapAxes = false;
    private List drawables = new ArrayList();
    private TimeConfig tc;
    private AmpConfig ac;
    private DistanceBorder distBorder;
    private TimeBorder timeBorder;
    private HashMap seisToPixelMap;
    private LayoutConfig layout;
    private AmpEvent ampEvent;
    private TimeEvent timeEvent;
    private LayoutEvent curLayoutEvent = LayoutEvent.EMPTY_EVENT;
    private double scaling = 45.0;
    private int minSeisPixelHeight = 40;
    private CurrentTimeFlag currentTimeFlag = new CurrentTimeFlag();
    private LayoutScaler scaler = null;
    private boolean checkDrawHeight = false;
    private static final Logger logger = LoggerFactory.getLogger(RecordSectionDisplay.class);

    public RecordSectionDisplay() {
        this(false);
    }

    public RecordSectionDisplay(boolean swapAxes) {
        this.distBorder = new DistanceBorder(this);
        this.timeBorder = new TimeBorder(this, 3);
        this.add(this.timeBorder, 7);
        this.add(this.distBorder, 3);
        this.setLayout(new BasicLayoutConfig());
        this.setTimeConfig(new RelativeTimeConfig());
        this.setAmpConfig(new RMeanAmpConfig());
        this.seisToPixelMap = new HashMap();
        this.swapAxes = swapAxes;
    }

    @Override
    public SeismogramDisplayProvider createCenter() {
        DrawablePainter painter = new DrawablePainter();
        painter.addMouseMotionListener(RecordSectionDisplay.getMouseMotionForwarder());
        painter.addMouseListener(RecordSectionDisplay.getMouseForwarder());
        return painter;
    }

    public void scalingChanged(double newScaling) {
        this.scaling = newScaling;
        if (this.layout != null) {
            this.layout.setScale(newScaling / 10.0);
        }
    }

    public UnitRangeImpl getDistance() {
        return this.getLayoutConfig().getLayout().getDistance();
    }

    @Override
    public synchronized void add(DataSetSeismogram[] seismos) {
        this.tc.add(seismos);
        this.ac.add(seismos);
        for (int i = 0; i < seismos.length; ++i) {
            if (this.contains(seismos[i])) continue;
            this.drawables.add(new DrawableSeismogram((SeismogramDisplay)this, seismos[i], (Color)null));
        }
        this.layout.add(seismos);
        this.checkDrawHeight = true;
        this.revalidate();
    }

    public void setDistBorder(DistanceBorder distanceBorder, int position) {
        if (this.distBorder != null) {
            this.remove(this.distBorder);
        }
        this.distBorder = distanceBorder;
        this.add(this.distBorder, position);
    }

    public void setTimeBorder(TimeBorder timeBorder, int position) {
        if (this.timeBorder != null) {
            this.remove(this.timeBorder);
        }
        this.timeBorder = timeBorder;
        this.add(timeBorder, position);
    }

    @Override
    public void add(Drawable drawable) {
        if (!this.drawables.contains(drawable)) {
            this.drawables.add(drawable);
            this.repaint();
        }
    }

    @Override
    public void remove(Drawable drawable) {
        this.drawables.remove(drawable);
    }

    @Override
    public DrawableIterator getDrawables(MouseEvent e) {
        Insets insets = this.getInsets();
        return this.getDrawables(e.getX() - insets.left, e.getY() - insets.top);
    }

    @Override
    public void setTimeConfig(TimeConfig tc) {
        this.checkDrawHeight = true;
        if (this.tc != null) {
            this.tc.removeListener(this);
            this.tc.removeListener(this.ac);
            this.tc.remove(this.getSeismograms());
        }
        tc.add(this.getSeismograms());
        tc.addListener(this);
        tc.addListener(this.ac);
        this.tc = tc;
    }

    @Override
    public TimeConfig getTimeConfig() {
        return this.tc;
    }

    @Override
    public void setAmpConfig(AmpConfig ac) {
        this.checkDrawHeight = true;
        if (this.ac != null) {
            this.ac.removeListener(this);
            this.tc.removeListener(ac);
            this.ac.remove(this.getSeismograms());
        }
        this.ac = ac;
        if (this.tc != null) {
            this.tc.addListener(ac);
        }
        ac.addListener(this);
        ac.add(this.getSeismograms());
    }

    @Override
    public void setGlobalizedAmpConfig(AmpConfig ac) {
        this.setAmpConfig(ac);
    }

    @Override
    public void setIndividualizedAmpConfig(AmpConfig ac) {
        this.setAmpConfig(new IndividualizedAmpConfig(ac));
    }

    @Override
    public AmpConfig getAmpConfig() {
        return this.ac;
    }

    public LayoutConfig getLayoutConfig() {
        return this.layout;
    }

    public void setLayout(LayoutConfig layout) {
        if (this.layout != null) {
            this.layout.removeListener(this);
            this.layout.remove(this.getSeismograms());
        }
        if (this.getSeismograms().length > 0) {
            layout.add(this.getSeismograms());
        }
        layout.setScale(this.scaling / 10.0);
        layout.addListener(this);
        this.layout = layout;
    }

    @Override
    public synchronized DataSetSeismogram[] getSeismograms() {
        return this.drawableToDataSet(this.drawables);
    }

    @Override
    public DrawableIterator iterator(Class drawableClass) {
        return new DrawableIterator(drawableClass, this.drawables);
    }

    private DataSetSeismogram[] drawableToDataSet(List drawables) {
        ArrayList<DataSetSeismogram> dataSetSeis = new ArrayList<DataSetSeismogram>();
        DrawableIterator it = new DrawableIterator(DrawableSeismogram.class, drawables);
        while (it.hasNext()) {
            dataSetSeis.add(((DrawableSeismogram)it.next()).getSeismogram());
        }
        DataSetSeismogram[] seis = new DataSetSeismogram[dataSetSeis.size()];
        dataSetSeis.toArray(seis);
        return seis;
    }

    @Override
    public void reset() {
        this.checkDrawHeight = true;
        this.layout.reset();
        this.tc.reset();
        this.ac.reset();
    }

    @Override
    public void reset(DataSetSeismogram[] seismos) {
        this.checkDrawHeight = true;
        this.tc.reset(seismos);
        this.ac.reset(seismos);
    }

    @Override
    public synchronized void clear() {
        this.remove(this.getSeismograms());
        this.reset();
    }

    @Override
    public synchronized void remove(DataSetSeismogram[] seismos) {
        this.checkDrawHeight = true;
        ArrayList<DrawableSeismogram> removed = new ArrayList<DrawableSeismogram>();
        for (int i = 0; i < seismos.length; ++i) {
            DrawableIterator it = new DrawableIterator(DrawableSeismogram.class, this.drawables);
            while (it.hasNext()) {
                DrawableSeismogram current = (DrawableSeismogram)it.next();
                if (!current.getSeismogram().equals(seismos[i])) continue;
                removed.add(current);
            }
        }
        this.drawables.removeAll(removed);
        DataSetSeismogram[] removedSeis = this.drawableToDataSet(removed);
        this.tc.remove(removedSeis);
        this.ac.remove(removedSeis);
        this.layout.remove(removedSeis);
    }

    @Override
    public synchronized boolean contains(DataSetSeismogram seismo) {
        DataSetSeismogram[] seismos = this.getSeismograms();
        for (int i = 0; i < seismos.length; ++i) {
            if (!seismos[i].equals(seismo)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateTime(TimeEvent event) {
        this.timeEvent = event;
        this.repaint();
    }

    @Override
    public void updateAmp(AmpEvent event) {
        this.ampEvent = event;
        this.repaint();
    }

    @Override
    public void updateLayout(LayoutEvent event) {
        this.curLayoutEvent = event;
        this.repaint();
    }

    public void storePixels(LayoutData layoutData, double topLeftX, double topLeftY, double bottomRightX, double bottomRightY) {
        double[] pixelArray = new double[]{topLeftX, topLeftY, bottomRightX, bottomRightY};
        this.seisToPixelMap.put(layoutData.getSeis().getRequestFilter().channel_id, pixelArray);
    }

    public HashMap getPixelMap() {
        return this.seisToPixelMap;
    }

    public boolean getSwapAxes() {
        return this.swapAxes;
    }

    public int getMinSeisPixelHeight() {
        return this.minSeisPixelHeight;
    }

    public void setMinSeisPixelHeight(int minPixelHeight) {
        this.checkDrawHeight = true;
        this.minSeisPixelHeight = minPixelHeight;
    }

    public void checkSeismogramHeight(Dimension size) {
        LayoutData current;
        double drawHeight;
        Iterator it = this.curLayoutEvent.iterator();
        int height = size.height;
        if (it.hasNext() && (drawHeight = ((current = (LayoutData)it.next()).getEnd() - current.getStart()) * (double)height) < (double)this.minSeisPixelHeight && this.checkDrawHeight) {
            if (drawHeight == 0.0) {
                drawHeight = 1.0;
                logger.warn("pixel height from LayoutConfig is 0, should always be >0");
            }
            double percentIncreaseNeeded = (double)this.minSeisPixelHeight / drawHeight;
            if (this.scaler != null) {
                this.scaler.increaseScale(percentIncreaseNeeded);
            } else {
                this.scalingChanged(this.scaling * percentIncreaseNeeded);
            }
            this.checkDrawHeight = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawSeismograms(Graphics2D g2, Dimension size) {
        RecordSectionDisplay recordSectionDisplay = this;
        synchronized (recordSectionDisplay) {
            this.checkSeismogramHeight(size);
            int width = size.width;
            int height = size.height;
            if (this.swapAxes) {
                AffineTransform at = new AffineTransform();
                at.translate(width / 2, height / 2);
                at.rotate(-1.5707963267948966);
                at.translate(-height / 2, -width / 2);
                g2.transform(at);
                int temp = width;
                width = height;
                height = temp;
            }
            g2.setColor(Color.WHITE);
            g2.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            Iterator it = this.curLayoutEvent.iterator();
            while (it.hasNext()) {
                LayoutData current = (LayoutData)it.next();
                double curEnd = current.getEnd();
                double curStart = current.getStart();
                double drawHeight = (curEnd - curStart) * (double)height;
                double midPoint = curStart * (double)height + drawHeight / 2.0;
                double topLeftY = Math.abs(curStart * (double)height);
                double bottomRightY = curEnd * (double)height;
                double distBorderWidth = this.distBorder.getWidth();
                this.storePixels(current, distBorderWidth, topLeftY, (double)width + distBorderWidth, bottomRightY);
                double neededYPos = midPoint - drawHeight / 2.0;
                if (neededYPos < 0.0 && !this.swapAxes) {
                    neededYPos = 0.0;
                }
                g2.translate(0.0, neededYPos);
                if (this.isPDF) {
                    g2.scale(0.25, 0.25);
                }
                Dimension drawSize = new Dimension((this.isPDF ? 4 : 1) * width, (int)((this.isPDF ? 4.0 : 1.0) * drawHeight));
                DrawableSeismogram cur = this.toDrawable(current.getSeis());
                if (cur == null) continue;
                cur.draw(g2, drawSize, this.timeEvent, this.ampEvent);
                if (this.isPDF) {
                    g2.scale(4.0, 4.0);
                }
                g2.translate(0.0, -neededYPos);
                if (this.drawNamesForNamedDrawables) {
                    cur.drawName(g2, 5, (int)(neededYPos + drawHeight / 2.0));
                }
                int[] yPos = new int[]{(int)neededYPos, (int)(neededYPos + drawHeight)};
                this.drawablePositions.put(cur, yPos);
            }
            for (Drawable current : this.drawables) {
                if (current instanceof DrawableSeismogram) continue;
                current.draw(g2, size, this.timeEvent, this.ampEvent);
            }
            if (RecordSectionDisplay.getCurrentTimeFlag()) {
                this.currentTimeFlag.draw(g2, size, this.timeEvent, this.ampEvent);
            }
        }
    }

    public DrawableIterator getDrawables(int x, int y) {
        Iterator it = this.drawablePositions.keySet().iterator();
        ArrayList drawablesIntersected = new ArrayList();
        while (it.hasNext()) {
            Object cur = it.next();
            int[] yPositions = (int[])this.drawablePositions.get(cur);
            if (yPositions[0] > y || yPositions[1] < y) continue;
            drawablesIntersected.add(cur);
        }
        return new DrawableIterator(Drawable.class, drawablesIntersected);
    }

    public DrawableSeismogram toDrawable(DataSetSeismogram seis) {
        DrawableIterator it = new DrawableIterator(DrawableSeismogram.class, this.drawables);
        DrawableSeismogram current = null;
        while (it.hasNext()) {
            current = (DrawableSeismogram)it.next();
            if (!current.getSeismogram().equals(seis)) continue;
            return current;
        }
        return current;
    }

    @Override
    public void print() {
        JOptionPane.showMessageDialog(this, "Sorry!  Record section output to PDF is not available in this version of GEE.\nThis feature will be added in a future release.", "Not available in this version", 1);
    }

    public void setParticleAllowed(boolean allowed) {
    }

    public void setLayoutScaler(LayoutScaler scaler) {
        this.scaler = scaler;
    }

    private class DrawablePainter
    extends SeismogramDisplayProvider {
        private DrawablePainter() {
        }

        @Override
        public SeismogramDisplay provide() {
            return RecordSectionDisplay.this;
        }

        @Override
        public void paintComponent(Graphics g) {
            RecordSectionDisplay.this.drawSeismograms((Graphics2D)g, this.getSize());
        }
    }
}

