/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.NamedColor;
import edu.sc.seis.fissuresUtil.display.VerticalSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.registrar.RMeanAmpConfig;
import edu.sc.seis.fissuresUtil.display.registrar.TimeConfig;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import java.awt.Color;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickZoneDisplay
extends VerticalSeismogramDisplay {
    private static final Logger logger = LoggerFactory.getLogger(PickZoneDisplay.class);

    @Override
    public void add(DataSetSeismogram[] dss) {
        for (int i = 0; i < dss.length; ++i) {
            this.add(dss[i]);
        }
    }

    public void add(DataSetSeismogram seis) {
        block0: for (int i = 0; i < this.getCenter().getComponentCount(); ++i) {
            BasicSeismogramDisplay cur = (BasicSeismogramDisplay)this.getCenter().getComponent(i);
            if (cur.contains(seis)) continue;
            DataSetSeismogram[] contained = cur.getSeismograms();
            for (int j = 0; j < contained.length; ++j) {
                if (!DisplayUtils.areFriends(contained[j], seis)) continue;
                DataSetSeismogram[] newSeis = new DataSetSeismogram[]{seis};
                cur.add(newSeis);
                continue block0;
            }
        }
    }

    public void add(DataSetSeismogram[] seis, TimeConfig tc, Color color) {
        NamedColor untransparent = new NamedColor(color.getRed(), color.getBlue(), color.getGreen(), 255, color.toString());
        BasicSeismogramDisplay disp = new BasicSeismogramDisplay(tc, new RMeanAmpConfig(), untransparent);
        disp.setParentDisplay(this);
        disp.add(seis, untransparent);
        this.getCenter().add(disp);
        this.revalidate();
        this.setBorders();
    }
}

