/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauP_Time;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PhasePhilter {
    public static List<Arrival> filter(List<Arrival> arrivals, TimeInterval offset) {
        LinkedList<Arrival> list = new LinkedList<Arrival>();
        for (Arrival a : arrivals) {
            list.add(a);
        }
        for (int i = 0; i < list.size(); ++i) {
            ListIterator<Arrival> it = list.listIterator(i);
            Arrival a = it.next();
            while (it.hasNext()) {
                Arrival b = it.next();
                if (!b.getName().equals(a.getName()) || !(Math.abs(b.getTime() - a.getTime()) < offset.convertTo((UnitImpl)UnitImpl.SECOND).value)) continue;
                it.remove();
            }
        }
        return list;
    }

    public static List<Arrival> mindPsAndSs(List<Arrival> arrivals) {
        List pPhases = TauP_Time.getPhaseNames((String)"ttp");
        List sPhases = TauP_Time.getPhaseNames((String)"tts");
        boolean foundP = false;
        boolean foundS = false;
        ArrayList<Arrival> resultantArrivals = new ArrayList<Arrival>();
        for (Arrival arrival : arrivals) {
            if (pPhases.contains(arrival.getName())) {
                if (foundP) continue;
                resultantArrivals.add(arrival);
                foundP = true;
                continue;
            }
            if (sPhases.contains(arrival.getName())) {
                if (foundS) continue;
                resultantArrivals.add(arrival);
                foundS = true;
                continue;
            }
            resultantArrivals.add(arrival);
        }
        return resultantArrivals;
    }

    public static class PhaseRenamer {
        private Pattern[] matchers = new Pattern[0];
        private String[] replacements = new String[0];

        public PhaseRenamer() {
        }

        public PhaseRenamer(Node n) throws TransformerException {
            NodeList nl = XPathAPI.selectNodeList((Node)n, (String)"mapping");
            this.matchers = new Pattern[nl.getLength()];
            this.replacements = new String[nl.getLength()];
            for (int i = 0; i < nl.getLength(); ++i) {
                Element el = (Element)nl.item(i);
                this.matchers[i] = Pattern.compile(PhaseRenamer.extractValue(el, "pattern/text()"));
                this.replacements[i] = PhaseRenamer.extractValue(el, "replacement/text()");
            }
        }

        public PhaseRenamer(Pattern[] patterns, String[] replacements) {
            this.matchers = patterns;
            this.replacements = replacements;
        }

        private static String extractValue(Element el, String xpath) throws TransformerException {
            return XPathAPI.selectSingleNode((Node)el, (String)xpath).getNodeValue();
        }

        public String rename(Arrival a) {
            for (int i = 0; i < this.matchers.length; ++i) {
                if (!this.matchers[i].matcher(a.getName()).find()) continue;
                return this.replacements[i];
            }
            return a.getName();
        }
    }
}

