/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.display;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;

public class ComponentPrintable
implements Printable {
    private Thread printing;
    private Component mComponent;

    public ComponentPrintable(Component c) {
        this.mComponent = c;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        pageFormat.setOrientation(0);
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        boolean wasBuffered = this.disableDoubleBuffering(this.mComponent);
        this.mComponent.paint(g2);
        this.restoreDoubleBuffering(this.mComponent, wasBuffered);
        return 0;
    }

    private boolean disableDoubleBuffering(Component c) {
        if (!(c instanceof JComponent)) {
            return false;
        }
        JComponent jc = (JComponent)c;
        boolean wasBuffered = jc.isDoubleBuffered();
        jc.setDoubleBuffered(false);
        return wasBuffered;
    }

    private void restoreDoubleBuffering(Component c, boolean wasBuffered) {
        if (c instanceof JComponent) {
            ((JComponent)c).setDoubleBuffered(wasBuffered);
        }
    }
}

