/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.time.ReduceTool;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StationDataSummary
implements Comparable {
    private String stationCode;
    private Map timeRangesByChannelCode;

    public StationDataSummary(String stationCode, Map timeRangesByChannelCode) {
        this.stationCode = stationCode;
        this.timeRangesByChannelCode = timeRangesByChannelCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public MicroSecondTimeRange[] getRecordedTimes() {
        Iterator it = this.timeRangesByChannelCode.keySet().iterator();
        ArrayList allTimeRanges = new ArrayList();
        while (it.hasNext()) {
            allTimeRanges.addAll((List)this.timeRangesByChannelCode.get(it.next()));
        }
        return ReduceTool.merge(allTimeRanges.toArray(new MicroSecondTimeRange[0]));
    }

    public MicroSecondTimeRange getEncompassingTimeRange() {
        MicroSecondTimeRange result = null;
        Set channelCodeSet = this.timeRangesByChannelCode.keySet();
        Iterator it = channelCodeSet.iterator();
        while (it.hasNext()) {
            for (MicroSecondTimeRange newTimeRange : (List)this.timeRangesByChannelCode.get(it.next())) {
                if (result == null) {
                    result = newTimeRange;
                    continue;
                }
                result = new MicroSecondTimeRange(newTimeRange, result);
            }
        }
        return result;
    }

    public void printGapDescription(PrintWriter reportStream) {
        for (String channelCode : this.timeRangesByChannelCode.keySet()) {
            for (MicroSecondTimeRange timeRange : (List)this.timeRangesByChannelCode.get(channelCode)) {
                reportStream.print("    ");
                reportStream.print(this.stationCode);
                reportStream.print(" ");
                reportStream.print(channelCode);
                reportStream.print(" ");
                reportStream.print(timeRange.getBeginTime().toString());
                reportStream.print(" - ");
                reportStream.println(timeRange.getEndTime().toString());
            }
        }
    }

    public void printDaysOfCoverage(PrintWriter reportStream) {
        for (String channelCode : this.timeRangesByChannelCode.keySet()) {
            if (!channelCode.equals("BHZ")) continue;
            TimeInterval total = null;
            for (MicroSecondTimeRange timeRange : (List)this.timeRangesByChannelCode.get(channelCode)) {
                if (total == null) {
                    total = timeRange.getInterval();
                    continue;
                }
                total = total.add(timeRange.getInterval());
            }
            DecimalFormat decFormat = new DecimalFormat();
            decFormat.setMaximumFractionDigits(2);
            decFormat.setMinimumFractionDigits(2);
            reportStream.print("    ");
            reportStream.print(this.stationCode);
            if (total == null) {
                reportStream.print(" - The BHZ channel for this station recorded no time.");
                continue;
            }
            reportStream.print(" covers ");
            double doubleDays = total.getValue(UnitImpl.DAY);
            String stringDays = decFormat.format(doubleDays);
            reportStream.print(stringDays);
            if (doubleDays > 1.0049) {
                reportStream.print(" days.");
                continue;
            }
            reportStream.print(" day.");
        }
    }

    public int compareTo(Object o) {
        if (o instanceof StationDataSummary) {
            return ((StationDataSummary)o).stationCode.compareTo(this.stationCode) * -1;
        }
        return 1;
    }
}

