/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database.seismogram;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.Fissures.seismogramDC.SeismogramAttrImpl;
import edu.sc.seis.fissuresUtil.chooser.ThreadSafeDecimalFormat;
import edu.sc.seis.fissuresUtil.database.seismogram.PopulationProperties;
import edu.sc.seis.fissuresUtil.database.seismogram.RT130Report;
import edu.sc.seis.fissuresUtil.mseed.FissuresConvert;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandler;
import edu.sc.seis.fissuresUtil.rt130.RT130FileHandlerFlag;
import edu.sc.seis.fissuresUtil.sac.SacToFissures;
import edu.sc.seis.fissuresUtil.simple.Initializer;
import edu.sc.seis.seisFile.mseed.DataRecord;
import edu.sc.seis.seisFile.mseed.SeedFormatException;
import edu.sc.seis.seisFile.mseed.SeedRecord;
import edu.sc.seis.seisFile.sac.SacTimeSeries;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RT130ReportGenerator {
    private static ThreadSafeDecimalFormat decFormat = new ThreadSafeDecimalFormat("000.00%");
    private static boolean showProgress = false;
    private static long numFilesTotal = 0L;
    private static long numFilesRead = 0L;
    public static final String BASE_FILE_SYSTEM_LOCATION = "seismogramDir";
    private static RT130FileHandler fileHandler;
    private static RT130Report report;
    private static Properties props;
    private static final Logger logger;

    public static void main(String[] args) throws FissuresException, IOException, SeedFormatException, ParseException {
        int j;
        int i;
        props = Initializer.loadProperties(args);
        PropertyConfigurator.configure((Properties)props);
        boolean finished = false;
        RT130FileHandlerFlag scanMode = RT130FileHandlerFlag.SCAN;
        String reportName = null;
        Date start = null;
        Date end = null;
        HashSet<String> codes = null;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < args.length; ++i) {
            if (args[i].equals("-props")) {
                ++i;
                continue;
            }
            if (args[i].equals("-start")) {
                start = df.parse(args[++i]);
                continue;
            }
            if (args[i].equals("-end")) {
                end = df.parse(args[++i]);
                continue;
            }
            if (args[i].equals("-stations")) {
                codes = new HashSet<String>();
                String[] stations = args[++i].split(",");
                for (j = 0; j < stations.length; ++j) {
                    codes.add(stations[j]);
                }
                continue;
            }
            if (args[i].equals("-full")) {
                scanMode = RT130FileHandlerFlag.FULL;
                continue;
            }
            if (args[i].equals("-scan")) {
                scanMode = RT130FileHandlerFlag.SCAN;
                continue;
            }
            if (args[i].equals("-h") || args[i].equals("-help")) {
                RT130ReportGenerator.printHelp();
                continue;
            }
            if (args[i].equals("-n") || args[i].equals("-name")) {
                reportName = args[++i];
                continue;
            }
            if (args[i].equals("-progress")) {
                showProgress = true;
                continue;
            }
            if (!args[i].startsWith("-")) break;
            System.out.println("Don't understand argument '" + args[i] + "'");
            RT130ReportGenerator.printHelp();
        }
        logger.debug("RT130 mode: " + scanMode);
        ArrayList<File> files = new ArrayList<File>();
        j = 0;
        while (j + i < args.length) {
            files.add(new File(args[i + j]));
            ++j;
        }
        if (showProgress) {
            for (File file : files) {
                logger.info("Counting the number of total files in " + file);
                if (file.isDirectory()) {
                    finished = RT130ReportGenerator.countEntireDirectory(file);
                    continue;
                }
                if (!file.isFile()) continue;
                ++numFilesTotal;
            }
            System.out.print(decFormat.format(0L));
        }
        report = new RT130Report(start, end, codes);
        LinkedList<RT130FileHandlerFlag> flags = new LinkedList<RT130FileHandlerFlag>();
        flags.add(scanMode);
        fileHandler = new RT130FileHandler(props, flags, report);
        for (File file : files) {
            if (file.isDirectory()) {
                finished = RT130ReportGenerator.readEntireDirectory(file);
                continue;
            }
            if (file.isFile()) {
                finished = RT130ReportGenerator.readSingleFile(file);
                continue;
            }
            logger.error("File: " + file + " is not a file or a directory. This can" + " be caused in Windows when the file path includes" + " a Unix-style reference (soft or hard).");
        }
        if (finished) {
            if (showProgress) {
                System.out.print("\b\b\b\b\b\b\b" + decFormat.format(1L));
            }
            System.out.println();
            System.out.println("Report generation complete.");
            System.out.println();
            report.outputReport(reportName);
        } else {
            RT130ReportGenerator.printHelp();
        }
    }

    private static boolean readSingleFile(File file) throws IOException, FissuresException, SeedFormatException, ParseException {
        String fileLoc = file.getCanonicalPath();
        if (showProgress) {
            double percentage = (double)numFilesRead / (double)numFilesTotal;
            System.out.print("\b\b\b\b\b\b\b");
            System.out.print(decFormat.format(percentage));
        }
        ++numFilesRead;
        String fileName = file.getName();
        if (fileName.length() == 18 && fileName.charAt(9) == '_') {
            return fileHandler.handle(file);
        }
        if (fileName.endsWith(".mseed")) {
            return RT130ReportGenerator.processMSeed(fileLoc, fileName);
        }
        if (fileName.endsWith(".sac")) {
            return RT130ReportGenerator.processSac(fileLoc, fileName, props);
        }
        if (fileName.equals("SOH.RT") || fileName.equals("soh.rt")) {
            logger.debug("Ignoring Ref Tek file: " + fileName);
        } else if (fileName.equals(".DS_Store") || fileName.equals("._501") || fileName.equals("._504")) {
            logger.debug("Ignoring Mac OS X file: " + fileName);
        } else {
            report.addUnsupportedFileException(fileLoc, fileName + " can not be processed because it's file" + " name is not formatted correctly, and therefore" + " is assumed to be an invalid file format. If" + " the data file format is valid (mini seed, sac, rt130)" + " try renaming the file.");
            logger.debug(fileName + " can not be processed because it's file" + " name is not formatted correctly, and therefore" + " is assumed to be an invalid file format. If" + " the data file format is valid (mini seed, sac, rt130)" + " try renaming the file.");
        }
        return false;
    }

    private static boolean countEntireDirectory(File baseDirectory) throws FissuresException, IOException, SeedFormatException, ParseException {
        File[] files = baseDirectory.listFiles();
        if (files == null) {
            throw new IOException("Unable to get listing of directory: " + baseDirectory);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                RT130ReportGenerator.countEntireDirectory(files[i]);
                continue;
            }
            ++numFilesTotal;
        }
        return true;
    }

    private static boolean readEntireDirectory(File baseDirectory) throws FissuresException, IOException, SeedFormatException, ParseException {
        File[] files = baseDirectory.listFiles();
        if (files == null) {
            throw new IOException("Unable to get listing of directory: " + baseDirectory);
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                RT130ReportGenerator.readEntireDirectory(files[i]);
                continue;
            }
            RT130ReportGenerator.readSingleFile(files[i]);
        }
        return true;
    }

    private static void printHelp() {
        System.out.println();
        System.out.println("    The default SOD properties file is server.properties.");
        System.out.println("    The default database properties file is server.properties.");
        System.out.println();
        System.out.println("    -props     | Accepts alternate properties file.");
        System.out.println("    -hsql      | Accepts alternate database properties file.");
        System.out.println("    -name      | Accepts alternate report name.");
        System.out.println("               |   The default name is in the format yyyy-mm-dd_RT130Report.");
        System.out.println("    -n         | See: -name");
        System.out.println("    -full      | Turn on full processing of RT130 data.");
        System.out.println("    -scan      | Turn on scan processing of RT130 data.");
        System.out.println("               |   Scan processing of RT130 data is on by default.");
        System.out.println("               |   No other types of data can be processed using scan method.");
        System.out.println("    -help      | Displays this message.");
        System.out.println("    -h         | See: -help");
        System.out.println("    -progress  | Show percentage complete.");
        System.out.println();
        System.out.println();
        System.out.println("Program finished before the report was created.");
        System.out.println();
        System.exit(0);
    }

    private static boolean processSac(String fileLoc, String fileName, Properties props) throws IOException, FissuresException {
        SacTimeSeries sacTime = new SacTimeSeries();
        try {
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc)));
            sacTime = new SacTimeSeries((DataInput)dis);
            dis.close();
        }
        catch (EOFException e) {
            report.addFileFormatException(fileLoc, fileName + " seems to be an invalid sac file." + "\n" + e.getMessage());
            logger.error(fileName + " seems to be an invalid sac file." + "\n" + e.getMessage());
            return false;
        }
        catch (FileNotFoundException e) {
            report.addFileFormatException(fileLoc, "Unable to find file " + fileName + "\n" + e.getMessage());
            logger.error("Unable to find file " + fileName + "\n" + e.getMessage());
            return false;
        }
        SeismogramAttrImpl seis = SacToFissures.getSeismogramAttr(sacTime);
        ChannelImpl chan = SacToFissures.getChannel(sacTime);
        chan = PopulationProperties.fix((Channel)chan, props);
        report.addSacSeismogram((Channel)chan, seis.getBeginTime(), seis.getEndTime());
        return true;
    }

    private static boolean processMSeed(String fileLoc, String fileName) throws IOException, SeedFormatException, FissuresException {
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(fileLoc)));
        }
        catch (FileNotFoundException e) {
            report.addFileFormatException(fileLoc, "Unable to find file " + fileName + "\n" + e.getMessage());
            logger.error("Unable to find file " + fileName + "\n" + e.getMessage());
            return false;
        }
        LinkedList<DataRecord> list = new LinkedList<DataRecord>();
        try {
            SeedRecord dr = SeedRecord.read((DataInput)dis);
            if (dr instanceof DataRecord) {
                list.add((DataRecord)dr);
            }
        }
        catch (EOFException dr) {
            // empty catch block
        }
        LocalSeismogramImpl seis = FissuresConvert.toFissures(list.toArray(new DataRecord[0]));
        report.addMSeedSeismogram(seis.channel_id, seis.getBeginTime(), seis.getEndTime());
        return true;
    }

    static {
        logger = LoggerFactory.getLogger(RT130ReportGenerator.class);
    }
}

