/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.database;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfSeismogramDC.DataCenterCallBack;
import edu.iris.Fissures.IfSeismogramDC.DataCenterOperations;
import edu.iris.Fissures.IfSeismogramDC.LocalSeismogram;
import edu.iris.Fissures.IfSeismogramDC.RequestFilter;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.iris.dmc.seedcodec.CodecException;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.database.DataCenterThread;
import edu.sc.seis.fissuresUtil.database.HSQLRequestFilterDb;
import edu.sc.seis.fissuresUtil.database.LocalDCOperations;
import edu.sc.seis.fissuresUtil.database.LocalDataCenterCallBack;
import edu.sc.seis.fissuresUtil.time.CoverageTool;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBDataCenter
implements DataCenterOperations,
LocalDCOperations {
    private WorkerThreadPool dcThreadPool = new WorkerThreadPool("DBDataCenter", 5);
    private Map clientToThread = new HashMap();
    private DataCenterOperations dataCenter;
    private HSQLRequestFilterDb hsqlRequestFilterDb;
    private static DBDataCenter dbDataCenter;
    private int requestNumber = 1;
    private static Logger logger;

    private DBDataCenter(String directoryName, String databaseName, DataCenterOperations dataCenterRouter) throws SQLException {
        this.dataCenter = dataCenterRouter;
        this.hsqlRequestFilterDb = new HSQLRequestFilterDb(directoryName, databaseName, dataCenterRouter);
    }

    private DBDataCenter(String directoryName, String databaseName) throws SQLException {
        this.hsqlRequestFilterDb = new HSQLRequestFilterDb(directoryName, databaseName);
    }

    public static DBDataCenter getDataCenter(String directoryName, String databaseName, DataCenterOperations dataCenterRouter) throws SQLException {
        if (dbDataCenter == null) {
            dbDataCenter = new DBDataCenter(directoryName, databaseName, dataCenterRouter);
        }
        return dbDataCenter;
    }

    public static DBDataCenter getDataCenter(String directoryName, String databaseName) throws SQLException {
        if (dbDataCenter == null) {
            dbDataCenter = new DBDataCenter(directoryName, databaseName);
        }
        return dbDataCenter;
    }

    @Override
    public RequestFilter[] available_data(RequestFilter[] a_filterseq) {
        return this.dataCenter.available_data(a_filterseq);
    }

    public String request_seismograms(RequestFilter[] a_filterseq, DataCenterCallBack a_client, boolean long_lived, Time expiration_time) {
        return this.getNextRequestId();
    }

    @Override
    public String request_seismograms(RequestFilter[] a_filterseq, LocalDataCenterCallBack a_client, SeisDataChangeListener initiator, boolean long_lived, Time expiration_time) {
        DataCenterThread dcThread = (DataCenterThread)this.clientToThread.get(a_client);
        if (dcThread == null || !dcThread.getData(initiator, a_filterseq)) {
            dcThread = new DataCenterThread(a_filterseq, a_client, initiator, this);
            this.clientToThread.put(a_client, dcThread);
            this.dcThreadPool.invokeLater(dcThread);
            DataCenterThread.incrementWaiters();
        }
        return this.getNextRequestId();
    }

    @Override
    public synchronized LocalSeismogram[] retrieve_seismograms(RequestFilter[] a_filterseq) throws FissuresException {
        LocalSeismogramImpl[] localSeismograms = new LocalSeismogramImpl[]{};
        try {
            localSeismograms = this.hsqlRequestFilterDb.getSeismograms(a_filterseq);
        }
        catch (SQLException e) {
            logger.error("Problem retriieving from DBDataCenter, using remote datacenter instead: request is:\n" + DBDataCenter.requestToString(a_filterseq), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Problem retriieving from DBDataCenter, using remote datacenter instead: request is:\n" + DBDataCenter.requestToString(a_filterseq), (Throwable)e);
        }
        RequestFilter[] uncovered = CoverageTool.notCovered(a_filterseq, localSeismograms);
        if (uncovered.length == 0) {
            return localSeismograms;
        }
        ArrayList seisToReturn = new ArrayList(localSeismograms.length);
        this.insertIntoList(seisToReturn, (LocalSeismogram[])localSeismograms);
        if (this.dataCenter != null) {
            localSeismograms = (LocalSeismogramImpl[])this.dataCenter.retrieve_seismograms(uncovered);
            try {
                this.hsqlRequestFilterDb.addSeismogram(localSeismograms);
            }
            catch (SQLException e) {
                logger.error("Problem storing seismograms in local cache database.", (Throwable)e);
            }
            catch (CodecException e) {
                logger.error("Problem storing seismograms in local cache database.", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Problem storing seismograms in local cache database.", (Throwable)e);
            }
        }
        if (localSeismograms.length > 0) {
            this.insertIntoList(seisToReturn, (LocalSeismogram[])localSeismograms);
        }
        LocalSeismogram[] rtnValues = new LocalSeismogram[seisToReturn.size()];
        rtnValues = seisToReturn.toArray(rtnValues);
        return rtnValues;
    }

    public static String requestToString(RequestFilter[] a_filterseq) {
        String request = "";
        for (int i = 0; i < a_filterseq.length; ++i) {
            request = request + "\n" + ChannelIdUtil.toString((ChannelId)a_filterseq[i].channel_id) + " from " + a_filterseq[i].start_time.date_time + " to " + a_filterseq[i].end_time.date_time;
        }
        return request;
    }

    private void insertIntoList(List list, LocalSeismogram[] localSeismograms) {
        for (int counter = 0; counter < localSeismograms.length; ++counter) {
            list.add(localSeismograms[counter]);
        }
    }

    @Override
    public String queue_seismograms(RequestFilter[] a_filterseq) {
        return this.getNextRequestId();
    }

    @Override
    public LocalSeismogram[] retrieve_queue(String a_request) {
        return new LocalSeismogram[0];
    }

    @Override
    public void cancel_request(String a_request) {
    }

    @Override
    public String request_status(String a_request) {
        return new String();
    }

    public String getFileIds(ChannelId channelId, MicroSecondDate beginDate, MicroSecondDate endDate) throws SQLException {
        return this.hsqlRequestFilterDb.getFileIds(channelId, beginDate, endDate);
    }

    public LocalSeismogram getSeismogram(String fileIds) throws SQLException, IOException, FissuresException {
        return this.hsqlRequestFilterDb.getSeismogram(fileIds);
    }

    String getNextRequestId() {
        return "requestId" + this.requestNumber;
    }

    static {
        logger = LoggerFactory.getLogger(DBDataCenter.class);
    }
}

