/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.chooser;

import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.network.ChannelIdUtil;
import edu.iris.Fissures.network.ChannelImpl;
import edu.sc.seis.TauP.SphericalCoords;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BestChannelUtil {
    public static final String[] DEFAULT_SITE_CODE_HEURISTIC = new String[]{"00", "  ", "", "01", "02", "10"};
    public static final String[] DEFAULT_GAIN_CODE_HEURISTIC = new String[]{"H", "L"};
    public static final String[] DEFAULT_BAND_CODE_HEURISTIC = new String[]{"B", "H", "L", "M", "S", "V", "E", "U"};
    public static final String[] DEFAULT_ORIENTATION_CODES = new String[]{"Z", "N", "E", "1", "2", "3", "U", "V", "W"};
    public static final float DEFAULT_MAX_DIP_OFFSET = 5.0f;
    protected String[] siteCodeHeuristic = DEFAULT_SITE_CODE_HEURISTIC;
    protected String[] gainCodeHeuristic = DEFAULT_GAIN_CODE_HEURISTIC;
    protected String[] bandCodeHeuristic = DEFAULT_BAND_CODE_HEURISTIC;
    protected String[] orientationCodeHeuristic = DEFAULT_ORIENTATION_CODES;
    protected float maxDipOffset = 5.0f;
    private static Logger logger = LoggerFactory.getLogger((String)BestChannelUtil.class.getName());

    public float getMaxDipOffset() {
        return this.maxDipOffset;
    }

    public void setMaxDipOffset(float maxDipOffset) {
        this.maxDipOffset = maxDipOffset;
    }

    public String[] getOrientationCodeHeuristic() {
        return this.orientationCodeHeuristic;
    }

    public void setOrientationCodeHeuristic(String[] orientationCodes) {
        this.orientationCodeHeuristic = orientationCodes;
    }

    public void setSiteCodeHeuristic(String[] siteCodeHeuristic) {
        this.siteCodeHeuristic = siteCodeHeuristic;
    }

    public void setGainCodeHeuristic(String[] gainCodeHeuristic) {
        this.gainCodeHeuristic = gainCodeHeuristic;
    }

    public void setBandCodeHeuristic(String[] bandCodeHeuristic) {
        this.bandCodeHeuristic = bandCodeHeuristic;
    }

    public String[] getSiteCodeHeuristic() {
        return this.siteCodeHeuristic;
    }

    public String[] getGainCodeHeuristic() {
        return this.gainCodeHeuristic;
    }

    public String[] getBandCodeHeuristic() {
        return this.bandCodeHeuristic;
    }

    public Channel getBestVerticalChannel(List<ChannelImpl> inChanList) {
        return this.getBestChannel(this.getAllVertical(inChanList));
    }

    public ChannelImpl getBestChannel(List<ChannelImpl> inChanList) {
        for (int i = 0; i < this.siteCodeHeuristic.length; ++i) {
            ArrayList<ChannelImpl> siteChans = new ArrayList<ChannelImpl>();
            for (ChannelImpl c : inChanList) {
                if (!c.getSite().get_code().equals(this.siteCodeHeuristic[i])) continue;
                siteChans.add(c);
            }
            if (siteChans.size() == 0) continue;
            for (int j = 0; j < this.bandCodeHeuristic.length; ++j) {
                ArrayList<ChannelImpl> bandChans = new ArrayList<ChannelImpl>();
                for (ChannelImpl c : siteChans) {
                    if (!ChannelIdUtil.getBandCode((ChannelId)c.getId()).equals(this.bandCodeHeuristic[j])) continue;
                    bandChans.add(c);
                }
                if (bandChans.size() == 0) continue;
                for (int k = 0; k < this.gainCodeHeuristic.length; ++k) {
                    ArrayList<ChannelImpl> gainChans = new ArrayList<ChannelImpl>();
                    for (ChannelImpl c : bandChans) {
                        if (!ChannelIdUtil.getGainCode((ChannelId)c.getId()).equals(this.gainCodeHeuristic[k])) continue;
                        gainChans.add(c);
                    }
                    if (gainChans.size() == 0) continue;
                    for (int m = 0; m < this.orientationCodeHeuristic.length; ++m) {
                        for (ChannelImpl vChan : gainChans) {
                            if (!ChannelIdUtil.getOrientationCode((ChannelId)vChan.getId()).equals(this.orientationCodeHeuristic[m])) continue;
                            return vChan;
                        }
                    }
                }
            }
        }
        if (inChanList.size() != 0) {
            return inChanList.get(0);
        }
        return null;
    }

    public ChannelImpl[] getBestMotionVector(List<ChannelImpl> inChanList) {
        for (int i = 0; i < this.siteCodeHeuristic.length; ++i) {
            ArrayList<ChannelImpl> siteChans = new ArrayList<ChannelImpl>();
            for (ChannelImpl siteChan : inChanList) {
                if (!siteChan.getSite().get_code().equals(this.siteCodeHeuristic[i])) continue;
                siteChans.add(siteChan);
            }
            if (siteChans.size() == 0) continue;
            for (int j = 0; j < this.bandCodeHeuristic.length; ++j) {
                ArrayList<ChannelImpl> bandChans = new ArrayList<ChannelImpl>();
                for (ChannelImpl c : siteChans) {
                    if (!ChannelIdUtil.getBandCode((ChannelId)c.getId()).equals(this.bandCodeHeuristic[j])) continue;
                    bandChans.add(c);
                }
                if (bandChans.size() == 0) continue;
                for (int k = 0; k < this.gainCodeHeuristic.length; ++k) {
                    ArrayList<ChannelImpl> gainChans = new ArrayList<ChannelImpl>();
                    for (ChannelImpl c : bandChans) {
                        if (!ChannelIdUtil.getGainCode((ChannelId)c.getId()).equals(this.gainCodeHeuristic[k])) continue;
                        gainChans.add(c);
                    }
                    if (gainChans.size() == 0) continue;
                    List<ChannelImpl> vList = this.getAllVertical(gainChans);
                    List<ChannelImpl> hList = this.getAllHorizontal(gainChans);
                    for (int m = 0; m < this.orientationCodeHeuristic.length; ++m) {
                        for (ChannelImpl vChan : vList) {
                            if (!ChannelIdUtil.getOrientationCode((ChannelId)vChan.getId()).equals(this.orientationCodeHeuristic[m])) continue;
                            ChannelImpl[] out = new ChannelImpl[3];
                            out[0] = vChan;
                            int found = 1;
                            for (int n = 0; n < this.orientationCodeHeuristic.length; ++n) {
                                for (ChannelImpl hChan : hList) {
                                    if (!ChannelIdUtil.getOrientationCode((ChannelId)hChan.getId()).equals(this.orientationCodeHeuristic[n])) continue;
                                    if (found == 2) {
                                        if (!this.arePerpendicular((Channel)out[1], (Channel)hChan)) continue;
                                        out[found] = hChan;
                                        return out;
                                    }
                                    out[found] = hChan;
                                    ++found;
                                }
                            }
                        }
                    }
                }
            }
        }
        return null;
    }

    private boolean arePerpendicular(Channel channel, Channel hChan) {
        return Math.abs(SphericalCoords.distance((double)channel.getOrientation().dip, (double)channel.getOrientation().azimuth, (double)hChan.getOrientation().dip, (double)hChan.getOrientation().azimuth) - 90.0) < (double)this.maxDipOffset;
    }

    public static List<ChannelImpl> pruneChannels(List<ChannelImpl> inChan, MicroSecondDate when) {
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        for (ChannelImpl c : inChan) {
            if (!when.before((Date)new MicroSecondDate(c.getEndTime())) || !when.after((Date)new MicroSecondDate(c.getBeginTime()))) continue;
            out.add(c);
        }
        return out;
    }

    public List<ChannelImpl> getAllHorizontal(List<ChannelImpl> inChan) {
        ArrayList<ChannelImpl> onlyHorizontal = new ArrayList<ChannelImpl>();
        for (ChannelImpl channel : inChan) {
            if (!(Math.abs(channel.getOrientation().dip) < this.maxDipOffset)) continue;
            onlyHorizontal.add(channel);
        }
        return onlyHorizontal;
    }

    public List<ChannelImpl> getAllVertical(List<ChannelImpl> inChan) {
        ArrayList<ChannelImpl> onlyVertical = new ArrayList<ChannelImpl>();
        for (ChannelImpl c : inChan) {
            if (!(Math.abs(c.getOrientation().dip) > 90.0f - this.maxDipOffset)) continue;
            onlyVertical.add(c);
        }
        return onlyVertical;
    }

    public static List<ChannelImpl> getAllBand(List<ChannelImpl> inChan, String bandCode) {
        ArrayList<ChannelImpl> out = new ArrayList<ChannelImpl>();
        for (ChannelImpl channel : inChan) {
            if (!ChannelIdUtil.getBandCode((ChannelId)channel.getId()).equals(bandCode)) continue;
            out.add(channel);
        }
        return out;
    }

    private static Channel getChannelForOrientation(Channel[] group, String orientation, Channel matchThis) {
        return BestChannelUtil.getChannel(group, BestChannelUtil.getBand(matchThis), orientation, matchThis.getSite().get_code(), BestChannelUtil.getGain(matchThis));
    }

    public static String getBand(Channel chan) {
        return BestChannelUtil.getBand(chan.get_code());
    }

    public static String getBand(String channelCode) {
        return channelCode.substring(0, 1);
    }

    public static String getGain(Channel chan) {
        return BestChannelUtil.getGain(chan.get_code());
    }

    public static String getGain(String channelCode) {
        return channelCode.substring(1, 2);
    }

    public static String getOrientation(Channel chan) {
        return BestChannelUtil.getOrientation(chan.get_code());
    }

    public static String getOrientation(String channelCode) {
        return channelCode.substring(2, 3);
    }

    public Channel[] getChannels(Channel[] staChans, String bc) {
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (int i = 0; i < this.orientationCodeHeuristic.length; ++i) {
            String orientation = this.orientationCodeHeuristic[i];
            Channel chan = this.getChannel(staChans, bc, orientation);
            if (chan == null) continue;
            results.add(chan);
            for (int j = 0; j < this.orientationCodeHeuristic.length; ++j) {
                Channel additional;
                String subOrient = this.orientationCodeHeuristic[j];
                if (subOrient.equals(orientation) || (additional = BestChannelUtil.getChannelForOrientation(staChans, subOrient, chan)) == null) continue;
                results.add(additional);
            }
            break;
        }
        return results.toArray(new Channel[0]);
    }

    public Channel getChannel(Channel[] inChan, String bandCode, String orientationCode) {
        for (int h = 0; h < this.siteCodeHeuristic.length; ++h) {
            Channel tmpChannel = this.getChannel(inChan, bandCode, orientationCode, this.siteCodeHeuristic[h]);
            if (tmpChannel == null) continue;
            return tmpChannel;
        }
        return null;
    }

    public Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode) {
        for (int i = 0; i < this.gainCodeHeuristic.length; ++i) {
            Channel tmp = BestChannelUtil.getChannel(inChan, bandCode, orientationCode, siteCode, this.gainCodeHeuristic[i]);
            if (tmp == null) continue;
            return tmp;
        }
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].get_id().site_code.equals(siteCode) || !inChan[chanNum].get_code().endsWith(orientationCode) || !inChan[chanNum].get_code().startsWith(bandCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }

    public static Channel getChannel(Channel[] inChan, String bandCode, String orientationCode, String siteCode, String gainCode) {
        String desiredChannelCode = bandCode + gainCode + orientationCode;
        for (int chanNum = 0; chanNum < inChan.length; ++chanNum) {
            if (!inChan[chanNum].getSite().get_code().equals(siteCode) || !inChan[chanNum].get_code().equals(desiredChannelCode)) continue;
            return inChan[chanNum];
        }
        return null;
    }

    public static <T> List<T> asList(T ... elems) {
        return Arrays.asList(elems);
    }
}

