/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.StatusListener;
import edu.sc.seis.fissuresUtil.cache.TrackerListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JobTracker
implements StatusListener {
    private List finished = Collections.synchronizedList(new ArrayList());
    private List active = Collections.synchronizedList(new ArrayList());
    private static JobTracker tracker = new JobTracker();
    private List listeners = Collections.synchronizedList(new ArrayList());

    private JobTracker() {
    }

    public void add(Job addend) {
        addend.add(this);
        this.statusUpdated(addend);
    }

    @Override
    public void statusUpdated(Job updated) {
        if (updated.isFinished()) {
            this.active.remove(updated);
            if (!this.finished.contains(updated)) {
                this.finished.add(updated);
            }
        } else {
            this.finished.remove(updated);
            if (!this.active.contains(updated)) {
                this.active.add(updated);
            }
        }
        this.fireTrackerUpdated();
    }

    public List getActiveJobs() {
        return this.active;
    }

    public List getFinishedJobs() {
        return this.finished;
    }

    public void clearFinished() {
        this.finished.clear();
        this.fireTrackerUpdated();
    }

    public void add(TrackerListener listener) {
        this.listeners.add(listener);
    }

    public void remove(TrackerListener listener) {
        this.listeners.remove(listener);
    }

    private void fireTrackerUpdated() {
        TrackerListener[] tempListeners = this.listeners.toArray(new TrackerListener[0]);
        for (int i = 0; i < tempListeners.length; ++i) {
            tempListeners[i].trackerUpdated(this);
        }
    }

    public static JobTracker getTracker() {
        return tracker;
    }
}

