/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.cache;

import edu.iris.Fissures.IfNetwork.NetworkAccess;
import edu.iris.Fissures.IfNetwork.NetworkFinder;
import edu.iris.Fissures.IfNetwork.NetworkId;
import edu.iris.Fissures.IfNetwork.NetworkNotFound;
import edu.iris.Fissures.network.NetworkIdUtil;
import edu.sc.seis.fissuresUtil.cache.ProxyNetworkFinder;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheByIdNetworkFinder
extends ProxyNetworkFinder {
    private HashMap<String, NetworkAccess> netIdToAccessMap = new HashMap();
    private static final Logger logger = LoggerFactory.getLogger(CacheByIdNetworkFinder.class);

    public CacheByIdNetworkFinder(NetworkFinder nf) {
        super(nf);
    }

    @Override
    public NetworkAccess retrieve_by_id(NetworkId id) throws NetworkNotFound {
        String key = NetworkIdUtil.toString((NetworkId)id);
        if (!this.netIdToAccessMap.containsKey(key)) {
            logger.debug("Not in cache, go and get it over the net: " + key);
            this.netIdToAccessMap.put(key, super.retrieve_by_id(id));
        } else {
            logger.debug("Is in cache: " + key);
        }
        return this.netIdToAccessMap.get(key);
    }

    @Override
    public void reset() {
        super.reset();
        this.netIdToAccessMap.clear();
    }
}

