/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.fissuresUtil.bag;

import edu.iris.Fissures.IfNetwork.SamplingRange;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Sampling;
import edu.iris.Fissures.model.TimeInterval;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import java.util.ArrayList;
import java.util.List;

public class SamplingUtil {
    public static List<ChannelImpl> inSampling(SamplingRange sampling, List<ChannelImpl> chans) {
        double minSPS = SamplingUtil.getSamplesPerSecond(sampling.min);
        double maxSPS = SamplingUtil.getSamplesPerSecond(sampling.max);
        ArrayList<ChannelImpl> results = new ArrayList<ChannelImpl>();
        for (ChannelImpl chan : chans) {
            double chanSPS = SamplingUtil.getSamplesPerSecond(chan.getSamplingInfo());
            if (!(minSPS <= chanSPS) || !(chanSPS <= maxSPS)) continue;
            results.add(chan);
        }
        return results;
    }

    private static double getSamplesPerSecond(Sampling sampling) {
        double numSeconds = new TimeInterval((Quantity)sampling.interval).convertTo((UnitImpl)UnitImpl.SECOND).value;
        return (double)sampling.numPoints / numSeconds;
    }
}

