/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.util;

import com.bbn.openmap.MoreMath;

public abstract class FanCompress {
    public abstract boolean next_point(FanPoint var1);

    public abstract void save_point(double var1, double var3);

    public abstract void set_coalesce_points(double var1);

    public static final void fan_compress(FanCompress fan, double epsilon) {
        FanPoint p = new FanPoint();
        double epsilon_squared = epsilon * epsilon;
        if (!fan.next_point(p)) {
            return;
        }
        fan.save_point(p.x, p.y);
        double p0x = p.x;
        double p0y = p.y;
        block0: while (true) {
            double dy;
            double dx;
            double distance;
            if (!((distance = (dx = p.x - p0x) * dx + (dy = p.y - p0y) * dy) > epsilon_squared)) {
                if (fan.next_point(p)) continue;
                fan.save_point(p.x, p.y);
                return;
            }
            double pu = distance = Math.sqrt(distance);
            double ux = (p.x - p0x) / pu;
            double uy = (p.y - p0y) / pu;
            double vx = -uy;
            double vy = ux;
            double f1 = pu;
            double f2 = epsilon / pu;
            double f3 = -f2;
            double xok = p.x;
            double yok = p.y;
            while (true) {
                double slope;
                if (!fan.next_point(p)) {
                    fan.save_point(p.x, p.y);
                    return;
                }
                boolean keep = true;
                dx = p.x - p0x;
                dy = p.y - p0y;
                pu = ux * dx + uy * dy;
                double pv = vx * dx + vy * dy;
                if (pu >= f1 && (slope = pv / pu) <= f2 && slope >= f3) {
                    double dslope = epsilon / pu;
                    keep = false;
                    f1 = pu;
                    double temp = slope + dslope;
                    if (temp < f2) {
                        f2 = temp;
                    }
                    if ((temp = slope - dslope) > f3) {
                        f3 = temp;
                    }
                }
                if (keep) {
                    fan.save_point(xok, yok);
                    p0x = xok;
                    p0y = yok;
                    continue block0;
                }
                xok = p.x;
                yok = p.y;
            }
            break;
        }
    }

    public static class FloatCompress
    extends FanCompress {
        private int read = 0;
        private int write = 0;
        protected float[] array;
        protected float zero_eps = 1.0E-4f;

        public FloatCompress(float[] array) {
            this.array = array;
        }

        public boolean next_point(FanPoint p) {
            if (this.read + 1 < this.array.length) {
                p.x = this.array[this.read++];
                p.y = this.array[this.read++];
                return true;
            }
            return false;
        }

        public void save_point(double x, double y) {
            if (this.write + 1 < this.read) {
                if (this.write > 1 && MoreMath.approximately_equal((float)x, this.array[this.write - 2], this.zero_eps) && MoreMath.approximately_equal((float)y, this.array[this.write - 1], this.zero_eps)) {
                    return;
                }
                this.array[this.write++] = (float)x;
                this.array[this.write++] = (float)y;
            } else {
                System.err.println("FanCompress.FloatCompress.save_point(): ignoring extra...");
            }
        }

        public void set_coalesce_points(double epsilon) {
            this.zero_eps = (float)epsilon;
        }

        public float[] getArray() {
            float[] ret_val = new float[this.write];
            System.arraycopy(this.array, 0, ret_val, 0, this.write);
            return ret_val;
        }
    }

    public static class FanPoint {
        public double x;
        public double y;
    }
}

