/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.tools.symbology.milStd2525;

import com.bbn.openmap.tools.symbology.milStd2525.SymbolChooser;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.UIManager;

class SymbolChooserDialog
extends JDialog {
    private String initialCode;
    private SymbolChooser chooserPane;

    public SymbolChooserDialog(Component c, String title, boolean modal, SymbolChooser chooserPane, ActionListener okListener, ActionListener cancelListener) throws HeadlessException {
        super(JOptionPane.getFrameForComponent(c), title, modal);
        this.chooserPane = chooserPane;
        String okString = UIManager.getString("ColorChooser.okText");
        String cancelString = UIManager.getString("ColorChooser.cancelText");
        String resetString = UIManager.getString("ColorChooser.resetText");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)chooserPane, "Center");
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new FlowLayout(1));
        JButton okButton = new JButton(okString);
        this.getRootPane().setDefaultButton(okButton);
        okButton.setActionCommand("OK");
        if (okListener != null) {
            okButton.addActionListener(okListener);
        }
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SymbolChooserDialog.this.hide();
            }
        });
        buttonPane.add(okButton);
        JButton cancelButton = new JButton(cancelString);
        cancelButton.setActionCommand("cancel");
        if (cancelListener != null) {
            cancelButton.addActionListener(cancelListener);
        }
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SymbolChooserDialog.this.hide();
            }
        });
        buttonPane.add(cancelButton);
        JButton resetButton = new JButton(resetString);
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SymbolChooserDialog.this.reset();
            }
        });
        buttonPane.add(resetButton);
        contentPane.add((Component)buttonPane, "South");
        this.applyComponentOrientation((c == null ? this.getRootPane() : c).getComponentOrientation());
        this.pack();
        this.setLocationRelativeTo(c);
    }

    public void show() {
        this.initialCode = this.chooserPane.getCode();
        super.show();
    }

    public void reset() {
        this.chooserPane.setCode(this.initialCode);
        this.chooserPane.handleManualNameFieldUpdate(this.initialCode);
    }

    static class DisposeOnClose
    extends ComponentAdapter
    implements Serializable {
        DisposeOnClose() {
        }

        public void componentHidden(ComponentEvent e) {
            Window w = (Window)e.getComponent();
            w.dispose();
        }
    }

    static class Closer
    extends WindowAdapter
    implements Serializable {
        Closer() {
        }

        public void windowClosing(WindowEvent e) {
            Window w = e.getWindow();
            w.hide();
        }
    }
}

