/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.util;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMLine;
import com.bbn.openmap.omGraphics.OMRect;
import com.bbn.openmap.util.Debug;
import java.awt.Point;

public class ArcCalc {
    protected OMGraphicList arcGraphics = null;
    protected boolean generated = false;
    public double distance;
    public double straightLineSlope;
    public double inverseSlope;
    public Point midPoint = new Point();
    public Point arcCenter = new Point();
    public Point peakPoint = new Point();
    public double startSlope;
    public double endSlope;
    public double arcRadius;
    protected int[] xpoints;
    protected int[] ypoints;
    protected double arcAngle = 0.0;
    protected boolean arcUp = true;
    protected boolean reversed = false;

    public ArcCalc(double aa, boolean putArcUp) {
        this.arcAngle = aa;
        this.arcUp = putArcUp;
        if (aa < 0.0) {
            this.arcAngle *= -1.0;
            boolean bl = this.arcUp = !this.arcUp;
        }
        if (this.arcAngle > Math.PI) {
            this.arcAngle = Math.PI;
        }
        this.generated = false;
    }

    public double getArcAngle() {
        return this.arcAngle;
    }

    public boolean isArcUp() {
        return this.arcUp;
    }

    public void generate(int x1, int y1, int x2, int y2) {
        double arccos;
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generateArc: creating supplimental graphics list");
            this.arcGraphics = new OMGraphicList();
        }
        this.distance = Math.sqrt(Math.pow(Math.abs(y2 - y1), 2.0) + Math.pow(Math.abs(x2 - x1), 2.0));
        this.straightLineSlope = Math.atan((double)(y2 - y1) / (double)(x2 - x1));
        this.inverseSlope = this.straightLineSlope - 1.5707963267948966;
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: Slope is " + this.straightLineSlope * 180.0 / Math.PI + " degrees, distance = " + this.distance + " pixels.");
        }
        this.midPoint.x = x1 + (x2 - x1) / 2;
        this.midPoint.y = y1 + (y2 - y1) / 2;
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: Center point for (" + x1 + ", " + y1 + ") to (" + x2 + ", " + y2 + ") is (" + this.midPoint.x + ", " + this.midPoint.y + ")");
        }
        this.arcRadius = (arccos = Math.cos(this.arcAngle)) != 1.0 ? this.distance / Math.sqrt(2.0 * (1.0 - Math.cos(this.arcAngle))) : this.distance / Math.sqrt(2.0);
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: radius of arc = " + this.arcRadius);
        }
        double x = this.arcRadius - this.arcRadius * Math.cos(this.arcAngle);
        double rPrime = this.distance / 2.0 * Math.sqrt(1.0 - Math.pow(x / this.distance, 2.0)) / Math.sin(this.arcAngle / 2.0);
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: rPrime = " + rPrime);
        }
        int direction = 1;
        if (this.arcUp) {
            direction = -1;
        }
        this.arcCenter.x = this.midPoint.x + direction * (int)(rPrime * Math.cos(this.inverseSlope));
        this.arcCenter.y = this.midPoint.y + direction * (int)(rPrime * Math.sin(this.inverseSlope));
        if (Debug.debugging("arc")) {
            double dist1 = Math.sqrt(Math.pow(this.arcCenter.x - x1, 2.0) + Math.pow(this.arcCenter.y - y1, 2.0));
            double dist2 = Math.sqrt(Math.pow(this.arcCenter.x - x2, 2.0) + Math.pow(this.arcCenter.y - y2, 2.0));
            Debug.output("ArcCalc.generate: Center focus for arc is (" + this.arcCenter.x + ", " + this.arcCenter.y + ") along slope line of " + this.inverseSlope * 180.0 / Math.PI + " degrees).");
            Debug.output("ArcCalc.generate: Distance to point 1 from arc focus = " + dist1 + "\n                    Distance to point 2 from arc focus = " + dist2);
            OMRect point1 = new OMRect(x1 - 1, y1 - 1, x1 + 1, y1 + 1);
            OMRect point2 = new OMRect(x2 - 1, y2 - 1, x2 + 1, y2 + 1);
            OMRect arcPoint = new OMRect(this.arcCenter.x - 1, this.arcCenter.y - 1, this.arcCenter.x + 1, this.arcCenter.y + 1);
            point1.setLinePaint(OMColor.red);
            point2.setLinePaint(OMColor.red);
            arcPoint.setLinePaint(OMColor.blue);
            this.arcGraphics.add(point1);
            this.arcGraphics.add(point2);
            this.arcGraphics.add(arcPoint);
            OMLine line1 = new OMLine(x1, y1, x2, y2);
            OMLine line2 = new OMLine(this.midPoint.x, this.midPoint.y, this.arcCenter.x, this.arcCenter.y);
            this.arcGraphics.add(line1);
            this.arcGraphics.add(line2);
        }
        int realCount = 0;
        this.startSlope = this.getRealAngle(this.arcCenter.x, this.arcCenter.y, x1, y1);
        this.endSlope = this.getRealAngle(this.arcCenter.x, this.arcCenter.y, x2, y2);
        double smallSlope = this.startSlope > this.endSlope ? this.endSlope : this.startSlope;
        double largeSlope = smallSlope == this.startSlope ? this.endSlope : this.startSlope;
        while (Math.abs(smallSlope - largeSlope) > Math.PI) {
            if (Math.abs(largeSlope - smallSlope - Math.PI) < 0.001) break;
            Debug.message("arc", "ArcCalc.generate: Modifying the starting slope.");
            double tmpSlope = smallSlope + 6.2831854820251465;
            smallSlope = largeSlope;
            largeSlope = tmpSlope;
        }
        if (this.arcAngle == Math.PI && this.arcUp) {
            Debug.message("arc", "ArcCalc.generate: Modifying 180 angle points.");
            double tmpSlope = smallSlope + 6.2831854820251465;
            smallSlope = largeSlope;
            largeSlope = tmpSlope;
        }
        double angleIncrement = Math.abs(y2 - y1) < Math.abs(x2 - x1) ? Math.PI / (double)Math.abs(x2 - x1) : Math.PI / (double)Math.abs(y2 - y1);
        int numPoints = (int)(Math.abs(smallSlope - largeSlope) / angleIncrement + 2.0);
        int[] xPoints = new int[numPoints];
        int[] yPoints = new int[numPoints];
        if (Debug.debugging("arc")) {
            Debug.output("ArcCalc.generate: angle to x1, y1 is " + this.startSlope + " (" + this.startSlope * 180.0 / Math.PI + " degrees), angle to x2, y2 is " + this.endSlope + " (" + this.endSlope * 180.0 / Math.PI + " degrees)");
            Debug.output("ArcCalc.generate: Starting angle is " + smallSlope + "(" + smallSlope * 180.0 / Math.PI + " degrees), end angle is " + largeSlope + " (" + largeSlope * 180.0 / Math.PI + " degrees), incrementing by " + angleIncrement + " (" + angleIncrement * 180.0 / Math.PI + " degrees)");
        }
        this.reversed = false;
        while (smallSlope < largeSlope && realCount < numPoints) {
            xPoints[realCount] = this.arcCenter.x + (int)(this.arcRadius * Math.cos(smallSlope));
            yPoints[realCount] = this.arcCenter.y + (int)(this.arcRadius * Math.sin(smallSlope));
            if (realCount == 0 && xPoints[realCount] == x2) {
                Debug.message("arc", "ArcCalc: line reversed");
                this.reversed = true;
            }
            if (Debug.debugging("arc") && realCount == 0) {
                OMLine startLine = new OMLine(this.arcCenter.x, this.arcCenter.y, xPoints[0], yPoints[0]);
                startLine.setLinePaint(OMColor.white);
                this.arcGraphics.add(startLine);
            } else if (Debug.debugging("arcdetail")) {
                Debug.output("  angle " + smallSlope + " (" + smallSlope * 180.0 / Math.PI + " degrees)  = " + xPoints[realCount] + ", " + yPoints[realCount]);
            }
            if (Math.abs(largeSlope - smallSlope - this.arcAngle / 2.0) < angleIncrement) {
                this.peakPoint.x = xPoints[realCount];
                this.peakPoint.y = yPoints[realCount];
                Debug.message("arc", "ArcCalc: Found a midpoint.");
            }
            smallSlope += angleIncrement;
            ++realCount;
        }
        this.xpoints = new int[realCount];
        this.ypoints = new int[realCount];
        System.arraycopy(xPoints, 0, this.xpoints, 0, realCount);
        System.arraycopy(yPoints, 0, this.ypoints, 0, realCount);
    }

    protected double getRealAngle(int x1, int y1, int x2, int y2) {
        double angle = 0.0;
        double horDiff = x2 - x1;
        double vertDiff = y2 - y1;
        if (horDiff == 0.0) {
            if (vertDiff > 0.0) {
                angle = 1.5707963705062866;
            } else if (vertDiff < 0.0) {
                angle = -1.5707963705062866;
            }
        } else {
            angle = Math.atan(vertDiff / horDiff);
            if (horDiff < 0.0) {
                angle += Math.PI;
            }
        }
        while (angle < 0.0) {
            angle += 6.2831854820251465;
        }
        return angle;
    }

    public int[] getXPoints() {
        return this.xpoints;
    }

    public int[] getYPoints() {
        return this.ypoints;
    }

    public OMGraphicList getArcGraphics() {
        if (this.arcGraphics == null) {
            return new OMGraphicList();
        }
        return this.arcGraphics;
    }

    public boolean getReversed() {
        return this.reversed;
    }
}

