/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics.grid;

import com.bbn.openmap.omGraphics.OMColor;
import com.bbn.openmap.omGraphics.grid.ElevationColors;
import com.bbn.openmap.proj.Length;
import java.awt.Color;

public class GreyscaleSlopeColors
implements ElevationColors {
    public static final int NUM_COLORS = 256;
    public static final int NUM_ELEVATION_COLORS = 25;
    public static final int DEFAULT_OPAQUENESS = 255;
    public Color waterColor = new OMColor(0xBFEFFF);
    public int[] colors;
    public int adjustment = 3;

    public GreyscaleSlopeColors() {
        this.getColors();
    }

    public int[] getColors() {
        if (this.colors == null) {
            this.colors = this.createGreyscaleColors(25, 255);
        }
        return this.colors;
    }

    public void setColors(int[] clrs) {
        this.colors = clrs;
    }

    public void setWaterColor(Color water) {
        this.waterColor = water;
    }

    public Color getWaterColor() {
        return this.waterColor;
    }

    public Color getColor(int elevation, Length units, double slope) {
        return new Color(this.getARGB(elevation, units, slope));
    }

    public int getARGB(int elevation, Length units, double slope) {
        float value = (float)((double)((this.colors.length - 1) / 2) + slope);
        if (slope != 0.0 && value < 1.0f) {
            value = 1.0f;
        }
        if (elevation == 0) {
            value = 0.0f;
        }
        if (value > (float)(this.colors.length - 1)) {
            value = this.colors.length - 1;
        }
        return this.colors[(int)value];
    }

    public int numColors() {
        return this.colors.length;
    }

    public int[] createGreyscaleColors(int num_colors, int opaqueness) {
        int[] tempColors = new int[num_colors];
        if (num_colors == 0) {
            num_colors = 25;
        }
        int grey_interval = 256 / num_colors;
        int i = 0;
        while (i < num_colors) {
            if (i == 0) {
                tempColors[i] = this.waterColor.getRGB();
            } else {
                int color = i * grey_interval + grey_interval / 2;
                tempColors[i] = new Color(color, color, color, opaqueness).getRGB();
            }
            ++i;
        }
        return tempColors;
    }
}

