/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.omGraphics;

import com.bbn.openmap.gui.GridBagToolBar;
import com.bbn.openmap.omGraphics.EditableOMCircle;
import com.bbn.openmap.omGraphics.GraphicAttributes;
import com.bbn.openmap.omGraphics.OMRangeRings;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.ParseException;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;

public class EditableOMRangeRings
extends EditableOMCircle {
    protected JTextField intervalField = null;
    protected JToolBar rrToolBar = null;
    protected transient DecimalFormat df = new DecimalFormat();
    protected boolean drawLabelsHolder = true;

    public EditableOMRangeRings() {
        this.createGraphic(null);
    }

    public EditableOMRangeRings(GraphicAttributes ga) {
        this.createGraphic(ga);
    }

    public EditableOMRangeRings(OMRangeRings omc) {
        this.setGraphic(omc);
    }

    public void createGraphic(GraphicAttributes ga) {
        this.init();
        this.stateMachine.setUndefined();
        int renderType = 1;
        if (ga != null) {
            renderType = ga.getRenderType();
        }
        if (Debug.debugging("eomc")) {
            Debug.output("EditableOMRangeRings.createGraphic(): rendertype = " + renderType);
        }
        this.circle = new OMRangeRings(90.0f, -180.0f, 0.0f);
        if (ga != null) {
            ga.setTo(this.circle);
        }
    }

    public Component getGUI(GraphicAttributes graphicAttributes) {
        Debug.message("eomg", "EditableOMRangeRings.getGUI");
        if (graphicAttributes != null) {
            JPanel panel = graphicAttributes.getColorAndLineGUI();
            panel.add(this.getRangeRingGUI());
            return panel;
        }
        return this.getRangeRingGUI();
    }

    public void updateInterval(int val) {
        ((OMRangeRings)this.circle).setInterval(val);
        if (this.intervalField != null) {
            this.intervalField.setText(Integer.toString(val));
        }
        this.redraw(null, true);
    }

    public void updateInterval(String intervalStr) {
        int oldValue;
        int value = oldValue = ((OMRangeRings)this.circle).getInterval();
        try {
            if (intervalStr.toLowerCase().endsWith("m")) {
                intervalStr = intervalStr.substring(0, intervalStr.length() - 1);
                value = this.df.parse(intervalStr).intValue() * 1000000;
            } else if (intervalStr.toLowerCase().endsWith("k")) {
                intervalStr = intervalStr.substring(0, intervalStr.length() - 1);
                value = this.df.parse(intervalStr).intValue() * 1000;
            } else {
                value = intervalStr.trim().equals("") ? oldValue : this.df.parse(intervalStr).intValue();
            }
        }
        catch (ParseException e) {
            Debug.error("RangeRing interval value not valid: " + intervalStr);
        }
        catch (NumberFormatException e) {
            Debug.error("RangeRing interval value not valid: " + intervalStr);
        }
        if (value <= 0) {
            value = oldValue;
        }
        this.updateInterval(value);
    }

    protected JToolBar getRangeRingGUI() {
        if (this.rrToolBar == null) {
            this.rrToolBar = new GridBagToolBar();
            this.rrToolBar.setFloatable(false);
            this.rrToolBar.setMargin(new Insets(0, 1, 0, 1));
            this.intervalField = new JTextField(Integer.toString(((OMRangeRings)this.circle).getInterval()), 5);
            this.intervalField.setMargin(new Insets(0, 1, 0, 1));
            this.intervalField.setHorizontalAlignment(4);
            this.intervalField.setToolTipText("Value for interval between rings.");
            this.intervalField.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    EditableOMRangeRings.this.updateInterval(((JTextField)ae.getSource()).getText());
                }
            });
            this.rrToolBar.add(this.intervalField);
            Length[] available = Length.getAvailable();
            String[] unitStrings = new String[available.length + 1];
            String current = null;
            Length l = ((OMRangeRings)this.circle).getIntervalUnits();
            if (l != null) {
                current = l.toString();
            }
            int currentIndex = unitStrings.length - 1;
            int i = 0;
            while (i < available.length) {
                unitStrings[i] = available[i].toString();
                if (current != null && unitStrings[i].equals(current)) {
                    currentIndex = i;
                }
                ++i;
            }
            unitStrings[unitStrings.length - 1] = "concentric";
            JComboBox<String> unitList = new JComboBox<String>(unitStrings);
            unitList.setBorder(new EmptyBorder(0, 1, 0, 1));
            unitList.setSelectedIndex(currentIndex);
            unitList.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    JComboBox jcb = (JComboBox)e.getSource();
                    ((OMRangeRings)EditableOMRangeRings.this.circle).setIntervalUnits(Length.get((String)jcb.getSelectedItem()));
                    EditableOMRangeRings.this.updateInterval(EditableOMRangeRings.this.intervalField.getText());
                }
            });
            this.rrToolBar.add(unitList);
        }
        return this.rrToolBar;
    }

    protected void modifyOMGraphicForEditRender() {
        OMRangeRings omrr = (OMRangeRings)this.getGraphic();
        this.drawLabelsHolder = omrr.getDrawLabels();
        omrr.setDrawLabels(false);
    }

    protected void resetOMGraphicAfterEditRender() {
        ((OMRangeRings)this.getGraphic()).setDrawLabels(this.drawLabelsHolder);
    }
}

