/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.vpf;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.vpf.AreaTable;
import com.bbn.openmap.layer.vpf.CoverageTable;
import com.bbn.openmap.layer.vpf.EdgeTable;
import com.bbn.openmap.layer.vpf.FeatureClassInfo;
import com.bbn.openmap.layer.vpf.NodeTable;
import com.bbn.openmap.layer.vpf.TextTable;
import com.bbn.openmap.layer.vpf.TileDirectory;
import com.bbn.openmap.layer.vpf.VPFFeatureWarehouse;
import com.bbn.openmap.layer.vpf.VPFGraphicWarehouse;
import com.bbn.openmap.util.Debug;
import java.util.ArrayList;
import java.util.List;

class TableHolder {
    EdgeTable edg = null;
    TextTable tft = null;
    AreaTable aft = null;
    NodeTable ent = null;
    NodeTable cnt = null;
    List primitiveVector = new ArrayList();
    CoverageTable coverageTable;

    protected TableHolder(CoverageTable ct) {
        this.coverageTable = ct;
    }

    protected void setTables(char featureType, TileDirectory tile) throws FormatException {
        if (featureType == 'L') {
            this.edg = new EdgeTable(this.coverageTable, tile);
        }
        if (featureType == 'T') {
            this.tft = new TextTable(this.coverageTable, tile);
        }
        if (featureType == 'A') {
            this.aft = new AreaTable(this.coverageTable, null, tile);
            this.edg = null;
        }
        if (featureType == 'E') {
            this.ent = new NodeTable(this.coverageTable, tile, true);
        }
        if (featureType == 'N') {
            this.cnt = new NodeTable(this.coverageTable, tile, false);
        }
    }

    protected void findYourself(FeatureClassInfo fci) {
        if (this.aft != null) {
            fci.findYourself(this.aft);
        } else if (this.tft != null) {
            fci.findYourself(this.tft);
        } else if (this.edg != null) {
            fci.findYourself(this.edg);
        } else if (this.ent != null) {
            fci.findYourself(this.ent);
        }
    }

    protected boolean drawFeature(int primitiveID, VPFFeatureWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon, String currentFeature) throws FormatException {
        if (this.aft != null || this.tft != null || this.edg != null || this.ent != null || this.cnt != null) {
            if (this.aft != null && this.aft.getRow(this.primitiveVector, primitiveID)) {
                this.aft.drawFeature(warehouse, dpplat, dpplon, ll1, ll2, this.primitiveVector, currentFeature);
            }
            if (this.tft != null && this.tft.getRow(this.primitiveVector, primitiveID)) {
                this.tft.drawFeature(warehouse, dpplat, dpplon, ll1, ll2, this.primitiveVector, currentFeature);
            }
            if (this.ent != null && this.ent.getRow(this.primitiveVector, primitiveID)) {
                this.ent.drawFeature(warehouse, dpplat, dpplon, ll1, ll2, this.primitiveVector, currentFeature);
            }
            if (this.cnt != null && this.cnt.getRow(this.primitiveVector, primitiveID)) {
                this.cnt.drawFeature(warehouse, dpplat, dpplon, ll1, ll2, this.primitiveVector, currentFeature);
            }
            if (this.edg != null && this.edg.getRow(this.primitiveVector, primitiveID)) {
                this.edg.drawFeature(warehouse, dpplat, dpplon, ll1, ll2, this.primitiveVector, currentFeature);
            }
            return true;
        }
        return false;
    }

    protected void drawTile(TileDirectory tile, VPFGraphicWarehouse warehouse, LatLonPoint ll1, LatLonPoint ll2, float dpplat, float dpplon) {
        boolean drawcpoint;
        boolean drawepoint;
        boolean drawarea;
        boolean drawtext;
        boolean drawedge;
        block29: {
            block28: {
                block27: {
                    block26: {
                        block25: {
                            drawedge = warehouse.drawEdgeFeatures();
                            drawtext = warehouse.drawTextFeatures();
                            drawarea = warehouse.drawAreaFeatures();
                            drawepoint = warehouse.drawEPointFeatures();
                            drawcpoint = warehouse.drawCPointFeatures();
                            this.close();
                            try {
                                if (drawedge || drawarea) {
                                    this.edg = new EdgeTable(this.coverageTable, tile);
                                }
                            }
                            catch (FormatException f) {
                                if (!Debug.debugging("vpf.FormatException")) break block25;
                                Debug.output("EdgeTable: " + f.getClass() + " " + f.getMessage());
                            }
                        }
                        try {
                            if (drawtext) {
                                this.tft = new TextTable(this.coverageTable, tile);
                            }
                        }
                        catch (FormatException f) {
                            if (!Debug.debugging("vpf.FormatException")) break block26;
                            Debug.output("TextTable: " + f.getClass() + " " + f.getMessage());
                        }
                    }
                    try {
                        if (drawepoint) {
                            this.ent = new NodeTable(this.coverageTable, tile, true);
                        }
                    }
                    catch (FormatException f) {
                        if (!Debug.debugging("vpf.FormatException")) break block27;
                        Debug.output("NodeTable: " + f.getClass() + " " + f.getMessage());
                    }
                }
                try {
                    if (drawcpoint) {
                        this.cnt = new NodeTable(this.coverageTable, tile, false);
                    }
                }
                catch (FormatException f) {
                    if (!Debug.debugging("vpf.FormatException")) break block28;
                    Debug.output("NodeTable: " + f.getClass() + " " + f.getMessage());
                }
            }
            try {
                if (drawarea && this.edg != null) {
                    this.aft = new AreaTable(this.coverageTable, this.edg, tile);
                }
            }
            catch (FormatException f) {
                if (!Debug.debugging("vpf.FormatException")) break block29;
                Debug.output("AreaTable: " + f.getClass() + " " + f.getMessage());
            }
        }
        if (this.aft != null && drawarea) {
            int i = 0;
            while (i < this.coverageTable.areainfo.length) {
                this.coverageTable.areainfo[i].findYourself(this.aft);
                ++i;
            }
            this.aft.drawTile(warehouse, dpplat, dpplon, ll1, ll2);
        }
        if (this.tft != null && drawtext) {
            int i = 0;
            while (i < this.coverageTable.textinfo.length) {
                this.coverageTable.textinfo[i].findYourself(this.tft);
                ++i;
            }
            this.tft.drawTile(warehouse, dpplat, dpplon, ll1, ll2);
        }
        if (this.edg != null && drawedge) {
            int i = 0;
            while (i < this.coverageTable.lineinfo.length) {
                this.coverageTable.lineinfo[i].findYourself(this.edg);
                ++i;
            }
            this.edg.drawTile(warehouse, dpplat, dpplon, ll1, ll2);
        }
        if (this.ent != null && drawepoint) {
            int i = 0;
            while (i < this.coverageTable.epointinfo.length) {
                this.coverageTable.epointinfo[i].findYourself(this.ent);
                ++i;
            }
            this.ent.drawTile(warehouse, dpplat, dpplon, ll1, ll2);
        }
        if (this.cnt != null && drawcpoint) {
            int i = 0;
            while (i < this.coverageTable.cpointinfo.length) {
                this.coverageTable.cpointinfo[i].findYourself(this.cnt);
                ++i;
            }
            this.cnt.drawTile(warehouse, dpplat, dpplon, ll1, ll2);
        }
        this.close();
    }

    protected void close() {
        if (Debug.debugging("vpf.tile")) {
            Debug.output("CoverageTable closing tile tables");
        }
        if (this.edg != null) {
            this.edg.close();
        }
        if (this.tft != null) {
            this.tft.close();
        }
        if (this.aft != null) {
            this.aft.close();
        }
        this.aft = null;
        this.tft = null;
        this.edg = null;
    }
}

