/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.terrain;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.image.AcmeGifFormatter;
import com.bbn.openmap.layer.terrain.ProfileStateMachine;
import com.bbn.openmap.layer.terrain.TerrainLayer;
import com.bbn.openmap.layer.terrain.TerrainTool;
import com.bbn.openmap.layer.util.stateMachine.State;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.proj.GreatCircle;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class ProfileGenerator
implements TerrainTool {
    Color toolColor = new Color(255, 0, 0);
    protected ProfileStateMachine stateMachine;
    protected TerrainLayer layer;
    protected OMGraphicList graphics = new OMGraphicList();
    public Vector coords;
    public Vector xypoints;
    public OMPoly profileLine;
    MouseEvent lastMouse;
    Projection proj;

    public ProfileGenerator(TerrainLayer tLayer) {
        this.layer = tLayer;
        this.init();
    }

    public synchronized OMGraphicList getGraphics() {
        this.profileLine.setLocation(this.setLLPoints(), 1);
        this.profileLine.generate(this.proj);
        return this.graphics;
    }

    public void init() {
        this.lastMouse = null;
        this.coords = new Vector();
        this.xypoints = new Vector();
        this.profileLine = new OMPoly(this.setLLPoints(), 1, 3);
        this.profileLine.setLinePaint(this.toolColor);
        this.graphics.add(this.profileLine);
        this.stateMachine = new ProfileStateMachine(this);
    }

    public void reset() {
        this.coords.removeAllElements();
        this.xypoints.removeAllElements();
        this.profileLine.setLocation(this.setLLPoints(), 1);
        this.stateMachine.reset();
        this.layer.repaint();
        this.lastMouse = null;
    }

    public void setScreenParameters(Projection p) {
        this.proj = p;
        this.graphics.generate(p);
    }

    public float[] setLLPoints() {
        float[] points;
        int num_points = this.coords.size();
        if (num_points <= 1) {
            points = new float[4];
            if (num_points == 0) {
                points[0] = 0.0f;
                points[1] = -6.0f;
            } else {
                points[0] = ((LatLonPoint)this.coords.elementAt((int)0)).radlat_;
                points[1] = ((LatLonPoint)this.coords.elementAt((int)0)).radlon_;
            }
            points[2] = points[0];
            points[3] = points[1];
        } else {
            points = new float[this.coords.size() * 2];
            int i = 0;
            while (i < this.coords.size()) {
                points[i * 2] = ((LatLonPoint)this.coords.elementAt((int)i)).radlat_;
                points[i * 2 + 1] = ((LatLonPoint)this.coords.elementAt((int)i)).radlon_;
                ++i;
            }
        }
        return points;
    }

    public State getState() {
        return this.stateMachine.getState();
    }

    public void createProfileImage() {
        Debug.message("terrain", "ProfileGenerator:createProfileImage(): Creating image");
        if (this.layer == null || this.layer.frameCache == null) {
            Debug.error("ProfileGenerator:  can't access the DTED data through the terrain layer.");
            return;
        }
        this.profileLine.setLocation(this.setLLPoints(), 1);
        int total_distance = 0;
        int[] distances = new int[this.xypoints.size()];
        distances[0] = 0;
        int j = 1;
        while (j < this.xypoints.size()) {
            Point tmpPoint1 = (Point)this.xypoints.elementAt(j);
            Point tmpPoint2 = (Point)this.xypoints.elementAt(j - 1);
            distances[j] = TerrainLayer.numPixelsBetween(tmpPoint1.x, tmpPoint1.y, tmpPoint2.x, tmpPoint2.y);
            total_distance += distances[j];
            ++j;
        }
        int tmp = 0;
        int max = 0;
        int[] heights = new int[this.xypoints.size()];
        int i = 0;
        while (i < heights.length) {
            LatLonPoint llp = (LatLonPoint)this.coords.elementAt(i);
            tmp = this.layer.frameCache.getElevation(llp.getLatitude(), llp.getLongitude());
            if (tmp == -32767) {
                tmp = -1;
            }
            if (tmp > max) {
                max = tmp;
            }
            heights[i] = tmp;
            ++i;
        }
        this.createGIFFile(total_distance, max, distances, heights);
    }

    protected void createGIFFile(int distance, int max, int[] post_dist, int[] post_height) {
        int box_height_buffer = 20;
        int gif_height_buffer = 20;
        int gif_width_buffer = 20;
        int text_width = 100;
        int box_height = max + box_height_buffer * 2;
        int box_width = distance;
        int gif_height = box_height + gif_height_buffer * 2;
        int gif_width = box_width + gif_width_buffer * 2 + text_width;
        AcmeGifFormatter formatter = new AcmeGifFormatter();
        Graphics graphics = formatter.getGraphics(gif_width, gif_height);
        Color gray10 = new Color(25, 25, 25);
        Color gray50 = new Color(128, 128, 128);
        Color gray75 = new Color(191, 191, 191);
        Color gray90 = new Color(230, 230, 230);
        Debug.message("terrain", "ProfileGenerator gif creation: drawing boundaries");
        graphics.setColor(gray90);
        graphics.fillRect(0, 0, gif_width, gif_height);
        graphics.setColor(gray50);
        graphics.fillRect(gif_width_buffer, gif_height_buffer, box_width, box_height);
        Debug.message("terrain", "ProfileGenerator gif creation: drawing edges");
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, gif_width - 1, gif_height - 1);
        graphics.drawRect(gif_width_buffer, gif_height_buffer, box_width, box_height);
        graphics.setColor(Color.yellow);
        graphics.drawLine(gif_width_buffer + 1, gif_height_buffer + box_height - box_height_buffer, gif_width_buffer + box_width - 1, gif_height_buffer + box_height - box_height_buffer);
        graphics.setColor(Color.black);
        FontMetrics f = graphics.getFontMetrics();
        Debug.message("terrain", "ProfileGenerator gif creation: drawing level lines");
        int i = 1;
        while (i < 9) {
            graphics.drawLine(gif_width_buffer, gif_height_buffer + box_height - box_height_buffer - max * i / 8, gif_width_buffer + box_width + 5, gif_height_buffer + box_height - box_height_buffer - max * i / 8);
            int meters = max * i / 8;
            int feet = (int)((double)meters * 3.2);
            String lineLabel = meters + "m / " + feet + "ft";
            byte[] lineLabelBytes = lineLabel.getBytes();
            graphics.drawString(lineLabel, gif_width_buffer + box_width + 10, gif_height_buffer + box_height - box_height_buffer - max * i / 8 + f.getAscent() / 2);
            ++i;
        }
        int last_x = gif_width_buffer + 1;
        int last_height = gif_height_buffer + box_height - box_height_buffer - post_height[0];
        int total_distance = 0;
        Debug.message("terrain", "ProfileGenerator gif creation: drawing profile");
        graphics.setColor(Color.red);
        int i2 = 1;
        while (i2 < post_height.length) {
            graphics.drawLine(gif_width_buffer + total_distance, gif_height_buffer + box_height - box_height_buffer - post_height[i2 - 1], gif_width_buffer + post_dist[i2] + total_distance, gif_height_buffer + box_height - box_height_buffer - post_height[i2]);
            total_distance += post_dist[i2];
            ++i2;
        }
        ImageIcon ii = new ImageIcon(formatter.getBufferedImage());
        JFrame jf = PaletteHelper.getPaletteWindow(new JLabel(ii), "Path Profile", null);
        jf.show();
    }

    protected void addProfileEvent(MouseEvent event) {
        LatLonPoint llp = this.proj.inverse(event.getX(), event.getY());
        if (this.lastMouse != null) {
            if (Math.abs(this.lastMouse.getX() - event.getX()) > 5 || Math.abs(this.lastMouse.getY() - event.getY()) > 5) {
                this.addGreatCirclePoints(this.lastMouse, event);
                this.coords.addElement(llp);
                this.xypoints.addElement(event.getPoint());
            }
        } else {
            this.coords.addElement(llp);
            this.xypoints.addElement(event.getPoint());
        }
        this.lastMouse = event;
        this.profileLine.setLocation(this.setLLPoints(), 1);
        this.profileLine.generate(this.proj);
    }

    protected void addGreatCirclePoints(MouseEvent beginning, MouseEvent ending) {
        LatLonPoint beg = this.proj.inverse(beginning.getX(), beginning.getY());
        LatLonPoint end = this.proj.inverse(ending.getX(), ending.getY());
        int num_points = (TerrainLayer.numPixelsBetween(beginning.getX(), beginning.getY(), ending.getX(), ending.getY()) - 2) / 5;
        float[] radPoints = GreatCircle.great_circle(beg.radlat_, beg.radlon_, end.radlat_, end.radlon_, num_points, true);
        int i = 0;
        while (i < radPoints.length) {
            this.coords.addElement(new LatLonPoint(radPoints[i], radPoints[i + 1], true));
            Point pt = new Point();
            this.proj.forward(radPoints[i], radPoints[i + 1], pt, true);
            this.xypoints.addElement(pt);
            ++i;
            ++i;
        }
    }
}

