/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.shape;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.io.FormatException;
import com.bbn.openmap.layer.policy.StandardPCPolicy;
import com.bbn.openmap.layer.shape.ESRIPoint;
import com.bbn.openmap.layer.shape.ESRIRecord;
import com.bbn.openmap.layer.shape.NumAndBox;
import com.bbn.openmap.layer.shape.ShapeLayer;
import com.bbn.openmap.layer.shape.SpatialIndex;
import com.bbn.openmap.omGraphics.OMGeometry;
import com.bbn.openmap.omGraphics.OMGeometryList;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;

public class BufferedShapeLayer
extends ShapeLayer {
    public BufferedShapeLayer() {
        this.setProjectionChangePolicy(new StandardPCPolicy(this));
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        try {
            this.setList(this.getWholePlanet());
        }
        catch (FormatException fe) {
            Debug.error("BufferedShapeLayer.setProperties(): FormatException reading file.\n" + fe.getMessage());
            this.setList(null);
        }
    }

    protected OMGraphicList getWholePlanet() throws FormatException {
        OMGeometryList masterList = new OMGeometryList();
        if (Debug.debugging("shape")) {
            Debug.output(this.getName() + "|BufferedShapeLayer.getWholePlanet(): " + "fetching all graphics.");
        }
        try {
            ESRIRecord[] records = this.spatialIndex.locateRecords(-180.0, -90.0, 180.0, 90.0);
            int nRecords = records.length;
            int i = 0;
            while (i < nRecords) {
                OMGeometry geom = records[i].addOMGeometry(masterList);
                geom.setAppObject(new NumAndBox(records[i].getRecordNumber(), records[i].getBoundingBox()));
                ++i;
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException npe) {
            Debug.error(this.getName() + "|BufferedShapeLayer spatial index can't access files.");
        }
        if (Debug.debugging("shape")) {
            Debug.output(this.getName() + "|BufferedShapeLayer.getWholePlanet(): finished fetch.");
        }
        return masterList;
    }

    public synchronized OMGraphicList prepare() {
        OMGraphicList masterList = this.getList();
        if (this.spatialIndex == null) {
            return new OMGraphicList();
        }
        try {
            if (masterList == null) {
                masterList = this.getWholePlanet();
            }
        }
        catch (FormatException fe) {
            Debug.error(fe.getMessage());
            return masterList;
        }
        Projection proj = this.getProjection();
        LatLonPoint ul = proj.getUpperLeft();
        LatLonPoint lr = proj.getLowerRight();
        float ulLat = ul.getLatitude();
        float ulLon = ul.getLongitude();
        float lrLat = lr.getLatitude();
        float lrLon = lr.getLongitude();
        this.drawingAttributes.setTo(masterList);
        double xmin = Math.min(ulLon, lrLon);
        double xmax = Math.max(ulLon, lrLon);
        double ymin = Math.min(ulLat, lrLat);
        double ymax = Math.max(ulLat, lrLat);
        boolean dateLine = false;
        if (ulLon > lrLon || MoreMath.approximately_equal(ulLon, lrLon, 0.001f)) {
            if (Debug.debugging("shape")) {
                Debug.output("Dateline is on screen");
            }
            dateLine = true;
        }
        Iterator iterator = masterList.iterator();
        while (iterator.hasNext()) {
            OMGeometry geom = (OMGeometry)iterator.next();
            NumAndBox nab = (NumAndBox)geom.getAppObject();
            geom.setVisible(true);
            if (nab == null) continue;
            ESRIPoint min = nab.getBoundingBox().min;
            ESRIPoint max = nab.getBoundingBox().max;
            if (dateLine) {
                if (SpatialIndex.intersects(ulLon, ymin, 180.0, ymax, min.x, min.y, max.x, max.y) || SpatialIndex.intersects(-180.0, ymin, lrLon, ymax, min.x, min.y, max.x, max.y)) continue;
                geom.setVisible(false);
                continue;
            }
            if (SpatialIndex.intersects(xmin, ymin, xmax, ymax, min.x, min.y, max.x, max.y)) continue;
            geom.setVisible(false);
        }
        masterList.generate(proj, true);
        return masterList;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "redrawCmd") {
            this.setList(null);
        }
        super.actionPerformed(e);
    }
}

