/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;

public class StandardRenderPolicy
extends OMComponent
implements RenderPolicy {
    protected OMGraphicHandlerLayer layer;
    protected boolean DEBUG = Debug.debugging("layer") || Debug.debugging("policy");

    public StandardRenderPolicy() {
    }

    public StandardRenderPolicy(OMGraphicHandlerLayer layer) {
        this();
        this.setLayer(layer);
    }

    public void setLayer(OMGraphicHandlerLayer l) {
        this.layer = l;
    }

    public OMGraphicHandlerLayer getLayer() {
        return this.layer;
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            return this.layer.prepare();
        }
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer != null) {
            OMGraphicList list = this.layer.getList();
            if (list != null) {
                Projection proj = this.layer.getProjection();
                if (proj != null) {
                    g.setClip(0, 0, proj.getWidth(), proj.getHeight());
                }
                list.render(g);
            } else if (this.DEBUG) {
                Debug.output(this.layer.getName() + ".paint(): NULL list, skipping...");
            }
        } else {
            Debug.error("RenderPolicy.paint():  NULL layer, skipping...");
        }
    }
}

