/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.policy;

import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.layer.policy.RenderingHintsRenderPolicy;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class BufferedImageRenderPolicy
extends RenderingHintsRenderPolicy {
    public static final long bufferTriggerDelay = 150L;
    protected BufferedImage buffer = null;
    protected boolean useImageBuffer = false;

    public BufferedImageRenderPolicy() {
    }

    public BufferedImageRenderPolicy(OMGraphicHandlerLayer layer) {
        super(layer);
    }

    public OMGraphicList prepare() {
        if (this.layer != null) {
            this.setBuffer(null);
            OMGraphicList list = this.layer.prepare();
            if (this.isUseImageBuffer()) {
                this.setBuffer(this.createAndPaintImageBuffer(list));
            }
            return list;
        }
        Debug.error("BufferedImageRenderPolicy.prepare():  NULL layer, can't do anything.");
        return null;
    }

    public void paint(Graphics g) {
        if (this.layer == null) {
            Debug.error("BufferedImageRenderPolicy.paint():  NULL layer, skipping...");
            return;
        }
        OMGraphicList list = this.layer.getList();
        if (list != null) {
            BufferedImage bufferedImage;
            if (this.isUseImageBuffer() && this.getBuffer() == null) {
                this.setBuffer(this.createAndPaintImageBuffer(list));
            }
            if ((bufferedImage = this.getBuffer()) != null) {
                Projection proj = this.layer.getProjection();
                if (proj != null) {
                    g.setClip(0, 0, proj.getWidth(), proj.getHeight());
                }
                ((Graphics2D)g).drawRenderedImage(bufferedImage, new AffineTransform());
                if (Debug.debugging("policy")) {
                    Debug.output("RenderingPolicy:" + this.layer.getName() + ": rendering buffer");
                }
                if (!this.isUseImageBuffer()) {
                    this.setBuffer(null);
                }
            } else {
                super.setRenderingHints(g);
                long startPaint = System.currentTimeMillis();
                list.render(g);
                long endPaint = System.currentTimeMillis();
                if (endPaint - startPaint > 150L) {
                    this.setUseImageBuffer(true);
                }
                if (Debug.debugging("policy")) {
                    Debug.output("RenderingPolicy:" + this.layer.getName() + ": rendering list, buffer(" + this.isUseImageBuffer() + ")");
                }
            }
        }
    }

    protected BufferedImage getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(BufferedImage bi) {
        this.buffer = bi;
    }

    protected BufferedImage createAndPaintImageBuffer(OMGraphicList list) {
        BufferedImage bufferedImage = null;
        if (list != null && this.layer != null) {
            int w = this.layer.getProjection().getWidth();
            int h = this.layer.getProjection().getHeight();
            bufferedImage = new BufferedImage(w, h, 2);
            Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics();
            super.setRenderingHints(g2d);
            long startPaint = System.currentTimeMillis();
            list.render(g2d);
            long endPaint = System.currentTimeMillis();
            if (Debug.debugging("policy")) {
                Debug.output("RenderingPolicy:" + this.layer.getName() + ": rendering list into buffer");
            }
            if (endPaint - startPaint < 150L) {
                this.setUseImageBuffer(false);
            }
        }
        return bufferedImage;
    }

    public synchronized void setUseImageBuffer(boolean value) {
        this.useImageBuffer = value;
    }

    public synchronized boolean isUseImageBuffer() {
        return this.useImageBuffer;
    }
}

