/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMPoint;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkPoint
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static final String LPC_POINT_OVAL = "oval";

    public static void write(float lt, float ln, int radius, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:POINT>".getBytes());
        dos.writeInt(9);
        dos.writeInt(1);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(radius);
        properties.write(dos);
    }

    public static void write(int px1, int py1, int radius, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:POINT>".getBytes());
        dos.writeInt(9);
        dos.writeInt(2);
        dos.writeInt(px1);
        dos.writeInt(py1);
        dos.writeInt(radius);
        properties.write(dos);
    }

    public static void write(float lt, float ln, int px1, int py1, int radius, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:POINT>".getBytes());
        dos.writeInt(9);
        dos.writeInt(3);
        dos.writeFloat(lt);
        dos.writeFloat(ln);
        dos.writeInt(px1);
        dos.writeInt(py1);
        dos.writeInt(radius);
        properties.write(dos);
    }

    public static void write(OMPoint point, Link link, LinkProperties props) throws IOException {
        props.setProperty(LPC_POINT_OVAL, point.isOval() ? "true" : "false");
        switch (point.getRenderType()) {
            case 1: {
                LinkPoint.write(point.getLat(), point.getLon(), point.getRadius(), props, (DataOutputStream)link.dos);
                break;
            }
            case 2: {
                LinkPoint.write(point.getX(), point.getY(), point.getRadius(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LinkPoint.write(point.getLat(), point.getLon(), point.getX(), point.getY(), point.getRadius(), props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkPoint.write: point rendertype unknown.");
            }
        }
    }

    public static OMPoint read(DataInputStream dis) throws IOException {
        OMPoint point = null;
        int renderType = dis.readInt();
        switch (renderType) {
            case 1: {
                float lt = dis.readFloat();
                float ln = dis.readFloat();
                int radius = dis.readInt();
                point = new OMPoint(lt, ln, radius);
                break;
            }
            case 2: {
                int x1 = dis.readInt();
                int y1 = dis.readInt();
                int radius = dis.readInt();
                point = new OMPoint(x1, y1, radius);
                break;
            }
            case 3: {
                float lt = dis.readFloat();
                float ln = dis.readFloat();
                int x1 = dis.readInt();
                int y1 = dis.readInt();
                int radius = dis.readInt();
                point = new OMPoint(lt, ln, x1, y1, radius);
                break;
            }
        }
        LinkProperties properties = new LinkProperties(dis);
        if (point != null) {
            properties.setProperties(point);
            point.setOval(PropUtils.booleanFromProperties(properties, LPC_POINT_OVAL, false));
        }
        return point;
    }
}

