/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkArc;
import com.bbn.openmap.layer.link.LinkBitmap;
import com.bbn.openmap.layer.link.LinkCircle;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkGrid;
import com.bbn.openmap.layer.link.LinkLine;
import com.bbn.openmap.layer.link.LinkOMGraphicList;
import com.bbn.openmap.layer.link.LinkPoint;
import com.bbn.openmap.layer.link.LinkPoly;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkRaster;
import com.bbn.openmap.layer.link.LinkRectangle;
import com.bbn.openmap.layer.link.LinkText;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGrid;
import com.bbn.openmap.omGraphics.grid.OMGridGenerator;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Image;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.swing.ImageIcon;

public class LinkGraphicList
implements LinkGraphicConstants {
    protected Link link = null;
    protected LinkOMGraphicList graphics = null;
    protected String linkStatus = "\r";
    protected static float version = 0.3f;
    protected LinkProperties properties;

    public LinkGraphicList(Link link, LinkProperties properties) throws IOException {
        this.link = link;
        link.start("<OMLINK:GRAPHICS>");
        link.dos.writeFloat(version);
        properties.write(link);
    }

    public LinkGraphicList(Link link, LinkOMGraphicList graphicList) throws IOException, EOFException {
        this(link, graphicList, null, null);
    }

    public LinkGraphicList(Link link, LinkOMGraphicList graphicList, Projection proj, OMGridGenerator generator) throws IOException, EOFException {
        this.link = link;
        this.graphics = graphicList;
        if (this.graphics == null) {
            this.graphics = new LinkOMGraphicList();
        }
        this.linkStatus = this.readGraphics(this.graphics, proj, generator);
    }

    public LinkOMGraphicList getGraphics() {
        return this.graphics;
    }

    public String getLinkStatus() {
        return this.linkStatus;
    }

    public LinkProperties getProperties() {
        return this.properties;
    }

    public void end(String endType) throws IOException {
        this.link.end(endType);
    }

    protected String readGraphics(LinkOMGraphicList graphics, Projection proj, OMGridGenerator generator) throws IOException, EOFException {
        long startTime = System.currentTimeMillis();
        String header = null;
        boolean moreData = true;
        graphics.setNeedToRegenerate(proj == null);
        float ver = this.link.dis.readFloat();
        if (ver != version) {
            if ((double)ver == 0.1) {
                throw new IOException("LinkGraphicList: Versions do not match! DANGER!");
            }
            Debug.message("link", "LinkGraphicList: Versions do not match.");
        }
        this.properties = new LinkProperties(this.link);
        Debug.message("link", "LinkGraphicList: reading graphics:");
        while (true) {
            OMGraphic graphic = null;
            header = this.link.readDelimiter(false);
            if (header == "\r" || header == "\n") {
                long endTime = System.currentTimeMillis();
                Debug.message("link", "LinkGraphicList: received " + graphics.size() + " graphics in " + (float)(endTime - startTime) / 1000.0f + " seconds");
                return header;
            }
            int graphicType = this.link.dis.readInt();
            switch (graphicType) {
                case 4: {
                    graphic = LinkLine.read(this.link.dis);
                    break;
                }
                case 3: {
                    graphic = LinkPoly.read(this.link.dis);
                    break;
                }
                case 5: {
                    graphic = LinkRectangle.read(this.link.dis);
                    break;
                }
                case 9: {
                    graphic = LinkPoint.read(this.link.dis);
                    break;
                }
                case 6: {
                    graphic = LinkCircle.read(this.link.dis);
                    break;
                }
                case 7: {
                    graphic = LinkRaster.read(this.link.dis);
                    break;
                }
                case 1: {
                    graphic = LinkBitmap.read(this.link.dis);
                    break;
                }
                case 2: {
                    graphic = LinkText.read(this.link.dis);
                    break;
                }
                case 8: {
                    graphic = LinkGrid.read(this.link.dis);
                    break;
                }
                default: {
                    throw new IOException("LinkGraphicList: received unknown graphic type.");
                }
            }
            if (graphic == null) continue;
            if (graphic instanceof OMGrid) {
                ((OMGrid)graphic).setGenerator(generator);
            }
            if (proj != null) {
                graphic.generate(proj);
            }
            graphics.add(graphic);
        }
    }

    public void addArc(float latPoint, float lonPoint, int w, int h, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(latPoint, lonPoint, 0, 0, w, h, s, e, properties, this.link.dos);
    }

    public void addArc(int x1, int y1, int w, int h, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(x1, y1, w, h, s, e, properties, (DataOutputStream)this.link.dos);
    }

    public void addArc(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(latPoint, lonPoint, offset_x1, offset_y1, w, h, s, e, properties, this.link.dos);
    }

    public void addArc(float latPoint, float lonPoint, float radius, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(latPoint, lonPoint, radius, -1, -1, s, e, properties, this.link.dos);
    }

    public void addArc(float latPoint, float lonPoint, float radius, int units, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(latPoint, lonPoint, radius, units, -1, s, e, properties, this.link.dos);
    }

    public void addArc(float latPoint, float lonPoint, float radius, int units, int nverts, float s, float e, LinkProperties properties) throws IOException {
        LinkArc.write(latPoint, lonPoint, radius, units, nverts, s, e, properties, this.link.dos);
    }

    public void addBitmap(float lt, float ln, int w, int h, byte[] bytes, LinkProperties properties) throws IOException {
        LinkBitmap.write(lt, ln, w, h, bytes, properties, (DataOutputStream)this.link.dos);
    }

    public void addBitmap(int x1, int y1, int w, int h, byte[] bytes, LinkProperties properties) throws IOException {
        LinkBitmap.write(x1, y1, w, h, bytes, properties, (DataOutputStream)this.link.dos);
    }

    public void addBitmap(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, LinkProperties properties) throws IOException {
        LinkBitmap.write(lt, ln, offset_x1, offset_y1, w, h, bytes, properties, this.link.dos);
    }

    public void addCircle(float latPoint, float lonPoint, int w, int h, LinkProperties properties) throws IOException {
        LinkCircle.write(latPoint, lonPoint, w, h, properties, (DataOutputStream)this.link.dos);
    }

    public void addCircle(int x1, int y1, int w, int h, LinkProperties properties) throws IOException {
        LinkCircle.write(x1, y1, w, h, properties, (DataOutputStream)this.link.dos);
    }

    public void addCircle(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, LinkProperties properties) throws IOException {
        LinkCircle.write(latPoint, lonPoint, offset_x1, offset_y1, w, h, properties, this.link.dos);
    }

    public void addCircle(float latPoint, float lonPoint, float radius, LinkProperties properties) throws IOException {
        LinkCircle.write(latPoint, lonPoint, radius, -1, -1, properties, this.link.dos);
    }

    public void addCircle(float latPoint, float lonPoint, float radius, int units, LinkProperties properties) throws IOException {
        LinkCircle.write(latPoint, lonPoint, radius, units, -1, properties, this.link.dos);
    }

    public void addCircle(float latPoint, float lonPoint, float radius, int units, int nverts, LinkProperties properties) throws IOException {
        LinkCircle.write(latPoint, lonPoint, radius, units, nverts, properties, this.link.dos);
    }

    public void addGrid(float lt, float ln, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties) throws IOException {
        LinkGrid.write(lt, ln, rows, columns, orientation, vResolution, hResolution, major, data, properties, (DataOutputStream)this.link.dos);
    }

    public void addGrid(int x1, int y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties) throws IOException {
        LinkGrid.write(x1, y1, rows, columns, orientation, vResolution, hResolution, major, data, properties, (DataOutputStream)this.link.dos);
    }

    public void addGrid(float lt, float ln, int offset_x1, int offset_y1, int rows, int columns, float orientation, float vResolution, float hResolution, int major, int[] data, LinkProperties properties) throws IOException {
        LinkGrid.write(lt, ln, offset_x1, offset_y1, rows, columns, orientation, vResolution, hResolution, major, data, properties, this.link.dos);
    }

    public void addLine(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, LinkProperties properties) throws IOException {
        LinkLine.write(lat_1, lon_1, lat_2, lon_2, lineType, properties, this.link.dos);
    }

    public void addLine(float lat_1, float lon_1, float lat_2, float lon_2, int lineType, int nsegs, LinkProperties properties) throws IOException {
        LinkLine.write(lat_1, lon_1, lat_2, lon_2, lineType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void addLine(int x1, int y1, int x2, int y2, LinkProperties properties) throws IOException {
        LinkLine.write(x1, y1, x2, y2, properties, this.link.dos);
    }

    public void addLine(float lat_1, float lon_1, int x1, int y1, int x2, int y2, LinkProperties properties) throws IOException {
        LinkLine.write(lat_1, lon_1, x1, y1, x2, y2, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, ImageIcon ii, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(lt, ln, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(int x1, int y1, ImageIcon ii, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(x1, y1, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int offset_x1, int offset_y1, ImageIcon ii, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(lt, ln, offset_x1, offset_y1, ii, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, Image image, int image_width, int image_height, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(lt, ln, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(int x1, int y1, Image image, int image_width, int image_height, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(x1, y1, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int offset_x1, int offset_y1, Image image, int image_width, int image_height, LinkProperties properties) throws IOException, InterruptedException {
        LinkRaster.write(lt, ln, offset_x1, offset_y1, image, image_width, image_height, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int w, int h, int[] pix, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(int x1, int y1, int w, int h, int[] pix, LinkProperties properties) throws IOException {
        LinkRaster.write(x1, y1, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int offset_x1, int offset_y1, int w, int h, int[] pix, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, offset_x1, offset_y1, w, h, pix, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, String url, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, url, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(int x1, int y1, String url, LinkProperties properties) throws IOException {
        LinkRaster.write(x1, y1, url, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int offset_x1, int offset_y1, String url, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, offset_x1, offset_y1, url, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, w, h, bytes, colorTable, trans, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(int x1, int y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties) throws IOException {
        LinkRaster.write(x1, y1, w, h, bytes, colorTable, trans, properties, (DataOutputStream)this.link.dos);
    }

    public void addRaster(float lt, float ln, int offset_x1, int offset_y1, int w, int h, byte[] bytes, Color[] colorTable, int trans, LinkProperties properties) throws IOException {
        LinkRaster.write(lt, ln, offset_x1, offset_y1, w, h, bytes, colorTable, trans, properties, this.link.dos);
    }

    public void addRectangle(float lt1, float ln1, float lt2, float ln2, int lType, LinkProperties properties) throws IOException {
        LinkRectangle.write(lt1, ln1, lt2, ln2, lType, properties, this.link.dos);
    }

    public void addRectangle(float lt1, float ln1, float lt2, float ln2, int lType, int nsegs, LinkProperties properties) throws IOException {
        LinkRectangle.write(lt1, ln1, lt2, ln2, lType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void addRectangle(int x1, int y1, int x2, int y2, LinkProperties properties) throws IOException {
        LinkRectangle.write(x1, y1, x2, y2, properties, this.link.dos);
    }

    public void addRectangle(float lt1, float ln1, int x1, int y1, int x2, int y2, LinkProperties properties) throws IOException {
        LinkRectangle.write(lt1, ln1, x1, y1, x2, y2, properties, (DataOutputStream)this.link.dos);
    }

    public void addPoint(float lt1, float ln1, int radius, LinkProperties properties) throws IOException {
        LinkPoint.write(lt1, ln1, radius, properties, (DataOutputStream)this.link.dos);
    }

    public void addPoint(int x1, int y1, int radius, LinkProperties properties) throws IOException {
        LinkPoint.write(x1, y1, radius, properties, (DataOutputStream)this.link.dos);
    }

    public void addPoint(float lt1, float ln1, int x1, int y1, int radius, LinkProperties properties) throws IOException {
        LinkPoint.write(lt1, ln1, x1, y1, radius, properties, this.link.dos);
    }

    public void addPoly(float[] llPoints, int units, int lType, LinkProperties properties) throws IOException {
        LinkPoly.write(llPoints, units, lType, properties, this.link.dos);
    }

    public void addPoly(float[] llpoints, int units, int lType, int nsegs, LinkProperties properties) throws IOException {
        LinkPoly.write(llpoints, units, lType, nsegs, properties, (DataOutputStream)this.link.dos);
    }

    public void addPoly(int[] xypoints, LinkProperties properties) throws IOException {
        LinkPoly.write(xypoints, properties, this.link.dos);
    }

    public void addPoly(int[] xpoints, int[] ypoints, LinkProperties properties) throws IOException {
        LinkPoly.write(xpoints, ypoints, properties, this.link.dos);
    }

    public void addPoly(float latPoint, float lonPoint, int[] xypoints, int cMode, LinkProperties properties) throws IOException {
        LinkPoly.write(latPoint, lonPoint, xypoints, cMode, properties, (DataOutputStream)this.link.dos);
    }

    public void addPoly(float latPoint, float lonPoint, int[] xpoints, int[] ypoints, int cMode, LinkProperties properties) throws IOException {
        LinkPoly.write(latPoint, lonPoint, xpoints, ypoints, cMode, properties, (DataOutputStream)this.link.dos);
    }

    public void addText(float latPoint, float lonPoint, String stuff, int justify, LinkProperties properties) throws IOException {
        LinkText.write(latPoint, lonPoint, stuff, LinkText.DEFAULT_FONT, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void addText(int x, int y, String stuff, int justify, LinkProperties properties) throws IOException {
        LinkText.write(x, y, stuff, LinkText.DEFAULT_FONT, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void addText(float latPoint, float lonPoint, int offset_x, int offset_y, String stuff, int justify, LinkProperties properties) throws IOException {
        LinkText.write(latPoint, lonPoint, offset_x, offset_y, stuff, LinkText.DEFAULT_FONT, justify, properties, this.link.dos);
    }

    public void addText(float latPoint, float lonPoint, String stuff, String font, int justify, LinkProperties properties) throws IOException {
        LinkText.write(latPoint, lonPoint, stuff, font, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void addText(int x, int y, String stuff, String font, int justify, LinkProperties properties) throws IOException {
        LinkText.write(x, y, stuff, font, justify, properties, (DataOutputStream)this.link.dos);
    }

    public void addText(float latPoint, float lonPoint, int offset_x, int offset_y, String stuff, String font, int justify, LinkProperties properties) throws IOException {
        LinkText.write(latPoint, lonPoint, offset_x, offset_y, stuff, font, justify, properties, this.link.dos);
    }
}

