/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.link;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.layer.link.Link;
import com.bbn.openmap.layer.link.LinkGraphicConstants;
import com.bbn.openmap.layer.link.LinkProperties;
import com.bbn.openmap.layer.link.LinkPropertiesConstants;
import com.bbn.openmap.omGraphics.OMArc;
import com.bbn.openmap.proj.Length;
import com.bbn.openmap.util.Debug;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LinkArc
implements LinkGraphicConstants,
LinkPropertiesConstants {
    public static void write(float latPoint, float lonPoint, int w, int h, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkArc.write(latPoint, lonPoint, 0, 0, w, h, s, e, properties, dos);
    }

    public static void write(int x1, int y1, int w, int h, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:ARC>".getBytes());
        dos.writeInt(10);
        dos.writeInt(2);
        dos.writeInt(x1);
        dos.writeInt(y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeFloat(s);
        dos.writeFloat(e);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, int offset_x1, int offset_y1, int w, int h, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:ARC>".getBytes());
        dos.writeInt(10);
        dos.writeInt(3);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeInt(offset_x1);
        dos.writeInt(offset_y1);
        dos.writeInt(w);
        dos.writeInt(h);
        dos.writeFloat(s);
        dos.writeFloat(e);
        properties.write(dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkArc.write(latPoint, lonPoint, radius, -1, -1, s, e, properties, dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, int units, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        LinkArc.write(latPoint, lonPoint, radius, units, -1, s, e, properties, dos);
    }

    public static void write(float latPoint, float lonPoint, float radius, int units, int nverts, float s, float e, LinkProperties properties, DataOutputStream dos) throws IOException {
        dos.write("<OMLINK:ARC>".getBytes());
        dos.writeInt(10);
        dos.writeInt(1);
        dos.writeFloat(latPoint);
        dos.writeFloat(lonPoint);
        dos.writeFloat(radius);
        dos.writeInt(units);
        dos.writeInt(nverts);
        dos.writeFloat(s);
        dos.writeFloat(e);
        properties.write(dos);
    }

    public static void write(OMArc arc, Link link, LinkProperties props) throws IOException {
        switch (arc.getRenderType()) {
            case 1: {
                LatLonPoint llp = arc.getLatLon();
                LinkArc.write(llp.getLatitude(), llp.getLongitude(), arc.getRadius(), arc.getStartAngle(), arc.getExtentAngle(), props, link.dos);
                break;
            }
            case 2: {
                LinkArc.write(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getStartAngle(), arc.getExtentAngle(), props, (DataOutputStream)link.dos);
                break;
            }
            case 3: {
                LatLonPoint llp = arc.getLatLon();
                LinkArc.write(llp.getLatitude(), llp.getLongitude(), arc.getOffX(), arc.getOffY(), arc.getWidth(), arc.getHeight(), arc.getStartAngle(), arc.getExtentAngle(), props, link.dos);
                break;
            }
            default: {
                Debug.error("LinkArc.write: arc rendertype unknown.");
            }
        }
    }

    public static OMArc read(DataInputStream dis) throws IOException {
        OMArc arc = null;
        int renderType = dis.readInt();
        switch (renderType) {
            case 1: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                float radius = dis.readFloat();
                float start = dis.readFloat();
                float extent = dis.readFloat();
                int units = dis.readInt();
                int nverts = dis.readInt();
                Length unit = Length.DECIMAL_DEGREE;
                switch (units) {
                    case 0: {
                        unit = Length.KM;
                        break;
                    }
                    case 1: {
                        unit = Length.MILE;
                        break;
                    }
                    case 2: {
                        unit = Length.NM;
                        break;
                    }
                }
                arc = new OMArc(new LatLonPoint(lat, lon), radius, unit, nverts, start, extent);
                break;
            }
            case 2: {
                int x = dis.readInt();
                int y = dis.readInt();
                int w = dis.readInt();
                int h = dis.readInt();
                float start = dis.readFloat();
                float extent = dis.readFloat();
                arc = new OMArc(x, y, w, h, start, extent);
                break;
            }
            case 3: {
                float lat = dis.readFloat();
                float lon = dis.readFloat();
                int x = dis.readInt();
                int y = dis.readInt();
                int w = dis.readInt();
                int h = dis.readInt();
                float start = dis.readFloat();
                float extent = dis.readFloat();
                arc = new OMArc(lat, lon, x, y, w, h, start, extent);
                break;
            }
        }
        LinkProperties properties = new LinkProperties(dis);
        if (arc != null) {
            properties.setProperties(arc);
        }
        return arc;
    }
}

