/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer.e00;

import com.bbn.openmap.layer.e00.E00Data;
import com.bbn.openmap.layer.e00.TX7;
import com.bbn.openmap.layer.location.BasicLocation;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.util.Debug;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class E00Parser {
    protected OMGraphicList labs;
    protected OMGraphicList arcs;
    protected OMGraphicList tx7;
    protected BufferedReader isr;
    protected String prefix;
    protected int narc = 1;
    protected int npoint = 1;
    protected int unClosedCount = 0;
    protected Paint[] ArcColors = defaultColors;
    protected Paint[] LabColors = defaultColors;
    protected Paint tx7Color;
    protected Paint SelectTX7Color;
    protected Paint SelectLabColor;
    protected Paint SelectArcColor;
    protected Paint LabTextColor;
    protected Font labFont;
    protected Font tx7Font;
    protected OMGraphic LabMarker;
    protected Color defaultcolor = Color.blue;
    public static final Color[] defaultColors = new Color[]{Color.black, Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static E00Record infoRecord = new E00Record(new int[]{0, 30, 34, 38, 42, 46, 56}, new int[]{20, 20, 50, 50, 50, 50}, null);
    protected static E00Record itemRecord = new E00Record(new int[]{0, 14, 19, 21, 26, 28, 32, 34, 37, 39, 43, 47, 49, 69}, new int[]{20, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50}, null);

    public E00Parser(String mdname) throws IOException {
        this.isr = new BufferedReader(new FileReader(mdname));
        this.setPrefix(mdname);
    }

    public E00Parser(File f) throws IOException {
        this.isr = new BufferedReader(new FileReader(f));
        this.setPrefix(f.getName());
    }

    public void setPrefix(String S) {
        int n = S.indexOf(46);
        this.prefix = n == -1 ? S.toUpperCase() : S.substring(0, n).toUpperCase();
    }

    public void setPaints(Paint[] ArcColors, Paint[] LabColors, Paint tx7Color, Paint SelectTX7Color, Paint SelectLabColor, Paint SelectArcColor, Paint LabTextColor) {
        this.ArcColors = ArcColors == null ? defaultColors : ArcColors;
        this.LabColors = LabColors == null ? defaultColors : LabColors;
        this.tx7Color = tx7Color;
        this.SelectTX7Color = SelectTX7Color;
        this.SelectLabColor = SelectLabColor;
        this.SelectArcColor = SelectArcColor;
        this.LabTextColor = LabTextColor;
    }

    public void setFonts(Font labFont, Font tx7Font) {
        this.labFont = labFont;
        this.tx7Font = tx7Font;
    }

    public void setLabMarker(OMGraphic marker) {
        this.LabMarker = marker;
    }

    public OMGraphicList getOMGraphics() throws IOException {
        String S;
        OMGraphicList WV = new OMGraphicList();
        this.isr.readLine();
        while ((S = this.isr.readLine()) != null) {
            if (S.startsWith("ARC")) {
                this.readARC();
                continue;
            }
            if (S.startsWith("LAB")) {
                this.readLAB();
                continue;
            }
            if (S.startsWith("IFO")) {
                this.readIFO();
                continue;
            }
            if (S.startsWith("LOG")) {
                this.readLOG();
                continue;
            }
            if (S.startsWith("PRJ")) {
                this.readPRJ();
                continue;
            }
            if (S.startsWith("CNT")) {
                this.readCNT();
                continue;
            }
            if (S.startsWith("PAL")) {
                this.readPAL();
                continue;
            }
            if (S.startsWith("SIN")) {
                this.readSIN();
                continue;
            }
            if (S.startsWith("TOL")) {
                this.readTOL();
                continue;
            }
            if (S.startsWith("TX7")) {
                this.readTX7();
                continue;
            }
            if (!S.startsWith("EOS")) continue;
            break;
        }
        if (this.labs != null) {
            this.labs.setAppObject("LABS");
            WV.add(this.labs);
        }
        if (this.arcs != null) {
            this.arcs.setAppObject("ARCS");
            WV.add(this.arcs);
        }
        if (this.tx7 != null) {
            this.tx7.setAppObject("TX7");
            WV.add(this.tx7);
        }
        return WV;
    }

    public OMGraphic getLabMarker() {
        return this.LabMarker;
    }

    void parseString(String S, int[] I, int l) {
        int i = 0;
        int j = 0;
        while (i < I.length && j < S.length()) {
            I[i++] = Integer.parseInt(S.substring(j, j + l).trim());
            j += l;
        }
    }

    void parseString(String S, float[] F) {
        int i = 0;
        int j = 0;
        while (i < F.length && j < S.length()) {
            F[i++] = Float.parseFloat(S.substring(j, j + 14).trim());
            j += 14;
        }
    }

    void readSIN() throws IOException {
        String S;
        do {
            if ((S = this.isr.readLine()) != null) continue;
            return;
        } while (!S.startsWith("EOX"));
    }

    void readCNT() throws IOException {
        String S;
        int[] header = new int[1];
        while ((S = this.isr.readLine()) != null) {
            this.parseString(S, header, 10);
            int n = header[0];
            if (n == -1) break;
            int i = 0;
            while (i < n) {
                this.isr.readLine();
                ++i;
            }
        }
    }

    void readTOL() throws IOException {
        String S;
        int[] header = new int[1];
        while ((S = this.isr.readLine()) != null) {
            this.parseString(S, header, 10);
            if (header[0] != -1) continue;
            break;
        }
    }

    void readPAL() throws IOException {
        String S;
        int[] header = new int[1];
        while ((S = this.isr.readLine()) != null) {
            this.parseString(S, header, 10);
            int n = header[0];
            if (n == -1) break;
            int i = 0;
            while (i < n) {
                this.isr.readLine();
                i += 2;
            }
        }
    }

    void readTX7() throws IOException {
        String S;
        Debug.message("e00", "E00: read TX7");
        this.tx7 = new OMGraphicList();
        int[] header = new int[8];
        float[] coords = new float[2];
        this.isr.readLine();
        while ((S = this.isr.readLine()) != null) {
            this.parseString(S, header, 10);
            if (header[0] == -1) break;
            int n = header[2];
            int i = 0;
            while (i < 8) {
                this.isr.readLine();
                ++i;
            }
            float[] llpoints = new float[2 * n];
            int k = 0;
            int j = 0;
            while (j < n) {
                S = this.isr.readLine();
                if (S == null) {
                    return;
                }
                this.parseString(S, coords);
                llpoints[k++] = coords[1];
                llpoints[k++] = coords[0];
                ++j;
            }
            S = this.isr.readLine();
            TX7 t = new TX7(llpoints, S, false, this.tx7Font);
            if (this.tx7Color != null) {
                t.setLinePaint(this.tx7Color);
            }
            if (this.SelectTX7Color != null) {
                t.setSelectPaint(this.SelectTX7Color);
            }
            this.tx7.add(t);
        }
    }

    void readLOG() throws IOException {
        String S;
        do {
            if ((S = this.isr.readLine()) != null) continue;
            return;
        } while (!S.startsWith("EOL"));
    }

    void readPRJ() throws IOException {
        String S;
        do {
            if ((S = this.isr.readLine()) != null) continue;
            return;
        } while (!S.startsWith("EOP"));
    }

    void readLAB() throws IOException {
        String S;
        Debug.message("e00", "E00: read LAB");
        this.labs = new OMGraphicList();
        float[] coords = new float[2];
        int[] header = new int[1];
        while ((S = this.isr.readLine()) != null) {
            this.parseString(S, header, 10);
            int id = header[0];
            if (id == -1 || (S = this.isr.readLine()) == null) break;
            this.parseString(S, coords);
            BasicLocation bl = new BasicLocation(coords[1], coords[0], "", this.LabMarker);
            this.setLocationColor(bl, 0);
            bl.setShowLocation(true);
            this.labs.add(bl);
            bl.setAppObject(new E00Data(id));
        }
    }

    void readARC() throws IOException {
        Debug.message("e00", "E00: read ARC");
        this.arcs = new OMGraphicList();
        int narc = 1;
        int[] header = new int[7];
        float[] coords = new float[4];
        while (true) {
            String S;
            if ((S = this.isr.readLine()) == null) {
                return;
            }
            this.parseString(S, header, 10);
            if (header[0] == -1) break;
            int n = header[6];
            float[] llpoints = new float[2 * n];
            int k = 0;
            int j = 0;
            while (j < n) {
                S = this.isr.readLine();
                if (S == null) {
                    return;
                }
                this.parseString(S, coords);
                llpoints[k++] = coords[1];
                llpoints[k++] = coords[0];
                if (++j >= n) break;
                llpoints[k++] = coords[3];
                llpoints[k++] = coords[2];
                ++j;
            }
            OMPoly P = new OMPoly(llpoints, 0, 1);
            P.setLinePaint(this.getArcPaint(0));
            if (this.SelectArcColor != null) {
                P.setSelectPaint(this.SelectArcColor);
            }
            this.arcs.add(P);
            P.setAppObject(new E00Data(narc++));
        }
    }

    void readAAT() throws IOException {
        String S;
        String C = this.prefix + ".AAT";
        do {
            if ((S = this.isr.readLine()) != null) continue;
            return;
        } while (!S.startsWith(C));
        int n = Integer.parseInt(S.substring(46).trim());
        Debug.message("e00", "E00: read " + C + " " + n + " points");
        int i = 0;
        while (i < 9) {
            this.isr.readLine();
            ++i;
        }
        int[] I = new int[2];
        int i2 = 0;
        while (i2 < n) {
            this.isr.readLine();
            S = this.isr.readLine();
            this.parseString(S, I, 2);
            this.arcs.getOMGraphicAt(i2).setLinePaint(this.getArcPaint(I[0]));
            ++i2;
        }
    }

    void readPAT() throws IOException {
        String S;
        String C = this.prefix + ".PAT";
        do {
            if ((S = this.isr.readLine()) != null) continue;
            return;
        } while (!S.startsWith(C));
        int n = Integer.parseInt(S.substring(46).trim());
        Debug.message("e00", "E00: read " + C + " " + n + " points");
        int i = 0;
        while (i < 7) {
            this.isr.readLine();
            ++i;
        }
        int[] I = new int[1];
        int i2 = 0;
        while (i2 < n) {
            S = this.isr.readLine();
            if (S == null) break;
            String name = S.substring(50);
            S = this.isr.readLine();
            this.parseString(S, I, 14);
            BasicLocation bl = (BasicLocation)this.labs.getOMGraphicAt(i2);
            if (S.length() != 0) {
                bl.setName(name);
            } else {
                bl.setLabel(null);
            }
            this.setLocationColor(bl, I[0]);
            bl.setShowLocation(true);
            ++i2;
        }
    }

    void readIFO() throws IOException {
        while (true) {
            infoRecord.read(this.isr);
            String info = infoRecord.getStringField(0).trim();
            if (info.startsWith("EOI")) break;
            int n = infoRecord.getIntField(5);
            E00Record r = this.getRecord();
            if (!info.startsWith(this.prefix)) {
                this.readANY(r, n);
            } else {
                String suffix = info.substring(this.prefix.length() + 1);
                if (suffix.equals("PAT")) {
                    this.readPAT(r, n);
                } else if (suffix.equals("AAT")) {
                    this.readAAT(r, n);
                } else if (suffix.equals("BND")) {
                    this.readANY(r, n);
                } else if (suffix.equals("TIC")) {
                    this.readANY(r, n);
                } else {
                    this.readANY(r, n);
                }
            }
            Debug.message("e00", "E00: " + info + "  " + n);
        }
    }

    void readANY(E00Record r, int n) throws IOException {
        int i = 0;
        while (i < n) {
            r.read(this.isr);
            ++i;
        }
    }

    void readPAT(E00Record r, int n) throws IOException {
        int itype = r.getItemIndex(this.prefix.substring(0, 2) + "PTTYPE");
        int ival = r.getItemIndex(this.prefix.substring(0, 2) + "PTVAL");
        int ival2 = r.getItemIndex(this.prefix.substring(0, 2) + "PYTYPE");
        int iname = r.getItemIndex(this.prefix.substring(0, 2) + "PTNAME");
        int iflag = r.getItemIndex(this.prefix.substring(0, 2) + "PTFLAG");
        int i = 0;
        while (i < n) {
            r.read(this.isr);
            BasicLocation bl = (BasicLocation)this.labs.getOMGraphicAt(i);
            String S = r.getStringField(iname).trim();
            if (bl != null) {
                if (S.length() != 0) {
                    Debug.message("e00", S);
                    bl.setName(S);
                    bl.setShowName(true);
                } else {
                    bl.setLabel(null);
                }
                E00Data d = (E00Data)bl.getAppObject();
                if (itype != -1) {
                    d.type = r.getIntField(itype);
                }
                if (ival != -1) {
                    d.valeur = r.getIntField(ival);
                }
                d.valeur2 = ival2 != -1 ? r.getIntField(ival2) : d.valeur;
                if (itype >= 0) {
                    this.setLocationColor(bl, r.getIntField(itype));
                }
            }
            ++i;
        }
    }

    void readAAT(E00Record r, int n) throws IOException {
        boolean k = false;
        int type = Integer.MIN_VALUE;
        int val = Integer.MIN_VALUE;
        int itype = r.getItemIndex(this.prefix.substring(0, 2) + "LNTYPE");
        int ival = r.getItemIndex(this.prefix.substring(0, 2) + "LNVAL");
        int iID = r.getItemIndex(this.prefix.substring(0, 2) + "NET-ID");
        int ID = -1;
        int i = 0;
        while (i < n) {
            r.read(this.isr);
            if (itype != -1 || ival != -1) {
                OMGraphic og = this.arcs.getOMGraphicAt(i);
                if (itype != -1) {
                    type = r.getIntField(itype);
                    og.setLinePaint(this.getArcPaint(type));
                }
                if (ival != -1) {
                    val = r.getIntField(ival);
                }
                if (iID != -1) {
                    ID = r.getIntField(iID);
                }
                E00Data data = (E00Data)og.getAppObject();
                data.type = type;
                data.valeur = val;
                data.valeur2 = val;
                data.ID = ID;
            }
            ++i;
        }
    }

    private void setLocationColor(BasicLocation bl, int t) {
        if (bl == null) {
            return;
        }
        Paint c = this.getLabPaint(t);
        OMText label = bl.getLabel();
        if (label != null) {
            if (this.LabTextColor != null) {
                label.setLinePaint(this.LabTextColor);
            } else {
                label.setLinePaint(c);
            }
            if (this.labFont != null) {
                label.setFont(this.labFont);
            }
        }
        bl.setLocationPaint(c);
        if (this.SelectLabColor != null) {
            bl.setSelectPaint(this.SelectLabColor);
        }
    }

    private Paint getArcPaint(int i) {
        if (i >= this.ArcColors.length) {
            i = this.ArcColors.length - 1;
        }
        if (i < 0) {
            i = 0;
        }
        return this.ArcColors[i];
    }

    private Paint getLabPaint(int i) {
        if (i >= this.LabColors.length) {
            i = this.LabColors.length - 1;
        }
        if (i < 0) {
            i = 0;
        }
        return this.LabColors[i];
    }

    private E00Record getRecord() throws IOException {
        int itemNumber = infoRecord.getIntField(2);
        int[] positions = new int[itemNumber + 1];
        int[] types = new int[itemNumber];
        String[] names = new String[itemNumber];
        int i = 0;
        while (i < itemNumber) {
            itemRecord.read(this.isr);
            types[i] = itemRecord.getIntField(7);
            names[i] = itemRecord.getStringField(0).trim();
            int p = positions[i];
            switch (types[i]) {
                case 20: {
                    positions[i + 1] = p + itemRecord.getIntField(5);
                    break;
                }
                case 30: {
                    positions[i + 1] = p + itemRecord.getIntField(5);
                    break;
                }
                case 50: {
                    positions[i + 1] = p + 11;
                    break;
                }
                case 60: {
                    positions[i + 1] = p + 14;
                }
            }
            ++i;
        }
        return new E00Record(positions, types, names);
    }

    public OMGraphicList getArcList() {
        return this.arcs;
    }

    public OMGraphicList getLabList() {
        return this.labs;
    }

    public OMGraphicList getTx7List() {
        return this.tx7;
    }

    static class E00Record {
        String[] itemName;
        int n;
        int[] fieldType;
        int[] fieldPosition;
        private String[] stringField;
        private float[] floatField;
        private int[] intField;

        E00Record(int[] positions, int[] types, String[] names) {
            this.fieldType = types;
            this.fieldPosition = positions;
            this.itemName = names;
            this.n = positions.length - 1;
            if (types.length < this.n) {
                this.n = types.length;
                System.err.println("E00Record err 1");
            }
            this.stringField = new String[this.n];
            this.floatField = new float[this.n];
            this.intField = new int[this.n];
        }

        int getIntField(int f) {
            if (f < 0) {
                return Integer.MIN_VALUE;
            }
            return this.intField[f];
        }

        float getFloatField(int f) {
            if (f < 0) {
                return Float.MIN_VALUE;
            }
            return this.floatField[f];
        }

        String getStringField(int f) {
            if (f < 0) {
                return "";
            }
            return this.stringField[f];
        }

        int getItemIndex(String S) {
            if (this.itemName == null) {
                return -1;
            }
            int i = 0;
            while (i < this.itemName.length) {
                if (this.itemName[i].equals(S)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        void read(BufferedReader isr) throws IOException {
            String Line2 = isr.readLine();
            int delta = 0;
            int i = 0;
            while (i < this.n) {
                block12: {
                    int n1 = this.fieldPosition[i] - delta;
                    int n2 = this.fieldPosition[i + 1] - delta;
                    if (n1 > 80) {
                        delta += 80;
                        n1 -= 80;
                        n2 -= 80;
                        Line2 = isr.readLine();
                    }
                    String S = n1 >= Line2.length() ? "" : (n2 < Line2.length() ? Line2.substring(n1, n2) : Line2.substring(n1));
                    if (n2 > 80) {
                        delta += 80;
                        Line2 = isr.readLine();
                        if ((n2 -= 80) < Line2.length()) {
                            S = S + Line2.substring(0, n2);
                        } else {
                            S = Line2;
                            Debug.message("e00", "??" + S);
                        }
                    }
                    try {
                        switch (this.fieldType[i]) {
                            case 20: {
                                this.stringField[i] = S;
                                break;
                            }
                            case 30: 
                            case 50: {
                                this.intField[i] = Integer.parseInt(S.trim());
                                break;
                            }
                            case 60: {
                                this.floatField[i] = Float.parseFloat(S.trim());
                            }
                        }
                    }
                    catch (NumberFormatException e) {
                        if (Line2.startsWith("EOI")) break block12;
                        Debug.message("e00", "E00:parserr " + i + " " + this.fieldPosition[i] + " " + this.fieldPosition[i + 1] + " " + S);
                        Debug.message("e00", ">" + Line2);
                    }
                }
                ++i;
            }
        }

        void print() {
            System.out.print("Record ");
            int i = 0;
            while (i < this.n + 1) {
                System.out.print(this.fieldPosition[i] + " ");
                ++i;
            }
            System.out.println();
            System.out.print("       ");
            int i2 = 0;
            while (i2 < this.n) {
                System.out.print(this.fieldType[i2] + " ");
                ++i2;
            }
            System.out.println();
        }
    }
}

