/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Layer;
import com.bbn.openmap.MouseDelegator;
import com.bbn.openmap.event.InfoDisplayEvent;
import com.bbn.openmap.event.InfoDisplayListener;
import com.bbn.openmap.event.LayerStatusEvent;
import com.bbn.openmap.event.LayerStatusListener;
import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.MapMouseMode;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.SinkLayer;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.OverlayLayout;

public class ScaleFilterLayer
extends Layer
implements InfoDisplayListener,
LayerStatusListener,
PropertyChangeListener,
MapMouseListener {
    public static final transient String layersProperty = "layers";
    public static final transient String transitionScalesProperty = "transitionScales";
    protected Vector layers;
    protected float[] transitionScales;
    protected float defaultTransitionScale = 4.0E7f;
    protected int targetIndex = -1;
    protected JPanel panel = null;
    protected JTabbedPane tabs = null;
    protected String mmID = null;
    protected boolean coolMM = false;
    protected MapMouseListener clmml = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$SinkLayer;

    public ScaleFilterLayer() {
        this.setLayout(new OverlayLayout(this));
        this.setAddToBeanContext(true);
    }

    public Vector getLayers() {
        if (this.layers == null) {
            this.layers = new Vector();
        }
        return this.layers;
    }

    public float[] getTransitionScales() {
        return this.transitionScales;
    }

    public void setLayersAndScales(Vector list, float[] scales) {
        this.layers = list;
        this.transitionScales = scales;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.parseLayers(prefix, props);
        this.parseScales(prefix, props);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        float[] ts = this.getTransitionScales();
        StringBuffer tsBuffer = new StringBuffer();
        if (ts != null) {
            int i = 0;
            while (i < ts.length) {
                tsBuffer.append(Float.toString(ts[i]) + " ");
                ++i;
            }
        }
        props.put(prefix + transitionScalesProperty, tsBuffer.toString());
        StringBuffer layerBuffer = new StringBuffer();
        Iterator it = this.getLayers().iterator();
        while (it.hasNext()) {
            Layer layer = (Layer)it.next();
            layerBuffer.append(layer.getPropertyPrefix() + " ");
            layer.getProperties(props);
        }
        props.put(prefix + layersProperty, layerBuffer.toString());
        return props;
    }

    protected Layer getAppropriateLayer() {
        Vector target = this.getLayers();
        if (target == null) {
            return SinkLayer.getSharedInstance();
        }
        if (this.targetIndex < 0 || this.targetIndex > target.size()) {
            return SinkLayer.getSharedInstance();
        }
        Layer l = (Layer)target.elementAt(this.targetIndex);
        return l;
    }

    protected void parseLayers(String prefix, Properties props) {
        String layersString = props.getProperty(prefix + layersProperty);
        Vector layers = this.getLayers();
        if (layersString == null || layersString.equals("")) {
            Debug.error("ScaleFilterLayer(): null layersString!");
            return;
        }
        StringTokenizer tok = new StringTokenizer(layersString);
        while (tok.hasMoreTokens()) {
            SinkLayer obj;
            String layerName = tok.nextToken();
            String classProperty = layerName + ".class";
            String className = props.getProperty(classProperty);
            if (className == null) {
                Debug.error("ScaleFilterLayer.parseLayers(): Failed to locate property \"" + classProperty + "\"");
                Debug.error("ScaleFilterLayer.parseLayers(): Skipping layer \"" + layerName + "\"");
                className = (class$com$bbn$openmap$layer$SinkLayer == null ? ScaleFilterLayer.class$("com.bbn.openmap.layer.SinkLayer") : class$com$bbn$openmap$layer$SinkLayer).getName();
            }
            try {
                obj = className.equals((class$com$bbn$openmap$layer$SinkLayer == null ? ScaleFilterLayer.class$("com.bbn.openmap.layer.SinkLayer") : class$com$bbn$openmap$layer$SinkLayer).getName()) ? SinkLayer.getSharedInstance() : Class.forName(className).newInstance();
                if (Debug.debugging("ScaleFilterLayer")) {
                    Debug.output("ScaleFilterLayer.parseLayers(): Instantiated " + className);
                }
            }
            catch (Exception e) {
                Debug.error("ScaleFilterLayer.parseLayers(): Failed to instantiate \"" + className + "\": " + e);
                obj = SinkLayer.getSharedInstance();
            }
            if (!(obj instanceof Layer)) continue;
            Layer l = obj;
            l.setProperties(layerName, props);
            l.addLayerStatusListener(this);
            l.addInfoDisplayListener(this);
            layers.addElement(l);
        }
    }

    protected void parseScales(String prefix, Properties props) {
        StringTokenizer tok = null;
        Vector layers = this.getLayers();
        int size = layers.size();
        if (size > 0) {
            --size;
        }
        this.transitionScales = new float[size];
        String scales = props.getProperty(prefix + transitionScalesProperty);
        if (scales == null) {
            Debug.error("ScaleFilterLayer.parseScales(): Failed to locate property \"transitionScales\"");
            if (this.transitionScales.length > 0) {
                this.transitionScales[0] = this.defaultTransitionScale;
            }
            int i = 1;
            while (i < this.transitionScales.length) {
                this.transitionScales[i] = this.transitionScales[i - 1] / 3.0f;
                ++i;
            }
            return;
        }
        try {
            tok = new StringTokenizer(scales);
            this.transitionScales[0] = tok.hasMoreTokens() ? new Float(tok.nextToken()).floatValue() : this.defaultTransitionScale;
        }
        catch (NumberFormatException e) {
            Debug.error("ScaleFilterLayer.parseScales()1: " + e);
            this.transitionScales[0] = this.defaultTransitionScale;
        }
        int i = 1;
        while (i < this.transitionScales.length) {
            try {
                this.transitionScales[i] = tok.hasMoreTokens() ? new Float(tok.nextToken()).floatValue() : this.transitionScales[i - 1] / 3.0f;
            }
            catch (NumberFormatException e) {
                Debug.error("ScaleFilterLayer.parseScales()2: " + e);
                this.transitionScales[i] = this.transitionScales[i - 1] / 3.0f;
            }
            ++i;
        }
    }

    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            Debug.error("ScaleFilterLayer.renderDataForProjection: null projection!");
            return;
        }
        boolean changed = this.setTargetIndex(proj.getScale());
        Layer layer = this.getAppropriateLayer();
        layer.renderDataForProjection(proj, g);
    }

    public boolean setTargetIndex(float scale) {
        boolean changed = false;
        float[] target = this.transitionScales;
        int i = 0;
        if (target != null) {
            i = 0;
            while (i < target.length) {
                if (scale > target[i]) break;
                ++i;
            }
        }
        if (this.targetIndex != i) {
            changed = true;
        }
        this.targetIndex = i;
        if (Debug.debugging("scalefilterlayer")) {
            Debug.output("ScaleFilterLayer(" + this.getName() + ") targetIndex: " + this.targetIndex + ", changed: " + changed);
        }
        return changed;
    }

    public void projectionChanged(ProjectionEvent ev) {
        Projection proj = ev.getProjection();
        Layer currentLayer = this.getAppropriateLayer();
        boolean changed = this.setTargetIndex(proj.getScale());
        Layer layer = this.getAppropriateLayer();
        if (changed) {
            currentLayer.removeNotify();
            this.setPaletteTab(this.targetIndex);
            this.remove(currentLayer);
            this.add(layer);
            layer.addNotify();
            this.checkMouseMode();
        }
        this.fireStatusUpdate(8342);
        layer.projectionChanged(ev);
    }

    public void paint(Graphics g) {
        this.getAppropriateLayer().paint(g);
        this.fireStatusUpdate(8359);
    }

    public void updateLayerStatus(LayerStatusEvent evt) {
        int status = evt.getStatus();
        this.fireStatusUpdate(evt);
    }

    public Component getGUI() {
        if (this.panel == null) {
            Iterator it = this.getLayers().iterator();
            this.panel = new JPanel();
            this.tabs = new JTabbedPane();
            JPanel bfPanel = new JPanel();
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            bfPanel.setLayout(gridbag);
            this.tabs.addTab("Scale Filter Controls", bfPanel);
            JButton gotoButton = new JButton("Go to Active Layer Tab");
            gotoButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    ScaleFilterLayer.this.setPaletteTab(ScaleFilterLayer.this.targetIndex);
                }
            });
            c.gridy = 0;
            gridbag.setConstraints(gotoButton, c);
            bfPanel.add(gotoButton);
            while (it.hasNext()) {
                Layer layer = (Layer)it.next();
                Component layerGUI = layer.getGUI();
                if (layerGUI != null) {
                    this.tabs.addTab(layer.getName(), layerGUI);
                    continue;
                }
                this.tabs.addTab(layer.getName(), this.getEmptyGUIFiller(layer));
            }
            this.panel.add(this.tabs);
        }
        this.setPaletteTab(this.targetIndex);
        return this.panel;
    }

    public Component getEmptyGUIFiller(Layer layer) {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gridbag);
        JLabel label = new JLabel("No properties available for");
        JLabel label2 = new JLabel("the " + layer.getName() + ".");
        c.gridwidth = 0;
        gridbag.setConstraints(label, c);
        gridbag.setConstraints(label2, c);
        panel.add(label);
        panel.add(label2);
        return panel;
    }

    protected void setPaletteTab(int layerIndex) {
        Vector layers = this.getLayers();
        if (layers.size() > layerIndex && this.tabs != null && layerIndex < this.tabs.getTabCount()) {
            this.tabs.setSelectedIndex(layerIndex + 1);
        }
    }

    public void requestURL(InfoDisplayEvent event) {
        this.fireRequestURL(new InfoDisplayEvent(this, event.getInformation()));
    }

    public void requestMessage(InfoDisplayEvent event) {
        this.fireRequestMessage(new InfoDisplayEvent(this, event.getInformation()));
    }

    public void requestInfoLine(InfoDisplayEvent event) {
        this.fireRequestInfoLine(new InfoDisplayEvent(this, event.getInformation()));
    }

    public void requestBrowserContent(InfoDisplayEvent event) {
        this.fireRequestBrowserContent(new InfoDisplayEvent(this, event.getInformation()));
    }

    public void requestCursor(Cursor cursor) {
        this.fireRequestCursor(cursor);
    }

    public void requestShowToolTip(InfoDisplayEvent event) {
        this.fireRequestToolTip(new InfoDisplayEvent(this, event.getInformation()));
    }

    public void requestHideToolTip() {
        this.fireHideToolTip();
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public synchronized boolean checkMouseMode() {
        this.coolMM = false;
        Layer layer = this.getAppropriateLayer();
        MapMouseListener mml = layer.getMapMouseListener();
        this.setCurrentLayerMapMouseListener(mml);
        if (mml != null) {
            String[] mmsl = mml.getMouseModeServiceList();
            int i = 0;
            while (i < mmsl.length) {
                if (mmsl[i].intern() == this.mmID) {
                    this.coolMM = true;
                    break;
                }
                ++i;
            }
        }
        return this.coolMM;
    }

    public void setCurrentLayerMapMouseListener(MapMouseListener mml) {
        this.clmml = mml;
    }

    public MapMouseListener getCurrentLayerMapMouseListener() {
        return this.clmml;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "NewActiveMouseMode") {
            this.mmID = ((MapMouseMode)evt.getNewValue()).getID().intern();
            this.checkMouseMode();
        }
    }

    public String[] getMouseModeServiceList() {
        HashSet<String> mmsl = new HashSet<String>();
        Iterator it = this.getLayers().iterator();
        while (it.hasNext()) {
            Layer l = (Layer)it.next();
            MapMouseListener mml = l.getMapMouseListener();
            if (mml == null) continue;
            String[] llist = mml.getMouseModeServiceList();
            int i = 0;
            while (i < llist.length) {
                mmsl.add(llist[i].intern());
                ++i;
            }
        }
        Object[] objs = mmsl.toArray();
        String[] rets = new String[objs.length];
        int i = 0;
        while (i < rets.length) {
            rets[i] = (String)objs[i];
            ++i;
        }
        return rets;
    }

    public boolean mousePressed(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mousePressed(e);
        }
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseReleased(e);
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseClicked(e);
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseEntered(e);
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseExited(e);
        }
    }

    public boolean mouseDragged(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseDragged(e);
        }
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        if (this.coolMM) {
            return this.getCurrentLayerMapMouseListener().mouseMoved(e);
        }
        return false;
    }

    public void mouseMoved() {
        if (this.coolMM) {
            this.getCurrentLayerMapMouseListener().mouseMoved();
        }
    }

    public void setBeanContext(BeanContext in_bc) throws PropertyVetoException {
        Iterator it = this.getLayers().iterator();
        while (it.hasNext()) {
            ((Layer)it.next()).connectToBeanContext(in_bc);
        }
        super.setBeanContext(in_bc);
    }

    public void findAndInit(Object obj) {
        if (obj instanceof MouseDelegator) {
            ((MouseDelegator)obj).addPropertyChangeListener(this);
        }
        Iterator it = this.getLayers().iterator();
        while (it.hasNext()) {
            ((Layer)it.next()).findAndInit(obj);
        }
    }

    public void findAndUndo(Object obj) {
        if (obj instanceof MouseDelegator) {
            ((MouseDelegator)obj).removePropertyChangeListener(this);
        }
        Iterator it = this.getLayers().iterator();
        while (it.hasNext()) {
            ((Layer)it.next()).findAndUndo(obj);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

