/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.layer;

import com.bbn.openmap.Environment;
import com.bbn.openmap.I18n;
import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.MoreMath;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphic;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.omGraphics.OMPoly;
import com.bbn.openmap.omGraphics.OMText;
import com.bbn.openmap.proj.Cylindrical;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PaletteHelper;
import com.bbn.openmap.util.PropUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class GraticuleLayer
extends OMGraphicHandlerLayer
implements ActionListener {
    protected I18n i18n = Environment.getI18n();
    protected boolean defaultShowRuler = true;
    protected boolean defaultShowOneAndFiveLines = true;
    protected boolean defaultShowBelowOneLines = false;
    protected int defaultThreshold = 2;
    protected boolean boxy = true;
    protected int threshold = this.defaultThreshold;
    protected OMGraphicList tenDegreeLines = null;
    protected OMGraphicList markerLines = null;
    private static final int SHOW_TENS = 0;
    private static final int SHOW_FIVES = 1;
    private static final int SHOW_ONES = 2;
    protected boolean showOneAndFiveLines = this.defaultShowOneAndFiveLines;
    protected boolean showBelowOneLines = this.defaultShowBelowOneLines;
    protected boolean showRuler = this.defaultShowRuler;
    protected Font font = null;
    protected int fontSize = 10;
    protected Color tenDegreeColor = null;
    protected Color fiveDegreeColor = null;
    protected Color oneDegreeColor = null;
    protected Color belowOneDegreeColor = null;
    protected Color equatorColor = null;
    protected Color dateLineColor = null;
    protected Color specialLineColor = null;
    protected Color textColor = null;
    protected String defaultTenDegreeColorString = "000000";
    protected String defaultFiveDegreeColorString = "33009900";
    protected String defaultOneDegreeColorString = "33003300";
    protected String defaultBelowOneDegreeColorString = "9900ff00";
    protected String defaultEquatorColorString = "990000";
    protected String defaultDateLineColorString = "000099";
    protected String defaultSpecialLineColorString = "000000";
    protected String defaultTextColorString = "000000";
    public static final String TenDegreeColorProperty = "10DegreeColor";
    public static final String FiveDegreeColorProperty = "5DegreeColor";
    public static final String OneDegreeColorProperty = "1DegreeColor";
    public static final String BelowOneDegreeColorProperty = "Below1DegreeColor";
    public static final String EquatorColorProperty = "equatorColor";
    public static final String DateLineColorProperty = "datelineColor";
    public static final String SpecialLineColorProperty = "specialLineColor";
    public static final String TextColorProperty = "textColor";
    public static final String ThresholdProperty = "threshold";
    public static final String ShowRulerProperty = "showRuler";
    public static final String ShowOneAndFiveProperty = "show1And5Lines";
    public static final String ShowBelowOneProperty = "showBelow1Lines";
    public static final String FontSizeProperty = "fontSize";
    protected JCheckBox showRulerButton = null;
    protected JCheckBox show15Button = null;
    protected JCheckBox showBelow1Button = null;
    protected Box palette = null;
    static /* synthetic */ Class class$com$bbn$openmap$layer$GraticuleLayer;

    public GraticuleLayer() {
        this.setName("Graticule");
    }

    public void setProperties(String prefix, Properties properties) {
        super.setProperties(prefix, properties);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.tenDegreeColor = PropUtils.parseColorFromProperties(properties, prefix + TenDegreeColorProperty, this.defaultTenDegreeColorString);
        this.fiveDegreeColor = PropUtils.parseColorFromProperties(properties, prefix + FiveDegreeColorProperty, this.defaultFiveDegreeColorString);
        this.oneDegreeColor = PropUtils.parseColorFromProperties(properties, prefix + OneDegreeColorProperty, this.defaultOneDegreeColorString);
        this.belowOneDegreeColor = PropUtils.parseColorFromProperties(properties, prefix + BelowOneDegreeColorProperty, this.defaultBelowOneDegreeColorString);
        this.equatorColor = PropUtils.parseColorFromProperties(properties, prefix + EquatorColorProperty, this.defaultEquatorColorString);
        this.dateLineColor = PropUtils.parseColorFromProperties(properties, prefix + DateLineColorProperty, this.defaultDateLineColorString);
        this.specialLineColor = PropUtils.parseColorFromProperties(properties, prefix + SpecialLineColorProperty, this.defaultSpecialLineColorString);
        this.textColor = PropUtils.parseColorFromProperties(properties, prefix + TextColorProperty, this.defaultTextColorString);
        this.threshold = PropUtils.intFromProperties(properties, prefix + ThresholdProperty, this.defaultThreshold);
        this.fontSize = PropUtils.intFromProperties(properties, prefix + FontSizeProperty, this.fontSize);
        this.font = new Font("Helvetica", 0, this.fontSize);
        this.setShowOneAndFiveLines(PropUtils.booleanFromProperties(properties, prefix + ShowOneAndFiveProperty, this.defaultShowOneAndFiveLines));
        this.setShowBelowOneLines(PropUtils.booleanFromProperties(properties, prefix + ShowBelowOneProperty, this.defaultShowBelowOneLines));
        this.setShowRuler(PropUtils.booleanFromProperties(properties, prefix + ShowRulerProperty, this.defaultShowRuler));
        this.tenDegreeLines = null;
        this.markerLines = null;
    }

    public void setShowOneAndFiveLines(boolean set) {
        this.showOneAndFiveLines = set;
        if (this.show15Button != null) {
            this.show15Button.setSelected(set);
        }
    }

    public void setShowBelowOneLines(boolean set) {
        this.showBelowOneLines = set;
        if (this.showBelow1Button != null) {
            this.showBelow1Button.setSelected(set);
        }
    }

    public boolean getShowOneAndFiveLines() {
        return this.showOneAndFiveLines;
    }

    public boolean getShowBelowOneLines() {
        return this.showBelowOneLines;
    }

    public void setShowRuler(boolean set) {
        this.showRuler = set;
        if (this.showRulerButton != null) {
            this.showRulerButton.setSelected(set);
        }
    }

    public boolean getShowRuler() {
        return this.showRuler;
    }

    public Properties getProperties(Properties properties) {
        properties = super.getProperties(properties);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        String colorString = this.tenDegreeColor == null ? this.defaultTenDegreeColorString : Integer.toHexString(this.tenDegreeColor.getRGB());
        properties.put(prefix + TenDegreeColorProperty, colorString);
        colorString = this.fiveDegreeColor == null ? this.defaultFiveDegreeColorString : Integer.toHexString(this.fiveDegreeColor.getRGB());
        properties.put(prefix + FiveDegreeColorProperty, colorString);
        colorString = this.oneDegreeColor == null ? this.defaultOneDegreeColorString : Integer.toHexString(this.oneDegreeColor.getRGB());
        properties.put(prefix + OneDegreeColorProperty, colorString);
        colorString = this.belowOneDegreeColor == null ? this.defaultBelowOneDegreeColorString : Integer.toHexString(this.belowOneDegreeColor.getRGB());
        properties.put(prefix + BelowOneDegreeColorProperty, colorString);
        colorString = this.equatorColor == null ? this.defaultEquatorColorString : Integer.toHexString(this.equatorColor.getRGB());
        properties.put(prefix + EquatorColorProperty, colorString);
        colorString = this.dateLineColor == null ? this.defaultDateLineColorString : Integer.toHexString(this.dateLineColor.getRGB());
        properties.put(prefix + DateLineColorProperty, colorString);
        colorString = this.specialLineColor == null ? this.defaultSpecialLineColorString : Integer.toHexString(this.specialLineColor.getRGB());
        properties.put(prefix + SpecialLineColorProperty, colorString);
        colorString = this.textColor == null ? this.defaultTextColorString : Integer.toHexString(this.textColor.getRGB());
        properties.put(prefix + TextColorProperty, colorString);
        properties.put(prefix + ThresholdProperty, Integer.toString(this.threshold));
        properties.put(prefix + FontSizeProperty, Integer.toString(this.fontSize));
        properties.put(prefix + ShowOneAndFiveProperty, new Boolean(this.showOneAndFiveLines).toString());
        properties.put(prefix + ShowBelowOneProperty, new Boolean(this.showBelowOneLines).toString());
        properties.put(prefix + ShowRulerProperty, new Boolean(this.showRuler).toString());
        return properties;
    }

    public Properties getPropertyInfo(Properties properties) {
        properties = super.getPropertyInfo(properties);
        properties.put("initProperties", "10DegreeColor 5DegreeColor 1DegreeColor equatorColor datelineColor specialLineColor show1And5Lines showRuler threshold fontSize");
        String interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, TenDegreeColorProperty, 3, "Color of the ten degree graticule lines.");
        properties.put(TenDegreeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, TenDegreeColorProperty, "Ten Degree Color");
        properties.put("10DegreeColor.label", interString);
        properties.put("10DegreeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, FiveDegreeColorProperty, 3, "Color of the five degree graticule lines.");
        properties.put(FiveDegreeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, FiveDegreeColorProperty, "Color of the five degree graticule lines.");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, FiveDegreeColorProperty, "File Degree Color");
        properties.put("5DegreeColor.label", interString);
        properties.put("5DegreeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, OneDegreeColorProperty, 3, "Color of the one degree graticule lines.");
        properties.put(OneDegreeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, OneDegreeColorProperty, "1 Degree Color");
        properties.put("1DegreeColor.label", interString);
        properties.put("1DegreeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, BelowOneDegreeColorProperty, 3, "Color of the sub-one degree graticule lines.");
        properties.put(BelowOneDegreeColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, BelowOneDegreeColorProperty, "Sub-One Degree Color");
        properties.put("Below1DegreeColor.label", interString);
        properties.put("Below1DegreeColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, EquatorColorProperty, 3, "Color of the Equator.");
        properties.put(EquatorColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, EquatorColorProperty, "Equator Line Color");
        properties.put("equatorColor.label", interString);
        properties.put("equatorColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, DateLineColorProperty, 3, "Color of the Date line.");
        properties.put(DateLineColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, DateLineColorProperty, "Date Line Color");
        properties.put("datelineColor.label", interString);
        properties.put("datelineColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, SpecialLineColorProperty, 3, "Color of Tropic of Cancer, Capricorn lines.");
        properties.put(SpecialLineColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, SpecialLineColorProperty, "Special Line Color");
        properties.put("specialLineColor.label", interString);
        properties.put("specialLineColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, TextColorProperty, 3, "Color of the line label text.");
        properties.put(TextColorProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, TextColorProperty, "Text Color");
        properties.put("textColor.label", interString);
        properties.put("textColor.editor", "com.bbn.openmap.util.propertyEditor.ColorPropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ThresholdProperty, 3, "The number of lines showing before finer grain lines appear.");
        properties.put(ThresholdProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ThresholdProperty, "Line Threshold");
        properties.put("threshold.label", interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowOneAndFiveProperty, 3, "Show the one and five degree lines.");
        properties.put(ShowOneAndFiveProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowOneAndFiveProperty, "Show 1 and 5 Lines");
        properties.put("show1And5Lines.label", interString);
        properties.put("show1And5Lines.editor", "com.bbn.openmap.util.propertyEditor.TrueFalsePropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowBelowOneProperty, 3, "Show the one and five degree lines.");
        properties.put(ShowBelowOneProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowBelowOneProperty, "Show Sub-1 Lines");
        properties.put("showBelow1Lines.label", interString);
        properties.put("showBelow1Lines.editor", "com.bbn.openmap.util.propertyEditor.TrueFalsePropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowRulerProperty, 3, "Show the line label text.");
        properties.put(ShowRulerProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, ShowRulerProperty, "Show Labels");
        properties.put("showRuler.label", interString);
        properties.put("showRuler.editor", "com.bbn.openmap.util.propertyEditor.TrueFalsePropertyEditor");
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, FontSizeProperty, 3, "The size of the font, in points, of the line labels.");
        properties.put(FontSizeProperty, interString);
        interString = this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, FontSizeProperty, "Label Font Size");
        properties.put("fontSize.label", interString);
        return properties;
    }

    public synchronized void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            Debug.error("GraticuleLayer.renderDataForProjection: null projection!");
            return;
        }
        if (!proj.equals(this.getProjection())) {
            this.setProjection(proj.makeClone());
            this.boxy = proj instanceof Cylindrical;
            this.setList(this.constructGraticuleLines());
        }
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        Projection proj = this.setProjection(e);
        if (proj == null) {
            this.repaint();
            return;
        }
        this.boxy = proj instanceof Cylindrical;
        this.setList(null);
        this.doPrepare();
    }

    public synchronized OMGraphicList prepare() {
        return this.constructGraticuleLines();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OMGraphicList constructGraticuleLines() {
        OMGraphicList newgraphics = new OMGraphicList(20);
        Projection projection = this.getProjection();
        if (projection == null) {
            return newgraphics;
        }
        this.tenDegreeLines = null;
        if (this.showOneAndFiveLines || this.showRuler || this.showBelowOneLines) {
            float left = projection.getUpperLeft().getLongitude();
            float right = projection.getLowerRight().getLongitude();
            float up = projection.getUpperLeft().getLatitude();
            float down = projection.getLowerRight().getLatitude();
            if (up > 80.0f) {
                up = 80.0f;
            }
            if (down > 80.0f) {
                down = 80.0f;
            }
            if (up < -80.0f) {
                up = -80.0f;
            }
            if (down < -80.0f) {
                down = -80.0f;
            }
            int showWhichLines = this.evaluateSpacing(up, down, left, right);
            if (left > 0.0f && right < 0.0f || left > right || Math.abs(left - right) < 1.0f) {
                if (showWhichLines != 0) {
                    newgraphics.add(this.constructGraticuleLines(up, down, left, 180.0f, showWhichLines));
                    newgraphics.add(this.constructGraticuleLines(up, down, -180.0f, right, showWhichLines));
                } else if (this.showRuler) {
                    newgraphics.add(this.constructTensLabels(up, down, left, 180.0f, true));
                    newgraphics.add(this.constructTensLabels(up, down, -180.0f, right, false));
                }
            } else if (showWhichLines != 0) {
                newgraphics = this.constructGraticuleLines(up, down, left, right, showWhichLines);
            } else if (this.showRuler) {
                newgraphics.add(this.constructTensLabels(up, down, left, right, true));
            }
        }
        if (this.tenDegreeLines == null) {
            OMGraphicList list;
            this.tenDegreeLines = list = this.constructTenDegreeLines();
        } else {
            OMGraphicList oMGraphicList = this.tenDegreeLines;
            synchronized (oMGraphicList) {
                this.setLineTypeAndProject(this.tenDegreeLines, this.boxy ? 1 : 2);
            }
        }
        if (this.markerLines == null) {
            OMGraphicList list;
            this.markerLines = list = this.constructMarkerLines();
        } else {
            OMGraphicList oMGraphicList = this.markerLines;
            synchronized (oMGraphicList) {
                this.setLineTypeAndProject(this.markerLines, this.boxy ? 1 : 2);
            }
        }
        newgraphics.add(this.markerLines);
        newgraphics.add(this.tenDegreeLines);
        if (Debug.debugging("graticule")) {
            Debug.output("GraticuleLayer.constructGraticuleLines(): constructed " + newgraphics.size() + " graticule lines");
        }
        return newgraphics;
    }

    protected int evaluateSpacing(float up, float down, float left, float right) {
        float diff;
        int ret = 0;
        if (!this.showOneAndFiveLines && !this.showBelowOneLines) {
            return ret;
        }
        float nsdiff = up - down;
        float ewdiff = left > 0.0f && right < 0.0f || left > right || Math.abs(left - right) < 1.0f ? 180.0f - left + (right + 180.0f) : right - left;
        float f = diff = nsdiff < ewdiff ? nsdiff : ewdiff;
        if (diff / 10.0f <= (float)this.threshold) {
            ret = 1;
        }
        if (diff / 5.0f <= (float)this.threshold) {
            ret = 2;
        }
        return ret;
    }

    protected OMGraphicList constructGraticuleLines(float up, float down, float left, float right, int showWhichLines) {
        OMText currentText;
        LatLonPoint llpoint;
        Point point;
        OMPoly currentLine;
        float[] llp;
        int east;
        OMGraphicList lines = new OMGraphicList();
        int north = (int)Math.ceil(up);
        if (north > 80) {
            north = 80;
        }
        int south = (int)Math.floor(down);
        if ((south -= south % 10) < 0 && south > -80 || south == 0) {
            south -= 10;
        }
        int west = (int)Math.floor(left);
        if ((west -= west % 10) < 0 && west > -180 || west == 0) {
            west -= 10;
        }
        if ((east = (int)Math.ceil(right)) > 180) {
            east = 180;
        }
        int stepSize = showWhichLines == 2 ? 1 : 5;
        Projection projection = this.getProjection();
        int i = south;
        while (i < north) {
            float lat = i;
            if (west < 0 && east > 0) {
                llp = new float[6];
                llp[2] = lat;
                llp[3] = 0.0f;
                llp[4] = lat;
                llp[5] = east;
            } else {
                llp = new float[4];
                llp[2] = lat;
                llp[3] = east;
            }
            llp[0] = lat;
            llp[1] = west;
            if (lat % 10.0f != 0.0f) {
                currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 2);
                if (lat % 5.0f == 0.0f) {
                    currentLine.setLinePaint(this.fiveDegreeColor);
                } else {
                    currentLine.setLinePaint(this.oneDegreeColor);
                }
                lines.addOMGraphic(currentLine);
            }
            if (this.showRuler && lat % 2.0f == 0.0f) {
                if (this.boxy) {
                    point = projection.forward(lat, west);
                    point.x = 0;
                    llpoint = projection.inverse(point);
                } else {
                    llpoint = new LatLonPoint(lat, west);
                    while (projection.forward((LatLonPoint)llpoint).x < 0) {
                        llpoint.setLongitude(llpoint.getLongitude() + (float)stepSize);
                    }
                }
                currentText = new OMText(llpoint.getLatitude(), llpoint.getLongitude(), 2, -2, Integer.toString((int)lat), this.font, 0);
                currentText.setLinePaint(this.textColor);
                lines.addOMGraphic(currentText);
            }
            i += stepSize;
        }
        int i2 = west;
        while (i2 < east) {
            float lon = i2;
            if (north < 0 && south > 0) {
                llp = new float[6];
                llp[2] = 0.0f;
                llp[3] = lon;
                llp[4] = south;
                llp[5] = lon;
            } else {
                llp = new float[4];
                llp[2] = south;
                llp[3] = lon;
            }
            llp[0] = north;
            llp[1] = lon;
            if (lon % 10.0f != 0.0f) {
                currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 3);
                if (lon % 5.0f == 0.0f) {
                    currentLine.setLinePaint(this.fiveDegreeColor);
                } else {
                    currentLine.setLinePaint(this.oneDegreeColor);
                }
                lines.addOMGraphic(currentLine);
            }
            if (this.showRuler && lon % 2.0f == 0.0f) {
                if (this.boxy) {
                    point = projection.forward(south, lon);
                    point.y = projection.getHeight();
                    llpoint = projection.inverse(point);
                } else {
                    llpoint = new LatLonPoint(south, lon);
                    while (projection.forward((LatLonPoint)llpoint).y > projection.getHeight()) {
                        llpoint.setLatitude(llpoint.getLatitude() + (float)stepSize);
                    }
                }
                currentText = new OMText(llpoint.getLatitude(), llpoint.getLongitude(), 2, -5, Integer.toString((int)lon), this.font, 1);
                currentText.setLinePaint(this.textColor);
                lines.addOMGraphic(currentText);
            }
            i2 += stepSize;
        }
        if (Debug.debugging("graticule")) {
            Debug.output("GraticuleLayer.constructTenDegreeLines(): constructed " + lines.size() + " graticule lines");
        }
        lines.generate(projection);
        return lines;
    }

    protected OMGraphicList constructTenDegreeLines() {
        OMPoly currentLine;
        OMGraphicList lines = new OMGraphicList(3);
        int i = 1;
        while (i <= 8) {
            int j = -1;
            while (j < 2) {
                float lat = 10 * i * j;
                float[] llp = new float[]{lat, -180.0f, lat, -90.0f, lat, 0.0f, lat, 90.0f, lat, 180.0f};
                currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 2);
                currentLine.setLinePaint(this.tenDegreeColor);
                lines.addOMGraphic(currentLine);
                j += 2;
            }
            ++i;
        }
        int i2 = 1;
        while (i2 < 18) {
            int j = -1;
            while (j < 2) {
                float lon = 10 * i2 * j;
                float[] llp = new float[]{80.0f, lon, 0.0f, lon, -80.0f, lon};
                if (MoreMath.approximately_equal(Math.abs(lon), 90.0f, 0.001f)) {
                    llp[0] = 90.0f;
                    llp[4] = -90.0f;
                }
                currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 3);
                currentLine.setLinePaint(this.tenDegreeColor);
                lines.addOMGraphic(currentLine);
                j += 2;
            }
            ++i2;
        }
        if (Debug.debugging("graticule")) {
            Debug.output("GraticuleLayer.constructTenDegreeLines(): constructed " + lines.size() + " graticule lines");
        }
        lines.generate(this.getProjection());
        return lines;
    }

    protected OMGraphicList constructTensLabels(float up, float down, float left, float right, boolean doLats) {
        OMText currentText;
        LatLonPoint llpoint;
        Point point;
        int i;
        int east;
        OMGraphicList labels = new OMGraphicList();
        int north = (int)Math.ceil(up);
        if (north > 80) {
            north = 80;
        }
        int south = (int)Math.floor(down);
        if ((south -= south % 10) < 0 && south > -70 || south == 0) {
            south -= 10;
        }
        int west = (int)Math.floor(left);
        if ((west -= west % 10) < 0 && west > -170 || west == 0) {
            west -= 10;
        }
        if ((east = (int)Math.ceil(right)) > 180) {
            east = 180;
        }
        int stepSize = 10;
        Projection projection = this.getProjection();
        if (doLats) {
            i = south;
            while (i < north) {
                float lat = i;
                if (lat % 2.0f == 0.0f) {
                    if (this.boxy) {
                        point = projection.forward(lat, west);
                        point.x = 0;
                        llpoint = projection.inverse(point);
                    } else {
                        llpoint = new LatLonPoint(lat, west);
                        while (projection.forward((LatLonPoint)llpoint).x < 0) {
                            llpoint.setLongitude(llpoint.getLongitude() + (float)stepSize);
                        }
                    }
                    currentText = new OMText(llpoint.getLatitude(), llpoint.getLongitude(), 2, -2, Integer.toString((int)lat), this.font, 0);
                    currentText.setLinePaint(this.textColor);
                    labels.addOMGraphic(currentText);
                }
                i += stepSize;
            }
        }
        i = west;
        while (i < east) {
            float lon = i;
            if (lon % 2.0f == 0.0f) {
                if (this.boxy) {
                    point = projection.forward(south, lon);
                    point.y = projection.getHeight();
                    llpoint = projection.inverse(point);
                } else {
                    llpoint = new LatLonPoint(south, lon);
                    while (projection.forward((LatLonPoint)llpoint).y > projection.getHeight()) {
                        llpoint.setLatitude(llpoint.getLatitude() + (float)stepSize);
                    }
                }
                currentText = new OMText(llpoint.getLatitude(), llpoint.getLongitude(), 2, -5, Integer.toString((int)lon), this.font, 1);
                currentText.setLinePaint(this.textColor);
                labels.addOMGraphic(currentText);
            }
            i += stepSize;
        }
        if (Debug.debugging("graticule")) {
            Debug.output("GraticuleLayer.constructTensLabels(): constructed " + labels.size() + " graticule labels");
        }
        labels.generate(projection);
        return labels;
    }

    protected OMGraphicList constructMarkerLines() {
        OMPoly currentLine;
        OMGraphicList lines = new OMGraphicList(3);
        int j = 0;
        while (j < 360) {
            float lon = j;
            float[] llp = new float[]{90.0f, lon, 0.0f, lon, -90.0f, lon};
            currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 3);
            currentLine.setLinePaint(this.dateLineColor);
            lines.addOMGraphic(currentLine);
            j += 180;
        }
        float[] llp = new float[]{0.0f, -180.0f, 0.0f, -90.0f, 0.0f, 0.0f, 0.0f, 90.0f, 0.0f, 180.0f};
        currentLine = new OMPoly(llp, 0, this.boxy ? 1 : 3);
        currentLine.setLinePaint(this.equatorColor);
        lines.addOMGraphic(currentLine);
        if (Debug.debugging("graticule")) {
            Debug.output("GraticuleLayer.constructMarkerLines(): constructed " + lines.size() + " graticule lines");
        }
        lines.generate(this.getProjection());
        return lines;
    }

    protected void setLineTypeAndProject(OMGraphicList list, int lineType) {
        int size = list.size();
        int i = 0;
        while (i < size) {
            OMGraphic graphic = list.getOMGraphicAt(i);
            graphic.setLineType(lineType);
            graphic.generate(this.getProjection());
            ++i;
        }
    }

    public Component getGUI() {
        if (this.palette == null) {
            if (Debug.debugging("graticule")) {
                Debug.output("GraticuleLayer: creating Graticule Palette.");
            }
            this.palette = Box.createVerticalBox();
            JPanel layerPanel = PaletteHelper.createPaletteJPanel(this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, "layerPanel", "Graticule Layer Options"));
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String ac = e.getActionCommand();
                    if (ac.equalsIgnoreCase(GraticuleLayer.ShowRulerProperty)) {
                        JCheckBox jcb = (JCheckBox)e.getSource();
                        GraticuleLayer.this.showRuler = jcb.isSelected();
                    } else if (ac.equalsIgnoreCase(GraticuleLayer.ShowOneAndFiveProperty)) {
                        JCheckBox jcb = (JCheckBox)e.getSource();
                        GraticuleLayer.this.showOneAndFiveLines = jcb.isSelected();
                    } else {
                        Debug.error("Unknown action command \"" + ac + "\" in GraticuleLayer.actionPerformed().");
                    }
                }
            };
            this.showRulerButton = new JCheckBox(this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, "showRulerButton", "Show Lat/Lon Labels"), this.showRuler);
            this.showRulerButton.addActionListener(al);
            this.showRulerButton.setActionCommand(ShowRulerProperty);
            this.show15Button = new JCheckBox(this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, "show15Button", "Show 1, 5 Degree Lines"), this.showOneAndFiveLines);
            this.show15Button.addActionListener(al);
            this.show15Button.setActionCommand(ShowOneAndFiveProperty);
            layerPanel.add(this.showRulerButton);
            layerPanel.add(this.show15Button);
            this.palette.add(layerPanel);
            JPanel subbox3 = new JPanel(new GridLayout(0, 1));
            JButton setProperties = new JButton(this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, "setProperties", "Preferences"));
            setProperties.setActionCommand("displayPropertiesCmd");
            setProperties.addActionListener(this);
            subbox3.add(setProperties);
            JButton redraw = new JButton(this.i18n.get(class$com$bbn$openmap$layer$GraticuleLayer == null ? (class$com$bbn$openmap$layer$GraticuleLayer = GraticuleLayer.class$("com.bbn.openmap.layer.GraticuleLayer")) : class$com$bbn$openmap$layer$GraticuleLayer, "redraw", "Redraw Graticule Layer"));
            redraw.setActionCommand("redrawCmd");
            redraw.addActionListener(this);
            subbox3.add(redraw);
            this.palette.add(subbox3);
        }
        return this.palette;
    }

    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        String command = e.getActionCommand();
        if (command == "redrawCmd" && this.isVisible()) {
            this.doPrepare();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

