/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.LatLonPoint;
import com.bbn.openmap.Layer;
import com.bbn.openmap.LayerHandler;
import com.bbn.openmap.MapBean;
import com.bbn.openmap.gui.menu.SaveAsImageMenuItem;
import com.bbn.openmap.image.AbstractImageFormatter;
import com.bbn.openmap.proj.Proj;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.ProjectionFactory;
import com.bbn.openmap.util.Debug;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SaveAsVirtualImageMenuItem
extends SaveAsImageMenuItem {
    protected Iterator it = null;
    protected Object someObj = null;
    protected Layer[] visibleLayers = null;
    protected String filename;
    protected DimensionQueryWindow DW = null;

    public SaveAsVirtualImageMenuItem(String display, AbstractImageFormatter in_formatter) {
        super(display, in_formatter);
    }

    public void actionPerformed(ActionEvent ae) {
        if (this.mapHandler == null) {
            return;
        }
        this.it = this.mapHandler.iterator();
        while (this.it.hasNext()) {
            this.someObj = this.it.next();
            if (!(this.someObj instanceof LayerHandler)) continue;
            this.visibleLayers = ((LayerHandler)this.someObj).getMapLayers();
        }
        this.it = this.mapHandler.iterator();
        while (this.it.hasNext()) {
            this.someObj = this.it.next();
            if (!(this.someObj instanceof MapBean)) continue;
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(this.getParent());
            if (returnVal == 0) {
                this.filename = chooser.getSelectedFile().getAbsolutePath();
                Projection tp0 = ((MapBean)this.someObj).getProjection();
                this.DW = new DimensionQueryWindow(tp0.getWidth(), tp0.getHeight());
                this.DW.layoutWindow();
            }
            return;
        }
    }

    public class ButtonHandler
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            if (ae.getActionCommand().equals("OK")) {
                try {
                    if (SaveAsVirtualImageMenuItem.this.formatter == null) {
                        return;
                    }
                    Proj tp = null;
                    Proj tp0 = null;
                    MapBean mb = (MapBean)SaveAsVirtualImageMenuItem.this.someObj;
                    LatLonPoint cp = new LatLonPoint(mb.getCenter());
                    int height = SaveAsVirtualImageMenuItem.this.DW.getHeight();
                    int width = SaveAsVirtualImageMenuItem.this.DW.getWidth();
                    tp0 = (Proj)mb.getProjection();
                    double area1 = (double)tp0.getHeight() * (double)tp0.getWidth();
                    double area2 = (double)height * (double)width;
                    double scaleMod = Math.sqrt(area1 / area2);
                    System.out.println("scaleMod = " + scaleMod);
                    BufferedImage bi = new BufferedImage(width, height, 1);
                    tp = (Proj)ProjectionFactory.makeProjection(mb.getProjection().getClass(), cp.getLatitude(), cp.getLongitude(), mb.getScale() * (float)scaleMod, width, height);
                    tp.drawBackground(bi.createGraphics(), mb.getBackground());
                    int i = SaveAsVirtualImageMenuItem.this.visibleLayers.length - 1;
                    while (i > -1) {
                        SaveAsVirtualImageMenuItem.this.visibleLayers[i].renderDataForProjection(tp, bi.createGraphics());
                        --i;
                    }
                    byte[] imageBytes = SaveAsVirtualImageMenuItem.this.formatter.formatImage(bi);
                    FileOutputStream binFile = new FileOutputStream(SaveAsVirtualImageMenuItem.this.filename);
                    binFile.write(imageBytes);
                    binFile.close();
                    SaveAsVirtualImageMenuItem.this.DW.closeWindow();
                }
                catch (IOException e) {
                    Debug.error("SaveAsVirtualImageMenuItem: " + e);
                }
            } else if (ae.getActionCommand().equals("CANCEL")) {
                SaveAsVirtualImageMenuItem.this.DW.closeWindow();
            }
        }
    }

    public class DimensionQueryWindow {
        private JFrame f = new JFrame("Output Image Size");
        private JTextField hfield;
        private JTextField vfield;
        private JLabel htext = new JLabel("Height");
        private JLabel vtext = new JLabel("Width");
        private JLabel ptext1;
        private JLabel ptext2;
        private JButton ok;
        private JButton cancel;

        public DimensionQueryWindow(int width, int height) {
            this.hfield = new JTextField(Integer.toString(width), 5);
            this.vfield = new JTextField(Integer.toString(height), 5);
            this.ptext1 = new JLabel("pixels");
            this.ptext2 = new JLabel("pixels");
            this.ok = new JButton("OK");
            this.cancel = new JButton("Cancel");
        }

        public int getWidth() {
            return Integer.parseInt(this.hfield.getText());
        }

        public int getHeight() {
            return Integer.parseInt(this.vfield.getText());
        }

        public void closeWindow() {
            this.f.dispose();
        }

        public void layoutWindow() {
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            this.f.getContentPane().setLayout(gb);
            this.f.setDefaultCloseOperation(2);
            c.fill = 2;
            c.gridx = 0;
            c.gridy = 0;
            gb.setConstraints(this.htext, c);
            this.f.getContentPane().add(this.htext);
            c.gridx = 1;
            c.gridy = 0;
            gb.setConstraints(this.hfield, c);
            this.f.getContentPane().add(this.hfield);
            c.gridx = 2;
            c.gridy = 0;
            gb.setConstraints(this.ptext1, c);
            this.f.getContentPane().add(this.ptext1);
            c.gridx = 0;
            c.gridy = 1;
            gb.setConstraints(this.vtext, c);
            this.f.getContentPane().add(this.vtext);
            c.gridx = 1;
            c.gridy = 1;
            gb.setConstraints(this.vfield, c);
            this.f.getContentPane().add(this.vfield);
            c.gridx = 2;
            c.gridy = 1;
            gb.setConstraints(this.ptext2, c);
            this.f.getContentPane().add(this.ptext2);
            c.gridx = 0;
            c.gridy = 2;
            gb.setConstraints(this.ok, c);
            this.f.getContentPane().add(this.ok);
            this.ok.setActionCommand("OK");
            this.ok.addActionListener(new ButtonHandler());
            c.gridx = 2;
            c.gridy = 2;
            gb.setConstraints(this.cancel, c);
            this.f.getContentPane().add(this.cancel);
            this.cancel.setActionCommand("CANCEL");
            this.cancel.addActionListener(new ButtonHandler());
            this.f.pack();
            this.f.setVisible(true);
        }
    }
}

