/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.gui.menu;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.PropertyConsumer;
import com.bbn.openmap.gui.MenuBar;
import com.bbn.openmap.util.ComponentFactory;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.beans.PropertyVetoException;
import java.beans.beancontext.BeanContext;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public class MenuList
extends OMComponent {
    public static final String MenusProperty = "menus";
    protected LinkedList menus = new LinkedList();
    protected MenuBar menuBar;
    protected JMenu menu;

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = new MenuBar();
        }
        this.menuBar.removeAll();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            this.menuBar.findAndInit(iterator.next());
        }
        return this.menuBar;
    }

    public JMenu getMenu() {
        if (this.menu == null) {
            this.menu = new JMenu("OpenMap");
        }
        this.menu.removeAll();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            this.menu.add((JMenu)iterator.next());
        }
        return this.menu;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        String realPrefix = PropUtils.getScopedPropertyPrefix(prefix);
        Vector menuItems = PropUtils.parseSpacedMarkers(props.getProperty(realPrefix + MenusProperty));
        if (!menuItems.isEmpty()) {
            int nMenuItems = menuItems.size();
            if (Debug.debugging("menu")) {
                Debug.output("MenuList created with " + nMenuItems + " menus" + (nMenuItems == 1 ? "" : "s") + " in properties");
            }
            int i = 0;
            while (i < nMenuItems) {
                String itemPrefix = (String)menuItems.elementAt(i);
                String classProperty = itemPrefix + ".class";
                String className = props.getProperty(classProperty);
                if (className == null) {
                    Debug.error("MenuList.setProperties(): Failed to locate property \"" + classProperty + "\"\n  Skipping menu \"" + itemPrefix + "\"");
                } else {
                    Object obj = ComponentFactory.create(className, itemPrefix, props);
                    if (obj instanceof JMenu) {
                        this.menus.add(obj);
                    }
                }
                ++i;
            }
        } else if (Debug.debugging("menu")) {
            Debug.output("MenuList created without menus in properties");
        }
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        StringBuffer itemList = new StringBuffer();
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            JMenu menu = (JMenu)iterator.next();
            if (!(menu instanceof PropertyConsumer)) continue;
            PropertyConsumer ps = (PropertyConsumer)((Object)menu);
            String prefix = ps.getPropertyPrefix();
            if (prefix == null) {
                prefix = menu.getText().toLowerCase();
                ps.setPropertyPrefix(prefix);
            }
            itemList.append(prefix + " ");
            ps.getProperties(props);
        }
        props.put(PropUtils.getScopedPropertyPrefix(this) + MenusProperty, itemList.toString());
        return props;
    }

    public Properties getPropertyInfo(Properties props) {
        props = super.getPropertyInfo(props);
        props.put(MenusProperty, "List of marker names for menu component properties.");
        return props;
    }

    public void setBeanContext(BeanContext bc) throws PropertyVetoException {
        super.setBeanContext(bc);
        Iterator it = this.menus.iterator();
        while (bc != null && it.hasNext()) {
            bc.add(it.next());
        }
    }
}

