/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.graphicLoader;

import com.bbn.openmap.OMComponent;
import com.bbn.openmap.graphicLoader.GraphicLoader;
import com.bbn.openmap.omGraphics.OMGraphicHandler;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.util.PropUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.Timer;

public abstract class AbstractGraphicLoader
extends OMComponent
implements GraphicLoader,
ActionListener {
    protected Timer timer;
    protected int DO_NOT_UPDATE_TIMER = -1;
    protected OMGraphicHandler receiver = null;
    protected Projection proj;
    protected String name = "";
    public static final String TimerCmd = "TimerCommand";
    public static final String NameProperty = "prettyName";
    protected int updateInterval = 3000;

    public AbstractGraphicLoader() {
        this.createTimer();
    }

    public AbstractGraphicLoader(OMGraphicHandler receiver) {
        this.setReceiver(receiver);
        this.manageGraphics();
    }

    public abstract void manageGraphics();

    public Component getGUI() {
        return null;
    }

    public void setProjection(Projection p) {
        if (!p.equals(this.getProjection())) {
            this.proj = p;
            this.manageGraphics();
        }
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void setReceiver(OMGraphicHandler r) {
        this.receiver = r;
    }

    public OMGraphicHandler getReceiver() {
        return this.receiver;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public void setTimer(Timer t) {
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this);
        }
        this.timer = t;
        if (this.timer != null) {
            this.timer.addActionListener(this);
        }
    }

    public void createTimer() {
        Timer t = new Timer(this.updateInterval, this);
        t.setInitialDelay(0);
        this.setTimer(t);
    }

    public void setUpdateInterval(int delay) {
        this.updateInterval = delay;
        if (this.timer != null) {
            this.timer.setDelay(this.updateInterval);
            if (this.timer.isRunning()) {
                this.timer.restart();
            }
        }
    }

    public int getUpdateInterval() {
        return this.updateInterval;
    }

    public void actionPerformed(ActionEvent ae) {
        this.manageGraphics();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProperties(String prefix, Properties props) {
        super.setProperties(prefix, props);
        prefix = PropUtils.getScopedPropertyPrefix(prefix);
        this.name = props.getProperty(prefix + NameProperty, this.name);
    }

    public Properties getProperties(Properties props) {
        props = super.getProperties(props);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        props.put(prefix + NameProperty, this.getName());
        return props;
    }

    public Properties getPropertyInfo(Properties list) {
        list = super.getPropertyInfo(list);
        String prefix = PropUtils.getScopedPropertyPrefix(this);
        list.put(NameProperty, "A short name description for what this GraphicLoader does.");
        return list;
    }
}

