/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.geo;

import com.bbn.openmap.geo.Geo;

public class Intersection {
    public static float[] getIntersection(float lat1, float lon1, float lat2, float lon2, float lat3, float lon3, float lat4, float lon4) {
        Geo geo1 = new Geo(lat1, lon1);
        Geo geo2 = new Geo(lat2, lon2);
        Geo geoCross1 = geo1.crossNormalize(geo2);
        Geo geo3 = new Geo(lat3, lon3);
        Geo geo4 = new Geo(lat4, lon4);
        Geo geoCross2 = geo3.crossNormalize(geo4);
        Geo geo = geoCross1.crossNormalize(geoCross2);
        float lat = (float)geo.getLatitude();
        float lon = (float)geo.getLongitude();
        float[] latlon = new float[]{lat, lon, -lat, lon + 180.0f};
        return latlon;
    }

    public static float[] getSegIntersection(float lat1, float lon1, float lat2, float lon2, float lat3, float lon3, float lat4, float lon4) {
        float[] ll = Intersection.getIntersection(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4);
        double d1 = Geo.distance(lat1, lon1, lat2, lon2);
        double d2 = Geo.distance(lat3, lon3, lat4, lon4);
        double d111 = Geo.distance(lat1, lon1, ll[0], ll[1]);
        double d121 = Geo.distance(lat2, lon2, ll[0], ll[1]);
        double d112 = Geo.distance(lat1, lon1, ll[2], ll[3]);
        double d122 = Geo.distance(lat2, lon2, ll[2], ll[3]);
        double d211 = Geo.distance(lat3, lon3, ll[0], ll[1]);
        double d221 = Geo.distance(lat4, lon4, ll[0], ll[1]);
        double d212 = Geo.distance(lat3, lon3, ll[2], ll[3]);
        double d222 = Geo.distance(lat4, lon4, ll[2], ll[3]);
        float[] llp = new float[]{Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE};
        if (d1 >= d111 && d1 >= d121 && d2 >= d211 && d2 >= d221) {
            llp[0] = ll[0];
            llp[1] = ll[1];
        }
        if (d1 >= d112 && d1 >= d122 && d2 >= d212 && d2 >= d222) {
            llp[2] = ll[2];
            llp[3] = ll[3];
        }
        return llp;
    }

    public static boolean intersects(float lat1, float lon1, float lat2, float lon2, float lat3, float lon3, float lat4, float lon4) {
        float[] llp = Intersection.getSegIntersection(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4);
        return llp[0] != Float.MAX_VALUE && llp[1] != Float.MAX_VALUE || llp[2] != Float.MAX_VALUE && llp[3] != Float.MAX_VALUE;
    }

    public static boolean polyIntersect(float[] polyPoints1, float[] polyPoints2) {
        int i = 0;
        while (i < polyPoints1.length / 2 - 1) {
            int j = 0;
            while (j < polyPoints2.length / 2 - 1) {
                if (Intersection.intersects(polyPoints1[2 * i], polyPoints1[2 * i + 1], polyPoints1[2 * i + 2], polyPoints1[2 * i + 3], polyPoints2[2 * j], polyPoints2[2 * j + 1], polyPoints2[2 * j + 2], polyPoints2[2 * j + 3])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static boolean isSelfIntersectingPoly(float[] polyPoints) {
        int i = 0;
        while (i < polyPoints.length / 2 - 1) {
            int j = i + 1;
            while (j < polyPoints.length / 2 - 1) {
                float lat1 = polyPoints[2 * i];
                float lon1 = polyPoints[2 * i + 1];
                float lat2 = polyPoints[2 * i + 2];
                float lon2 = polyPoints[2 * i + 3];
                float lat3 = polyPoints[2 * j];
                float lon3 = polyPoints[2 * j + 1];
                float lat4 = polyPoints[2 * j + 2];
                float lon4 = polyPoints[2 * j + 3];
                if (!(lat1 == lat4 && lon1 == lon4 || lat2 == lat3 && lon2 == lon3 || !Intersection.intersects(lat1, lon1, lat2, lon2, lat3, lon3, lat4, lon4))) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public static float pointCircleDistance(float lat1, float lon1, float lat2, float lon2, float lat, float lon) {
        Geo n = Geo.crossNormalize(new Geo(lat1, lon1), new Geo(lat2, lon2));
        Geo c = new Geo(lat, lon);
        c = c.normalize();
        double cosTheta = Geo.dot(n, c);
        double theta = Math.acos(cosTheta);
        return (float)Math.abs(1.5707963267948966 - theta);
    }

    public static boolean intersectsCircle(float lat1, float lon1, float lat2, float lon2, float lat, float lon, float radius) {
        double d1 = Geo.distance(lat1, lon1, lat, lon);
        if (d1 < (double)radius) {
            return true;
        }
        double d2 = Geo.distance(lat2, lon2, lat, lon);
        if (d2 < (double)radius) {
            return true;
        }
        float dist = Intersection.pointCircleDistance(lat1, lon1, lat2, lon2, lat, lon);
        if (dist > radius) {
            return false;
        }
        Geo a = new Geo(lat1, lon1);
        Geo b = new Geo(lat2, lon2);
        Geo c = new Geo(lat, lon);
        Geo g = a.cross(b);
        Geo f = c.cross(g);
        Geo i = f.crossNormalize(g);
        Geo i2 = i.antipode();
        double d = Geo.distance(lat1, lon1, lat2, lon2);
        double d11 = Geo.distance(lat1, lon1, i.getLatitude(), i.getLongitude());
        double d12 = Geo.distance(lat2, lon2, i.getLatitude(), i.getLongitude());
        double d21 = Geo.distance(lat1, lon1, i2.getLatitude(), i2.getLongitude());
        double d22 = Geo.distance(lat2, lon2, i2.getLatitude(), i2.getLongitude());
        return d11 <= d && d12 <= d || d21 <= d && d22 <= d;
    }

    public static boolean intersectsCircle(float[] polyPoints, float lat, float lon, float radius) {
        int i = 0;
        while (i < polyPoints.length / 2 - 1) {
            float lat1 = polyPoints[2 * i];
            float lon1 = polyPoints[2 * i + 1];
            float lat2 = polyPoints[2 * i + 2];
            float lon2 = polyPoints[2 * i + 3];
            if (Intersection.intersectsCircle(lat1, lon1, lat2, lon2, lat, lon, radius)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static float greatCircleDistance(float lat1, float lon1, float lat2, float lon2) {
        return (float)Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon1 - lon2));
    }

    public static void main(String[] args) {
        float lat1 = 60.0f;
        float lon1 = -130.0f;
        float lat2 = 30.0f;
        float lon2 = -70.0f;
        float lat3 = 60.0f;
        float lon3 = -70.0f;
        float lat4 = 30.0f;
        float lon4 = -130.0f;
        float[] ll = Intersection.getSegIntersection(lat1, -lon1, lat2, -lon2, lat3, -lon3, lat4, -lon4);
        System.out.println("(1)=" + ll[0] + ", " + -ll[1]);
        System.out.println("(2)=" + ll[2] + ", " + -ll[3]);
        boolean b1 = Intersection.intersects(lat1, -lon1, lat2, -lon2, lat3, -lon3, lat4, -lon4);
        System.out.println("intersects=" + b1);
        float[] polypoints1 = new float[]{60.0f, -130.0f, 60.0f, -70.0f, 30.0f, -70.0f, 30.0f, -130.0f, 60.0f, -130.0f};
        float[] polypoints2 = new float[]{50.0f, -60.0f, 50.0f, -40.0f, 20.0f, -40.0f, 50.0f, -60.0f};
        boolean b2 = Intersection.polyIntersect(polypoints1, polypoints2);
        System.out.println("polyIntersect=" + b2);
        float dist = Intersection.pointCircleDistance(60.0f, -130.0f, 10.0f, 10.0f, 60.0f, -70.0f);
        System.out.println("dist=" + dist);
        boolean b3 = Intersection.intersectsCircle(60.0f, -130.0f, 70.0f, -100.0f, 60.0f, -70.0f, (float)Geo.nmToAngle(1247.0));
        System.out.println("b3=" + b3);
    }
}

