/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.event;

import com.bbn.openmap.Layer;
import com.bbn.openmap.event.LayerEvent;
import com.bbn.openmap.event.LayerListener;
import com.bbn.openmap.event.ListenerSupport;
import com.bbn.openmap.util.Debug;
import java.util.Iterator;
import java.util.Vector;

public class LayerSupport
extends ListenerSupport {
    protected Thread t;
    protected Vector events = new Vector();

    public LayerSupport(Object sourceBean) {
        super(sourceBean);
        Debug.message("layersupport", "LayerSupport | LayerSupport");
    }

    public synchronized void addLayerListener(LayerListener listener) {
        this.addListener(listener);
    }

    public synchronized void removeLayerListener(LayerListener listener) {
        this.removeListener(listener);
    }

    public synchronized void fireLayer(int type, Layer[] layers) {
        Debug.message("layersupport", "LayerSupport | fireLayer");
        Iterator it = this.iterator();
        if (Debug.debugging("layersupport")) {
            Debug.output("LayerSupport calling setLayers on " + this.size() + " objects");
        }
        if (this.size() == 0) {
            return;
        }
        LayerEvent evt = new LayerEvent(this.source, type, layers);
        while (it.hasNext()) {
            ((LayerListener)it.next()).setLayers(evt);
        }
    }

    public synchronized void pushLayerEvent(int layerEventType, Layer[] layers) {
        SetLayerRunnable runnable;
        this.events.add(new SetLayerRunnable(layerEventType, layers));
        if (!(this.t != null && this.t.isAlive() || (runnable = this.popLayerEvent()) == null)) {
            this.t = new Thread(runnable);
            this.t.start();
        }
    }

    public synchronized SetLayerRunnable popLayerEvent() {
        try {
            return (SetLayerRunnable)this.events.remove(0);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            return null;
        }
    }

    protected class SetLayerRunnable
    implements Runnable {
        protected int layerEventType;
        protected Layer[] layers;

        public SetLayerRunnable(int let, Layer[] lrs) {
            this.layerEventType = let;
            this.layers = lrs;
        }

        public int getEventType() {
            return this.layerEventType;
        }

        public Layer[] getLayers() {
            return this.layers;
        }

        public void run() {
            this.doIt(this.getEventType(), this.getLayers());
            SetLayerRunnable runnable = LayerSupport.this.popLayerEvent();
            while (runnable != null) {
                this.doIt(runnable.getEventType(), runnable.getLayers());
                runnable = LayerSupport.this.popLayerEvent();
            }
        }

        public void doIt(int eventType, Layer[] layers) {
            Debug.message("layerhandler", "LayerSupport: firing LayerEvent on LayerListeners");
            LayerSupport.this.fireLayer(eventType, layers);
        }
    }
}

