/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.shape;

import com.bbn.openmap.dataAccess.shape.MetaDbfTableModel;
import com.bbn.openmap.dataAccess.shape.ShapeConstants;
import com.bbn.openmap.dataAccess.shape.input.DbfInputStream;
import com.bbn.openmap.dataAccess.shape.output.DbfOutputStream;
import com.bbn.openmap.layer.util.LayerUtils;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.FileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;

public class DbfTableModel
extends AbstractTableModel
implements ShapeConstants,
TableModelListener {
    public static final int TYPE_CHARACTER = 67;
    public static final int TYPE_DATE = 68;
    public static final int TYPE_NUMERIC = 78;
    public static final int TYPE_LOGICAL = 76;
    public static final int TYPE_MEMO = 77;
    public static final int MODIFY_ROW_MASK = 1;
    public static final int MODIFY_COLUMN_MASK = 2;
    public static final int DONE_MASK = 8;
    public static final int SAVE_MASK = 16;
    protected int[] _lengths = null;
    protected byte[] _decimalCounts = null;
    protected byte[] _types = null;
    protected String[] _names = null;
    protected ArrayList _records = null;
    protected int _columnCount = -1;
    protected boolean writable = false;
    protected JTable table;
    protected final DbfTableModel parent;
    protected boolean dirty = false;
    protected boolean exitOnClose = false;
    protected boolean DEBUG = false;
    JPanel controlPanel = null;
    protected final StringBuffer filePath = new StringBuffer();
    protected JFrame frame = null;

    public DbfTableModel(int columnCount) {
        this._columnCount = columnCount;
        this._records = new ArrayList();
        this._lengths = new int[columnCount];
        this._decimalCounts = new byte[columnCount];
        this._types = new byte[columnCount];
        this._names = new String[columnCount];
        this.parent = this;
        this.DEBUG = Debug.debugging("shape");
    }

    public DbfTableModel(DbfInputStream is) {
        this._lengths = is.getLengths();
        this._decimalCounts = is.getDecimalCounts();
        this._names = is.getColumnNames();
        this._types = is.getTypes();
        this._records = is.getRecords();
        this._columnCount = is.getColumnCount();
        this.parent = this;
    }

    public void addRecord(ArrayList columns) {
        if (columns.size() != this._columnCount) {
            throw new RuntimeException("DbfTableModel: Mismatched Column Count");
        }
        this._records.add(columns);
    }

    public ArrayList remove(int index) {
        return (ArrayList)this._records.remove(index);
    }

    public void addBlankRecord() {
        ArrayList<Object> record = new ArrayList<Object>();
        int i = 0;
        while (i < this._columnCount) {
            record.add(this.getEmptyDefaultForType(this.getType(i)));
            ++i;
        }
        this.addRecord(record);
        if (this.DEBUG) {
            Debug.output("Adding record: " + record);
        }
    }

    public Object getEmptyDefaultForType(byte type) {
        if (type == ShapeConstants.DBF_TYPE_NUMERIC) {
            return new Integer(0);
        }
        if (type == ShapeConstants.DBF_TYPE_LOGICAL) {
            return new Boolean(false);
        }
        return "";
    }

    public Object getRecord(int recordnumber) {
        return this._records.get(recordnumber);
    }

    public Iterator getRecords() {
        return this._records.iterator();
    }

    public Class getColumnClass(int c) {
        return this.getValueAt(0, c).getClass();
    }

    public int getColumnCount() {
        return this._columnCount;
    }

    public byte getDecimalCount(int column) {
        return this._decimalCounts[column];
    }

    public String getColumnName(int column) {
        return this._names[column];
    }

    public int getLength(int column) {
        return this._lengths[column];
    }

    public int getRowCount() {
        if (this._records == null) {
            return 0;
        }
        return this._records.size();
    }

    public byte getType(int column) {
        return this._types[column];
    }

    public Object getValueAt(int row, int column) {
        ArrayList cells = (ArrayList)this._records.get(row);
        Object cell = cells.get(column);
        return cell;
    }

    public void setColumnName(int column, String name) {
        this._names[column] = name;
    }

    public void setDecimalCount(int column, byte decimalCount) {
        this._decimalCounts[column] = decimalCount;
    }

    public void setLength(int column, int length) {
        this._lengths[column] = length;
    }

    public void setType(int column, byte type) {
        this._types[column] = type;
    }

    public void setValueAt(Object object, int row, int column) {
        ArrayList columns = (ArrayList)this._records.get(row);
        columns.set(column, object);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.writable;
    }

    public void setWritable(boolean set) {
        this.writable = set;
    }

    public boolean getWritable() {
        return this.writable;
    }

    public JTable getTable(ListSelectionModel lsm) {
        JTable t = this.getTable();
        t.setModel(this);
        t.setSelectionModel(lsm);
        t.setAutoResizeMode(0);
        return t;
    }

    protected JTable getTable() {
        if (this.table == null) {
            this.table = new JTable();
        }
        return this.table;
    }

    public Component getGUI(String filename, int actionMask) {
        JPanel panel = new JPanel();
        if (filename != null) {
            panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), filename));
        } else {
            panel.setBorder(BorderFactory.createEtchedBorder());
        }
        panel.setLayout(new BorderLayout());
        JScrollPane pane = new JScrollPane(this.getTable(new DefaultListSelectionModel()));
        panel.add((Component)pane, "Center");
        this.controlPanel = new JPanel();
        panel.add((Component)this.controlPanel, "South");
        if ((actionMask & 1) != 0) {
            JButton addButton = new JButton("Add");
            addButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DbfTableModel.this.addBlankRecord();
                    DbfTableModel.this.fireTableDataChanged();
                }
            });
            JButton deleteButton = new JButton("Delete");
            deleteButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    int check;
                    int[] index = DbfTableModel.this.getTable().getSelectedRows();
                    if (index.length > 0 && (check = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete " + (index.length > 1 ? "these rows?" : "this row?"), "Confirm Delete", 2)) == 0) {
                        int i = index.length - 1;
                        while (i >= 0) {
                            if (DbfTableModel.this.DEBUG) {
                                Debug.output("Deleting record " + index[i]);
                            }
                            ArrayList removed = DbfTableModel.this.remove(index[i]);
                            if (DbfTableModel.this.DEBUG) {
                                Debug.output("Deleted records: " + removed);
                            }
                            --i;
                        }
                        DbfTableModel.this.fireTableDataChanged();
                    }
                }
            });
            this.controlPanel.add(addButton);
            this.controlPanel.add(deleteButton);
        }
        if ((actionMask & 2) != 0) {
            JButton editTableButton = new JButton("Edit Table Format");
            editTableButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    MetaDbfTableModel mdtm = new MetaDbfTableModel(DbfTableModel.this.parent);
                    mdtm.addTableModelListener(DbfTableModel.this.parent);
                    mdtm.showGUI(DbfTableModel.this.filePath.toString());
                }
            });
            this.controlPanel.add(editTableButton);
        }
        if ((actionMask & 0x10) != 0) {
            JButton saveButton = new JButton("Save");
            saveButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        String filePath = FileUtils.getFilePathToSaveFromUser("Select DBF file name...");
                        if (!filePath.endsWith(".dbf")) {
                            filePath = filePath + ".dbf";
                        }
                        if (filePath != null) {
                            DbfOutputStream dos = new DbfOutputStream(new FileOutputStream(new File(filePath)));
                            dos.writeModel(DbfTableModel.this.parent);
                            dos.close();
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                    }
                    catch (IOException ioe) {}
                }
            });
            this.controlPanel.add(saveButton);
        }
        if ((actionMask & 8) != 0) {
            JButton doneButton = new JButton("Done");
            doneButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    DbfTableModel.this.frame.dispose();
                }
            });
            this.controlPanel.add(doneButton);
        }
        return panel;
    }

    public void hideGUI() {
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
    }

    public void showGUI(String filename, int actionMask) {
        if (this.frame == null) {
            this.frame = new JFrame(filename);
            this.filePath.replace(0, this.filePath.capacity(), filename);
            this.frame.getContentPane().add(this.getGUI(null, actionMask), "Center");
            this.frame.setSize(400, 300);
            this.frame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    DbfTableModel.this.exitWindowClosed();
                }
            });
        }
        this.frame.setVisible(true);
    }

    public void exitWindowClosed() {
        if (this.exitOnClose) {
            System.exit(0);
        }
    }

    public void tableChanged(TableModelEvent e) {
        int row;
        this.dirty = true;
        if (this.DEBUG) {
            Debug.output("DbfTableModel sensing change");
        }
        if ((row = e.getFirstRow()) == -1) {
            this.commitEvents((DbfTableModel)e.getSource());
        }
    }

    protected void commitEvents(DbfTableModel model) {
        if (this.DEBUG) {
            Debug.output("Committing changes");
        }
        Iterator modelRecords = model.getRecords();
        int index = -1;
        block0: while (modelRecords.hasNext()) {
            ArrayList modelRecord = (ArrayList)modelRecords.next();
            String modelColumnName = (String)modelRecord.get(0);
            if (++index < this._columnCount) {
                String columnName = this._names[index];
                if (this.DEBUG) {
                    Debug.output(columnName + ", " + modelColumnName);
                }
                while (!columnName.equalsIgnoreCase(modelColumnName)) {
                    this.deleteColumn(index);
                    if (index >= this._columnCount) {
                        this.addColumn(modelRecord);
                        continue block0;
                    }
                    columnName = this._names[index];
                }
                continue;
            }
            if (this.DEBUG) {
                Debug.output("Add column " + modelColumnName);
            }
            this.addColumn(modelRecord);
        }
        while (++index < this._columnCount) {
            if (this.DEBUG) {
                Debug.output("Deleting extra column");
            }
            this.deleteColumn(index);
        }
        if (this.DEBUG) {
            Debug.output("New Table:");
            int j = 0;
            while (j < this._names.length) {
                Debug.output("  " + this._names[j]);
                ++j;
            }
        }
        this.fireTableStructureChanged();
        this.dirty = false;
    }

    protected void deleteColumn(int columnIndex) {
        Iterator rows = this.getRecords();
        while (rows.hasNext()) {
            ArrayList row = (ArrayList)rows.next();
            row.remove(columnIndex);
        }
        --this._columnCount;
        this._lengths = this.remove(this._lengths, columnIndex);
        this._decimalCounts = this.remove(this._decimalCounts, columnIndex);
        this._types = this.remove(this._types, columnIndex);
        this._names = this.remove(this._names, columnIndex);
    }

    protected int[] remove(int[] current, int index) {
        int[] newBytes = new int[current.length - 1];
        System.arraycopy(current, 0, newBytes, 0, index);
        System.arraycopy(current, index + 1, newBytes, index, current.length - index - 1);
        return newBytes;
    }

    protected byte[] remove(byte[] current, int index) {
        byte[] newBytes = new byte[current.length - 1];
        System.arraycopy(current, 0, newBytes, 0, index);
        System.arraycopy(current, index + 1, newBytes, index, current.length - index - 1);
        return newBytes;
    }

    protected String[] remove(String[] current, int index) {
        String[] newStrings = new String[current.length - 1];
        System.arraycopy(current, 0, newStrings, 0, index);
        System.arraycopy(current, index + 1, newStrings, index, current.length - index - 1);
        return newStrings;
    }

    protected void addColumn(ArrayList recordColumn) {
        Iterator rows = this.getRecords();
        while (rows.hasNext()) {
            ArrayList row = (ArrayList)rows.next();
            row.add("");
        }
        ++this._columnCount;
        this._names = this.add(this._names, (String)recordColumn.get(0));
        this._types = this.add(this._types, (byte)((Byte)recordColumn.get(1)));
        this._lengths = this.add(this._lengths, ((Integer)recordColumn.get(2)).byteValue());
        this._decimalCounts = this.add(this._decimalCounts, ((Integer)recordColumn.get(3)).byteValue());
    }

    protected int[] add(int[] current, byte nb) {
        int[] newBytes = new int[current.length + 1];
        System.arraycopy(current, 0, newBytes, 0, current.length);
        newBytes[current.length] = nb;
        return newBytes;
    }

    protected byte[] add(byte[] current, byte nb) {
        byte[] newBytes = new byte[current.length + 1];
        System.arraycopy(current, 0, newBytes, 0, current.length);
        newBytes[current.length] = nb;
        return newBytes;
    }

    protected String[] add(String[] current, String string) {
        String[] newStrings = new String[current.length + 1];
        System.arraycopy(current, 0, newStrings, 0, current.length);
        newStrings[current.length] = string;
        return newStrings;
    }

    public void cleanupChanges() {
        if (this.DEBUG) {
            Debug.output("DbfTableModel cleaning up changes.");
        }
        this.dirty = false;
    }

    public DbfTableModel headerClone() {
        int size = this.getColumnCount();
        DbfTableModel dtm = new DbfTableModel(size);
        int i = 0;
        while (i < size) {
            dtm.setColumnName(i, this.getColumnName(i));
            dtm.setDecimalCount(i, this.getDecimalCount(i));
            dtm.setLength(i, this.getLength(i));
            dtm.setType(i, this.getType(i));
            ++i;
        }
        return dtm;
    }

    public static DbfTableModel getDbfTableModel(URL dbf) {
        DbfTableModel model = null;
        try {
            InputStream is = dbf.openStream();
            try {
                model = new DbfTableModel(new DbfInputStream(is));
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            is.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        return model;
    }

    public static void main(String[] args) {
        Debug.init();
        if (args.length < 1) {
            System.exit(0);
        }
        try {
            URL dbf = LayerUtils.getResourceOrFileOrURL(null, args[0]);
            InputStream is = dbf.openStream();
            DbfInputStream dis = new DbfInputStream(is);
            DbfTableModel dtm = new DbfTableModel(dis);
            dtm.setWritable(true);
            dtm.exitOnClose = true;
            dtm.showGUI(args[0], 19);
            is.close();
        }
        catch (Exception e) {
            Debug.error(e.getMessage());
            e.printStackTrace();
        }
    }
}

