/*
 * Decompiled with CFR 0.152.
 */
package com.bbn.openmap.dataAccess.iso8211;

import com.bbn.openmap.dataAccess.iso8211.DDFConstants;
import com.bbn.openmap.dataAccess.iso8211.DDFModule;
import com.bbn.openmap.dataAccess.iso8211.DDFSubfieldDefinition;
import com.bbn.openmap.dataAccess.iso8211.DDFUtils;
import com.bbn.openmap.layer.vpf.MutableInt;
import com.bbn.openmap.util.Debug;
import com.bbn.openmap.util.PropUtils;
import java.util.Iterator;
import java.util.Vector;

public class DDFFieldDefinition
implements DDFConstants {
    protected DDFModule poModule;
    protected String pszTag;
    protected String _fieldName;
    protected String _arrayDescr;
    protected String _formatControls;
    protected boolean bRepeatingSubfields;
    protected int nFixedWidth;
    protected DataStructCode _data_struct_code;
    protected DataTypeCode _data_type_code;
    protected Vector paoSubfieldDefns;

    public String getName() {
        return this.pszTag;
    }

    public String getDescription() {
        return this._fieldName;
    }

    public int getSubfieldCount() {
        if (this.paoSubfieldDefns != null) {
            return this.paoSubfieldDefns.size();
        }
        return 0;
    }

    public int getFixedWidth() {
        return this.nFixedWidth;
    }

    public boolean isRepeating() {
        return this.bRepeatingSubfields;
    }

    public void setRepeating(boolean val) {
        this.bRepeatingSubfields = val;
    }

    public DDFFieldDefinition() {
        this.poModule = null;
        this.pszTag = null;
        this._fieldName = null;
        this._arrayDescr = null;
        this._formatControls = null;
        this.paoSubfieldDefns = null;
        this.bRepeatingSubfields = false;
    }

    public DDFFieldDefinition(DDFModule poModuleIn, String pszTagIn, byte[] pachFieldArea) {
        this.initialize(poModuleIn, pszTagIn, pachFieldArea);
    }

    public boolean initialize(DDFModule poModuleIn, String pszTagIn, byte[] pachFieldArea) {
        int iFDOffset = poModuleIn._fieldControlLength;
        this.poModule = poModuleIn;
        this.pszTag = pszTagIn;
        this._data_struct_code = DataStructCode.get((char)pachFieldArea[0]);
        this._data_type_code = DataTypeCode.get((char)pachFieldArea[1]);
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFFieldDefinition.initialize(" + pszTagIn + "):\n\t\t data_struct_code = " + this._data_struct_code + "\n\t\t data_type_code = " + this._data_type_code + "\n\t\t iFDOffset = " + iFDOffset);
        }
        byte[] tempData = new byte[pachFieldArea.length - iFDOffset];
        System.arraycopy(pachFieldArea, iFDOffset, tempData, 0, pachFieldArea.length - iFDOffset);
        MutableInt nCharsConsumed = new MutableInt();
        this._fieldName = DDFUtils.fetchVariable(tempData, tempData.length, '\u001f', '\u001e', nCharsConsumed);
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFFieldDefinition.initialize(" + pszTagIn + "): created field name " + this._fieldName);
        }
        tempData = new byte[pachFieldArea.length - (iFDOffset += nCharsConsumed.value)];
        System.arraycopy(pachFieldArea, iFDOffset, tempData, 0, pachFieldArea.length - iFDOffset);
        this._arrayDescr = DDFUtils.fetchVariable(tempData, tempData.length, '\u001f', '\u001e', nCharsConsumed);
        tempData = new byte[pachFieldArea.length - (iFDOffset += nCharsConsumed.value)];
        System.arraycopy(pachFieldArea, iFDOffset, tempData, 0, pachFieldArea.length - iFDOffset);
        this._formatControls = DDFUtils.fetchVariable(tempData, tempData.length, '\u001f', '\u001e', nCharsConsumed);
        if (this._data_struct_code != DataStructCode.ELEMENTARY) {
            if (!this.buildSubfieldDefns(this._arrayDescr)) {
                return false;
            }
            if (!this.applyFormats(this._formatControls)) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("  DDFFieldDefn:\n");
        buf.append("      Tag = " + this.pszTag + "\n");
        buf.append("      _fieldName = " + this._fieldName + "\n");
        buf.append("      _arrayDescr = " + this._arrayDescr + "\n");
        buf.append("      _formatControls = " + this._formatControls + "\n");
        buf.append("      _data_struct_code = " + this._data_struct_code + "\n");
        buf.append("      _data_type_code = " + this._data_type_code + "\n");
        if (this.paoSubfieldDefns != null) {
            Iterator it = this.paoSubfieldDefns.iterator();
            while (it.hasNext()) {
                buf.append((DDFSubfieldDefinition)it.next());
            }
        }
        return buf.toString();
    }

    protected boolean buildSubfieldDefns(String pszSublist) {
        if (pszSublist.charAt(0) == '*') {
            this.bRepeatingSubfields = true;
            pszSublist = pszSublist.substring(1);
        }
        Vector papszSubfieldNames = PropUtils.parseMarkers(pszSublist, "!");
        this.paoSubfieldDefns = new Vector();
        Iterator it = papszSubfieldNames.iterator();
        while (it.hasNext()) {
            DDFSubfieldDefinition ddfsd = new DDFSubfieldDefinition();
            ddfsd.setName((String)it.next());
            this.paoSubfieldDefns.add(ddfsd);
        }
        return true;
    }

    protected String extractSubstring(String pszSrc) {
        int nBracket = 0;
        int i = 0;
        while (i < pszSrc.length() && (nBracket > 0 || pszSrc.charAt(i) != ',')) {
            if (pszSrc.charAt(i) == '(') {
                ++nBracket;
            } else if (pszSrc.charAt(i) == ')') {
                --nBracket;
            }
            ++i;
        }
        String pszReturn = pszSrc.charAt(0) == '(' ? pszSrc.substring(1, i - 2) : pszSrc.substring(0, i);
        return pszReturn;
    }

    protected String expandFormat(String pszSrc) {
        StringBuffer szDest = new StringBuffer();
        int iSrc = 0;
        int nRepeat = 0;
        while (iSrc < pszSrc.length()) {
            if ((iSrc == 0 || pszSrc.charAt(iSrc - 1) == ',') && pszSrc.charAt(iSrc) == '(') {
                String pszContents = this.extractSubstring(pszSrc + iSrc);
                String pszExpandedContents = this.expandFormat(pszContents);
                szDest.append(pszExpandedContents);
                iSrc = iSrc + pszContents.length() + 2;
                continue;
            }
            if ((iSrc == 0 || pszSrc.charAt(iSrc - 1) == ',') && Character.isDigit(pszSrc.charAt(iSrc))) {
                int orig_iSrc = iSrc;
                while (Character.isDigit(pszSrc.charAt(iSrc))) {
                    ++iSrc;
                }
                String nRepeatString = pszSrc.substring(orig_iSrc, iSrc);
                nRepeat = Integer.parseInt(nRepeatString);
                String pszContents = this.extractSubstring(pszSrc.substring(iSrc));
                String pszExpandedContents = this.expandFormat(pszContents);
                int i = 0;
                while (i < nRepeat) {
                    szDest.append(pszExpandedContents);
                    if (i < nRepeat - 1) {
                        szDest.append(",");
                    }
                    ++i;
                }
                if (iSrc == 40) {
                    iSrc += pszContents.length() + 2;
                    continue;
                }
                iSrc += pszContents.length();
                continue;
            }
            szDest.append(pszSrc.charAt(iSrc++));
        }
        return szDest.toString();
    }

    protected boolean applyFormats(String _formatControls) {
        if (_formatControls.length() < 2 || !_formatControls.startsWith("(") || !_formatControls.endsWith(")")) {
            Debug.error("DDFFieldDefinition: Format controls for " + this.pszTag + " field missing brackets {" + _formatControls + "} : length = " + _formatControls.length() + ", starts with {" + _formatControls.charAt(0) + "}, ends with {" + _formatControls.charAt(_formatControls.length() - 1) + "}");
            return false;
        }
        String pszFormatList = this.expandFormat(_formatControls);
        if (Debug.debugging("iso8211")) {
            Debug.output("DDFFieldDefinition.applyFormats{" + _formatControls + "} expanded to {" + pszFormatList + "} ");
        }
        Vector papszFormatItems = PropUtils.parseMarkers(pszFormatList, ",");
        int iFormatItem = 0;
        Iterator it = papszFormatItems.iterator();
        while (it.hasNext()) {
            String pszPastPrefix = (String)it.next();
            int pppIndex = 0;
            while (Character.isDigit(pszPastPrefix.charAt(pppIndex))) {
                ++pppIndex;
            }
            pszPastPrefix = pszPastPrefix.substring(pppIndex);
            if (iFormatItem > this.paoSubfieldDefns.size()) {
                Debug.error("DDFFieldDefinition: Got more formats than subfields for field " + this.pszTag);
                break;
            }
            if (!((DDFSubfieldDefinition)this.paoSubfieldDefns.elementAt(iFormatItem)).setFormat(pszPastPrefix)) {
                Debug.output("DDFFieldDefinition had problem setting format for " + pszPastPrefix);
                return false;
            }
            ++iFormatItem;
        }
        if (iFormatItem < this.paoSubfieldDefns.size()) {
            Debug.error("DDFFieldDefinition: Got fewer formats than subfields for field " + this.pszTag + " got (" + iFormatItem + ", should have " + this.paoSubfieldDefns.size() + ")");
            return false;
        }
        this.nFixedWidth = 0;
        int i = 0;
        while (i < this.paoSubfieldDefns.size()) {
            DDFSubfieldDefinition ddfsd = (DDFSubfieldDefinition)this.paoSubfieldDefns.elementAt(i);
            if (ddfsd.getWidth() == 0) {
                this.nFixedWidth = 0;
                break;
            }
            this.nFixedWidth += ddfsd.getWidth();
            ++i;
        }
        return true;
    }

    public DDFSubfieldDefinition findSubfieldDefn(String pszMnemonic) {
        if (this.paoSubfieldDefns != null) {
            Iterator it = this.paoSubfieldDefns.iterator();
            while (pszMnemonic != null && it.hasNext()) {
                DDFSubfieldDefinition ddfsd = (DDFSubfieldDefinition)it.next();
                if (!pszMnemonic.equalsIgnoreCase(ddfsd.getName())) continue;
                return ddfsd;
            }
        }
        return null;
    }

    public DDFSubfieldDefinition getSubfieldDefn(int i) {
        if (this.paoSubfieldDefns == null || i < 0 || i >= this.paoSubfieldDefns.size()) {
            return null;
        }
        return (DDFSubfieldDefinition)this.paoSubfieldDefns.elementAt(i);
    }

    public static class DataTypeCode {
        public static final DataTypeCode CHAR_STRING = new DataTypeCode('0', "character string");
        public static final DataTypeCode IMPLICIT_POINT = new DataTypeCode('1', "implicit point");
        public static final DataTypeCode EXPLICIT_POINT = new DataTypeCode('2', "explicit point");
        public static final DataTypeCode EXPLICIT_POINT_SCALED = new DataTypeCode('3', "explicit point scaled");
        public static final DataTypeCode CHAR_BIT_STRING = new DataTypeCode('4', "character bit string");
        public static final DataTypeCode BIT_STRING = new DataTypeCode('5', "bit string");
        public static final DataTypeCode MIXED_DATA_TYPE = new DataTypeCode('6', "mixed data type");
        char code = (char)48;
        String prettyName;

        public DataTypeCode(char structCode, String desc) {
            this.code = structCode;
            this.prettyName = desc;
        }

        public char getCode() {
            return this.code;
        }

        public String toString() {
            return this.prettyName;
        }

        public static DataTypeCode get(char c) {
            if (c == IMPLICIT_POINT.getCode()) {
                return IMPLICIT_POINT;
            }
            if (c == EXPLICIT_POINT.getCode()) {
                return EXPLICIT_POINT;
            }
            if (c == EXPLICIT_POINT_SCALED.getCode()) {
                return EXPLICIT_POINT_SCALED;
            }
            if (c == CHAR_BIT_STRING.getCode()) {
                return CHAR_BIT_STRING;
            }
            if (c == BIT_STRING.getCode()) {
                return BIT_STRING;
            }
            if (c == MIXED_DATA_TYPE.getCode()) {
                return MIXED_DATA_TYPE;
            }
            if (c == CHAR_STRING.getCode()) {
                return CHAR_STRING;
            }
            if (Debug.debugging("iso8211")) {
                Debug.output("DDFFieldDefinition tested for unknown data type code: " + c);
            }
            return CHAR_STRING;
        }
    }

    public static class DataStructCode {
        public static final DataStructCode ELEMENTARY = new DataStructCode('0', "elementary");
        public static final DataStructCode VECTOR = new DataStructCode('1', "vector");
        public static final DataStructCode ARRAY = new DataStructCode('2', "array");
        public static final DataStructCode CONCATENATED = new DataStructCode('3', "concatenated");
        char code = (char)48;
        String prettyName;

        public DataStructCode(char structCode, String name) {
            this.code = structCode;
            this.prettyName = name;
        }

        public char getCode() {
            return this.code;
        }

        public String toString() {
            return this.prettyName;
        }

        public static DataStructCode get(char c) {
            if (c == CONCATENATED.getCode()) {
                return CONCATENATED;
            }
            if (c == VECTOR.getCode()) {
                return VECTOR;
            }
            if (c == ARRAY.getCode()) {
                return ARRAY;
            }
            if (c == ELEMENTARY.getCode()) {
                return ELEMENTARY;
            }
            if (Debug.debugging("iso8211")) {
                Debug.output("DDFFieldDefinition tested for unknown code: " + c);
            }
            return ELEMENTARY;
        }
    }
}

