/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task.dataSetBrowser;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSet;
import edu.sc.seis.gee.task.dataSetBrowser.DataSetSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterSelectionEvent;
import edu.sc.seis.gee.task.dataSetBrowser.ParameterTreeNode;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectedListener;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramSelectionEvent;
import edu.sc.seis.gee.task.dataSetBrowser.SeismogramTreeNode;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.apache.log4j.Category;

public class TreeSelectionMediator
implements TreeSelectionListener {
    EventListenerList listenerList = new EventListenerList();
    private boolean active = true;
    protected static Category logger = Category.getInstance((String)TreeSelectionMediator.class.getName());

    public TreeSelectionMediator() {
        this(true);
    }

    public TreeSelectionMediator(boolean active) {
        this.active = active;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public void addSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.listenerList.add(SeismogramSelectedListener.class, l);
    }

    public void removeSeismogramSelectedListener(SeismogramSelectedListener l) {
        this.listenerList.remove(SeismogramSelectedListener.class, l);
    }

    public void addParameterSelectedListener(ParameterSelectedListener l) {
        this.listenerList.add(ParameterSelectedListener.class, l);
    }

    public void removeParameterSelectedListener(ParameterSelectedListener l) {
        this.listenerList.remove(ParameterSelectedListener.class, l);
    }

    public void addDataSetSelectedListener(DataSetSelectedListener l) {
        this.listenerList.add(DataSetSelectedListener.class, l);
    }

    public void removeDataSetSelectedListener(DataSetSelectedListener l) {
        this.listenerList.remove(DataSetSelectedListener.class, l);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (!this.active) {
            return;
        }
        try {
            TreePath[] path = e.getPaths();
            if (path != null) {
                for (int counter = 0; counter < path.length; ++counter) {
                    Object treeselected = e.getSource();
                    Object nodeselected = path[counter].getLastPathComponent();
                    int totalnodes = path[counter].getPathCount();
                    if (nodeselected instanceof DataSet) {
                        this.mediate(e.getSource(), (DataSet)nodeselected, e.isAddedPath(path[counter]));
                        continue;
                    }
                    if (nodeselected instanceof SeismogramTreeNode) {
                        this.mediate(e.getSource(), (SeismogramTreeNode)nodeselected, e.isAddedPath(path[counter]));
                        continue;
                    }
                    if (nodeselected instanceof ParameterTreeNode) {
                        this.mediate(e.getSource(), (ParameterTreeNode)nodeselected, e.isAddedPath(path[counter]));
                        continue;
                    }
                    logger.warn((Object)("unknown node type: " + nodeselected.getClass().toString()));
                }
            }
        }
        catch (Throwable ex) {
            GlobalExceptionHandler.handle((Throwable)ex);
        }
    }

    protected void mediate(Object source, DataSet dataset, boolean selected) {
    }

    protected void mediate(Object source, SeismogramTreeNode seis, boolean selected) {
        SeismogramSelectionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SeismogramSelectedListener.class) continue;
            if (event == null) {
                event = new SeismogramSelectionEvent(source, seis.getSeismogram(), selected);
            }
            ((SeismogramSelectedListener)listeners[i + 1]).seismogramSelected(event);
        }
    }

    protected void mediate(Object source, ParameterTreeNode paramNode, boolean selected) {
        ParameterSelectionEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ParameterSelectedListener.class) continue;
            if (event == null) {
                event = new ParameterSelectionEvent(source, paramNode.getDataSet(), paramNode.getName(), paramNode.getParameterValue(), selected);
            }
            ((ParameterSelectedListener)listeners[i + 1]).parameterSelected(event);
        }
    }
}

