/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.IfNetwork.Station;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionEvent;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionListener;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StationSelectionTask
implements Task,
StationSelectionListener {
    private List stationStrings = new ArrayList();
    private Station[] selectedStations = new Station[0];
    private ChannelChooser chooser = null;
    private ChannelChooserTask chooserTask;
    private boolean printSelectedConfig = false;

    @Override
    public void configure(Map params) throws ConfigurationException {
        String boolString;
        String chooserID;
        if (params.containsKey("channelChooserTask")) {
            chooserID = (String)params.get("channelChooserTask");
            if (chooserID == null || chooserID.length() == 0) {
                throw new ConfigurationException("ChannelChooserTask not set in config");
            }
        } else {
            throw new ConfigurationException("ChannelChooserTask not found in config");
        }
        TaskAction taskAction = CommonAccess.getCommonAccess().getTaskAction(chooserID);
        this.chooserTask = (ChannelChooserTask)taskAction.getTask();
        Set keys = params.keySet();
        for (String current : keys) {
            if (!current.startsWith("Station_")) continue;
            String currentStation = (String)params.get(current);
            this.stationStrings.add(currentStation);
            System.out.println("station added from config: " + currentStation);
        }
        if (params.containsKey("printSelectedConfig") && (boolString = (String)params.get("printSelectedConfig")).equals("true")) {
            this.printSelectedConfig = true;
        }
    }

    @Override
    public void invoke() throws Exception {
        this.getChannelChooser().clearStationSelection();
        Station[] allStations = this.getChannelChooser().getStations();
        for (int i = 0; i < allStations.length; ++i) {
            String currentStationString = allStations[i].getNetworkAttr().get_code() + "." + allStations[i].get_code();
            if (!this.stationStrings.contains(currentStationString)) continue;
            this.getChannelChooser().toggleStationSelected(allStations[i]);
        }
    }

    @Override
    public void destroy() {
    }

    public ChannelChooser getChannelChooser() throws NoNetworkException {
        if (this.chooser == null) {
            this.chooser = this.chooserTask.getChannelChooser();
            this.chooser.addStationSelectionListener((StationSelectionListener)this);
        }
        return this.chooser;
    }

    public void stationSelectionChanged(StationSelectionEvent s) {
        if (this.printSelectedConfig) {
            this.selectedStations = s.getSelectedStations();
            this.printSelectedStations();
        }
    }

    private void printSelectedStations() {
        System.out.println("\t\t<!--Selected Stations from ChannelChooser-->");
        for (int i = 0; i < this.selectedStations.length; ++i) {
            System.out.println("\t\t<taskconfig>");
            System.out.println("\t\t\t<name>Station_" + i + "</name>");
            System.out.println("\t\t\t<value>" + this.selectedStations[i].getNetworkAttr().get_code() + "." + this.selectedStations[i].get_code() + "</value>");
            System.out.println("\t\t</taskconfig>");
        }
        System.out.println("\t\t<!--end of selected stations-->");
    }
}

