/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Category;

public class SequenceTask
extends JPanel
implements Task {
    Map params;
    List taskList;
    ListIterator it;
    JButton prev = null;
    JButton next = null;
    JComponent current = null;
    boolean guiInit = false;
    static Category logger = Category.getInstance((String)SequenceTask.class.getName());

    public SequenceTask() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
    }

    @Override
    public void invoke() throws ConfigurationException {
        if (this.taskList == null) {
            if (this.params.containsKey("taskSequence")) {
                TaskAction taskAction;
                int index;
                String taskSeqStr = (String)this.params.get("taskSequence");
                taskSeqStr = taskSeqStr.trim();
                this.taskList = new LinkedList();
                logger.debug((Object)("Task Seq is " + taskSeqStr));
                while ((index = taskSeqStr.indexOf(32)) != -1) {
                    String taskId = taskSeqStr.substring(0, index);
                    logger.debug((Object)("'" + taskId + "'"));
                    taskAction = CommonAccess.getCommonAccess().getTaskAction(taskId);
                    this.taskList.add(taskAction);
                    taskSeqStr = taskSeqStr.substring(index + 1).trim();
                }
                logger.debug((Object)taskSeqStr);
                taskAction = CommonAccess.getCommonAccess().getTaskAction(taskSeqStr);
                this.taskList.add(taskAction);
            } else {
                throw new ConfigurationException("taskSequence parameter must defined");
            }
        }
        if (!this.guiInit) {
            this.guiInit = true;
            if (this.checkNextPrevNeeded()) {
                JPanel buttonPanel = new JPanel();
                this.add((Component)buttonPanel, "South");
                this.prev = new JButton("<< Prev");
                this.prev.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SequenceTask.this.prevTask();
                    }
                });
                this.prev.setEnabled(false);
                buttonPanel.add(this.prev);
                this.next = new JButton("Next >>");
                this.next.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SequenceTask.this.nextTask();
                    }
                });
                this.next.setEnabled(false);
                buttonPanel.add(this.next);
            }
        }
        this.it = this.taskList.listIterator();
        this.nextTask();
        this.checkNextPrev();
    }

    @Override
    public void destroy() {
    }

    protected void nextTask() {
        TaskAction taskAction = (TaskAction)this.it.next();
        while (this.replaceTask(taskAction) && this.it.hasNext()) {
            taskAction = (TaskAction)this.it.next();
        }
    }

    protected void prevTask() {
        TaskAction taskAction = (TaskAction)this.it.previous();
        while (this.replaceTask(taskAction) && this.it.hasPrevious()) {
            taskAction = (TaskAction)this.it.previous();
        }
    }

    protected boolean replaceTask(TaskAction taskAction) {
        try {
            if (this.current == taskAction.getTask()) {
                return true;
            }
            if (this.current != null) {
                this.remove(this.current);
                this.validate();
            }
            boolean isNotJComp = true;
            String displayLoc = (String)taskAction.getConfigParam("gee.task.displayLocation");
            if (displayLoc == null) {
                displayLoc = "frame";
            }
            if ((taskAction.getTask() instanceof JComponent || taskAction.getTask() instanceof GUITask) && !displayLoc.equals("none") && !displayLoc.equals("main")) {
                isNotJComp = false;
                this.current = taskAction.getTask() instanceof GUITask ? ((GUITask)taskAction.getTask()).getGUI() : (JComponent)((Object)taskAction.getTask());
                Container otherParent = this.current.getParent();
                if (otherParent != null) {
                    otherParent.remove(this.current);
                    while (otherParent != null && !(otherParent instanceof SequenceTask)) {
                        otherParent = otherParent.getParent();
                    }
                    if (otherParent != null && otherParent instanceof SequenceTask) {
                        ((SequenceTask)otherParent).getTaskAction().destroyJFrame();
                    }
                }
                taskAction.destroyJFrame();
                this.add((Component)this.current, "Center");
            }
            if (displayLoc.equals("main")) {
                taskAction.actionPerformed(new ActionEvent(this, 1001, "Sequence Task"));
            } else {
                taskAction.getTask().invoke();
            }
            this.validate();
            this.repaint();
            this.checkNextPrev();
            return isNotJComp;
        }
        catch (Exception e) {
            GlobalExceptionHandler.handle((Throwable)e);
            return false;
        }
    }

    protected boolean checkNextPrevNeeded() throws ConfigurationException {
        Iterator checkIter = this.taskList.iterator();
        int numGUI = 0;
        while (checkIter.hasNext()) {
            TaskAction taskAction = (TaskAction)checkIter.next();
            String displayLoc = (String)taskAction.getConfigParam("gee.task.displayLocation");
            if (displayLoc == null) {
                logger.debug((Object)"displayLoc is null");
                displayLoc = "frame";
            }
            if ((taskAction.getTask() instanceof JComponent || taskAction.getTask() instanceof GUITask) && !displayLoc.equals("none")) {
                logger.debug((Object)("found gui " + taskAction.getName() + " " + displayLoc));
                ++numGUI;
            }
            if (numGUI <= true) continue;
            return true;
        }
        return false;
    }

    protected void checkNextPrev() {
        if (this.next == null || this.prev == null) {
            return;
        }
        if (this.it.hasNext()) {
            this.next.setEnabled(true);
        } else {
            this.next.setEnabled(false);
        }
        if (this.it.hasPrevious()) {
            this.prev.setEnabled(true);
        } else {
            this.prev.setEnabled(false);
        }
    }

    public TaskAction getTaskAction() {
        return (TaskAction)this.params.get("gee.task.taskAction");
    }
}

