/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.FissuresException;
import edu.iris.Fissures.seismogramDC.LocalSeismogramImpl;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramInfoDisplay;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeEvent;
import edu.sc.seis.fissuresUtil.xml.SeisDataChangeListener;
import edu.sc.seis.fissuresUtil.xml.SeisDataErrorEvent;
import edu.sc.seis.gee.task.GUITask;
import edu.sc.seis.gee.task.GlobalToolBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class SeismogramInfoTask
extends SDMouseAdapter
implements GUITask {
    protected Map configParams;
    protected SeismogramInfoDisplay infoDisplay = null;
    private static Logger logger = Logger.getLogger(SeismogramInfoTask.class);

    @Override
    public void configure(Map params) {
        this.configParams = params;
    }

    @Override
    public JComponent getMoreOptionsGUI() {
        return null;
    }

    @Override
    public JComponent getGUI() throws Exception {
        if (this.infoDisplay == null) {
            LinkedList<String> format = new LinkedList<String>();
            if (this.configParams.containsKey("numPoints")) {
                format.add("Number of Points");
            }
            if (this.configParams.containsKey("ID")) {
                format.add("ID");
            }
            if (this.configParams.containsKey("sampling")) {
                format.add("Sampling");
            }
            if (this.configParams.containsKey("channelID")) {
                format.add("Channel ID");
            }
            if (this.configParams.containsKey("beginTime")) {
                format.add("Begin Time");
            }
            if (this.configParams.containsKey("endTime")) {
                format.add("End Time");
            }
            if (this.configParams.containsKey("minValue")) {
                format.add("Minimum Value");
            }
            if (this.configParams.containsKey("maxValue")) {
                format.add("Maximum Value");
            }
            if (this.configParams.containsKey("meanValue")) {
                format.add("Mean Value");
            }
            if (this.configParams.containsKey("channel")) {
                format.add("channel");
            }
            if (this.configParams.containsKey("instrumentation")) {
                format.add("instrumentation");
            }
            this.infoDisplay = new SeismogramInfoDisplay(format);
            this.infoDisplay.setMinimumSize(new Dimension(200, 100));
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.infoDisplay, "Center");
        JButton clear = new JButton("Clear");
        clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SeismogramInfoTask.this.infoDisplay.clear();
            }
        });
        panel.add((Component)clear, "South");
        return panel;
    }

    @Override
    public boolean hasMoreOptions() {
        return false;
    }

    @Override
    public void invoke() {
        GlobalToolBar.setActive(this);
    }

    @Override
    public void destroy() {
    }

    public SeismogramInfoDisplay getInfoDisplay() {
        return this.infoDisplay;
    }

    public void mouseClicked(SDMouseEvent me) {
        logger.debug((Object)"Got a mouse click");
        SeismogramDisplay display = me.getDisplay();
        DataSetSeismogram[] seismograms = display.getSeismograms();
        logger.debug((Object)("Got a mouse click on a SD, there are " + seismograms.length + " seismograms."));
        SeismogramInfoProcessor infoProcessor = new SeismogramInfoProcessor(seismograms, this.getInfoDisplay());
        for (int i = 0; i < seismograms.length; ++i) {
            this.getInfoDisplay().addSeismogram(seismograms[i]);
            seismograms[i].retrieveData((SeisDataChangeListener)infoProcessor);
        }
    }

    private class SeismogramInfoProcessor
    implements SeisDataChangeListener {
        DataSetSeismogram[] seis;
        SeismogramInfoDisplay infoDisplay;
        boolean[] finished;
        LocalSeismogramImpl[] localSeis;
        SeisDataErrorEvent error = null;

        SeismogramInfoProcessor(DataSetSeismogram[] seis, SeismogramInfoDisplay infoDisplay) {
            this.seis = seis;
            this.infoDisplay = infoDisplay;
        }

        public void error(SeisDataErrorEvent sdce) {
            this.error = sdce;
            logger.warn((Object)("error for " + sdce.getSource().getName()));
        }

        public void finished(SeisDataChangeEvent sdce) {
            logger.debug((Object)("finished " + sdce.getSource().getName()));
        }

        public void pushData(SeisDataChangeEvent sdce) {
            if (sdce.getSeismograms().length != 0) {
                for (int i = 0; i < sdce.getSeismograms().length; ++i) {
                    try {
                        this.infoDisplay.addSeismogram(sdce.getSeismograms()[i]);
                        continue;
                    }
                    catch (FissuresException e) {
                        GlobalExceptionHandler.handle((Throwable)e);
                    }
                }
            } else {
                logger.info((Object)"pushData event has zero length localSeismogram array");
            }
        }

        private int getIndex(DataSetSeismogram s) {
            for (int i = 0; i < this.seis.length; ++i) {
                if (this.seis[i] != s) continue;
                return i;
            }
            throw new IllegalArgumentException("Can't find index for this seismogram");
        }
    }
}

