/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.model.MicroSecondDate;
import edu.sc.seis.fissuresUtil.display.BasicSeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.NamedColor;
import edu.sc.seis.fissuresUtil.display.PickZoneDisplay;
import edu.sc.seis.fissuresUtil.display.SeismogramDisplay;
import edu.sc.seis.fissuresUtil.display.drawable.DrawableIterator;
import edu.sc.seis.fissuresUtil.display.drawable.Selection;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseAdapter;
import edu.sc.seis.fissuresUtil.display.mouse.SDMouseEvent;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.fissuresUtil.time.MicroSecondTimeRange;
import edu.sc.seis.fissuresUtil.xml.DataSetSeismogram;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ButtonGroupManager;
import edu.sc.seis.gee.task.ColumnSeismogramTask;
import edu.sc.seis.gee.task.GlobalToolBar;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import org.apache.log4j.Category;

public class RangeSelectionTask
extends SDMouseAdapter
implements Task {
    protected Selection currentSelection;
    private BasicSeismogramDisplay prevDisp;
    protected boolean newSelection;
    private Map params;
    private MouseEvent pressedME;
    private ButtonGroup bg;
    private Color[] selectionColors = new Color[]{new NamedColor(Color.RED, 64, "red"), new NamedColor(Color.YELLOW.darker(), 64, "yellow"), new NamedColor(Color.GREEN.darker(), 64, "green"), new NamedColor(Color.BLUE, 64, "blue")};
    private static Category logger = Category.getInstance((String)RangeSelectionTask.class.getName());
    private TaskAction childColTaskAction;
    private ColumnSeismogramTask childColSeis;
    private ColumnSeismogramTask parentColSeis;
    private int selectionCount = 0;

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.params = params;
        String parentColId = (String)params.get("colSeisDisp");
        TaskAction parentColTaskAction = CommonAccess.getCommonAccess().getTaskAction(parentColId);
        this.parentColSeis = (ColumnSeismogramTask)parentColTaskAction.getTask();
        String subColId = (String)params.get("subColSeis");
        this.childColTaskAction = CommonAccess.getCommonAccess().getTaskAction(subColId);
        this.bg = ButtonGroupManager.get((String)params.get("gee.task.buttonGroupId"));
    }

    @Override
    public void invoke() {
        GlobalToolBar.setActive(this);
    }

    @Override
    public void destroy() {
        this.childColTaskAction.reset();
        this.childColSeis = null;
    }

    public void mouseDragged(SDMouseEvent currME) {
        if (this.pressedME == null || currME.getX() == this.pressedME.getX()) {
            return;
        }
        ButtonModel bm = this.bg.getSelection();
        if (!bm.getActionCommand().equals(this.params.get("gee.task.id"))) {
            return;
        }
        if (this.rangeSelectableComponent(currME)) {
            BasicSeismogramDisplay currDisp = (BasicSeismogramDisplay)currME.getDisplay();
            MicroSecondDate mouseTime = currME.getTime();
            if (this.currentSelection != null) {
                if (Math.abs(mouseTime.getTime() - this.currentSelection.getEnd().getTime()) < Math.abs(mouseTime.getTime() - this.currentSelection.getBegin().getTime())) {
                    this.currentSelection.setEnd(mouseTime);
                } else {
                    this.currentSelection.setBegin(mouseTime);
                }
            } else {
                MicroSecondTimeRange selectionRange = new MicroSecondTimeRange(currME.getTime(this.pressedME.getX()), mouseTime);
                this.currentSelection = this.makeNewSelection(currDisp, selectionRange);
            }
            currDisp.setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public void mousePressed(SDMouseEvent me) {
        this.pressedME = me;
        Selection selected = this.getSelection(me);
        if (selected != null) {
            this.currentSelection = selected;
            me.getComponent().setCursor(Cursor.getPredefinedCursor(11));
        }
    }

    public void mouseReleased(SDMouseEvent me) {
        if (this.currentSelection != null) {
            if (this.currentSelection.isRemoveable()) {
                this.currentSelection.remove();
            } else if (this.newSelection) {
                this.addSelectionToDisplay(this.currentSelection);
                this.newSelection = false;
            }
            this.currentSelection = null;
        }
    }

    private void addSelectionToDisplay(Selection creator) {
        if (this.childColSeis == null) {
            try {
                this.childColSeis = (ColumnSeismogramTask)this.childColTaskAction.getTask();
                this.childColTaskAction.checkDisplayLocation();
                this.childColTaskAction.getJFrame().addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        RangeSelectionTask.this.parentColSeis.clearSelections();
                        RangeSelectionTask.this.childColTaskAction.reset();
                        RangeSelectionTask.this.childColSeis = null;
                    }
                });
                creator.setChild(this.childColSeis.getDisplay());
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Difficulty getting sub-ColumnSeismogramTask for pick zone", (Throwable)e);
            }
        }
        DataSetSeismogram[] creatorSeismos = creator.getSeismograms();
        DataSetSeismogram[] newSeismos = new DataSetSeismogram[creatorSeismos.length];
        for (int i = 0; i < creatorSeismos.length; ++i) {
            newSeismos[i] = (DataSetSeismogram)creatorSeismos[i].clone();
        }
        SeismogramDisplay display = this.childColSeis.getDisplay();
        if (display instanceof PickZoneDisplay) {
            this.childColSeis.makeSeismogramDisplayVisible();
            PickZoneDisplay pzd = (PickZoneDisplay)display;
            pzd.add(newSeismos, creator.getTimeConfig(), creator.getColor());
            this.childColSeis.checkTravelTimes();
        }
        creator.getTimeConfig().shaleTime(0.0, 1.0);
        try {
            this.childColTaskAction.checkDisplayLocation();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        ++this.selectionCount;
    }

    private Selection makeNewSelection(BasicSeismogramDisplay currDisp, MicroSecondTimeRange timeRange) {
        return this.makeNewSelection(currDisp, timeRange.getBeginTime(), timeRange.getEndTime());
    }

    private Selection makeNewSelection(BasicSeismogramDisplay currDisp, MicroSecondDate selectionBegin, MicroSecondDate selectionEnd) {
        Selection currentSelection = new Selection(new MicroSecondTimeRange(selectionBegin, selectionEnd), (SeismogramDisplay)currDisp, this.selectionColors[this.selectionCount % this.selectionColors.length]);
        currDisp.addSelection(currentSelection);
        this.newSelection = true;
        return currentSelection;
    }

    public Selection getSelection(SDMouseEvent me) {
        if (!this.rangeSelectableComponent(me)) {
            return null;
        }
        BasicSeismogramDisplay currDisp = (BasicSeismogramDisplay)me.getDisplay();
        DrawableIterator e = currDisp.iterator(Selection.class);
        while (e.hasNext()) {
            Selection curr = (Selection)e.next();
            float selBeginX = me.getPixel(curr.getBegin());
            float selEndX = me.getPixel(curr.getEnd());
            if (!(Math.abs(selBeginX - (float)me.getX()) <= 3.0f) && !(Math.abs(selEndX - (float)me.getX()) <= 3.0f)) continue;
            return curr;
        }
        return null;
    }

    public void mouseMoved(SDMouseEvent me) {
        if (this.rangeSelectableComponent(me)) {
            BasicSeismogramDisplay currDisp = (BasicSeismogramDisplay)me.getDisplay();
            Selection over = this.getSelection(me);
            if (over != null && over != this.currentSelection) {
                if (this.currentSelection != null) {
                    this.currentSelection.remove();
                    this.currentSelection = null;
                    this.newSelection = false;
                }
                me.getComponent().setCursor(Cursor.getPredefinedCursor(11));
            } else {
                MicroSecondTimeRange selRange = new MicroSecondTimeRange(me.getTime(me.getX() - 5), me.getTime(me.getX() + 5));
                if (this.currentSelection != null && currDisp == this.prevDisp) {
                    this.currentSelection.setTime(selRange);
                } else {
                    if (this.currentSelection != null) {
                        this.currentSelection.remove();
                    }
                    this.currentSelection = this.makeNewSelection(currDisp, selRange);
                }
                me.getComponent().setCursor(Cursor.getPredefinedCursor(1));
            }
            this.prevDisp = currDisp;
        }
    }

    public void mouseExited(SDMouseEvent me) {
        this.removeCurrentSelection();
    }

    private void removeCurrentSelection() {
        if (this.currentSelection != null) {
            this.currentSelection.remove();
            this.currentSelection = null;
        }
        this.newSelection = false;
    }

    private boolean rangeSelectableComponent(SDMouseEvent me) {
        BasicSeismogramDisplay disp;
        return me.getDisplay() instanceof BasicSeismogramDisplay && (disp = (BasicSeismogramDisplay)me.getDisplay()).getParentDisplay() == this.parentColSeis.getDisplay();
    }
}

