/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.gee.task;

import edu.iris.Fissures.Area;
import edu.iris.Fissures.IfEvent.EventAccessOperations;
import edu.iris.Fissures.IfNetwork.Channel;
import edu.iris.Fissures.IfNetwork.ChannelId;
import edu.iris.Fissures.IfNetwork.Station;
import edu.iris.Fissures.Plottable;
import edu.iris.Fissures.Quantity;
import edu.iris.Fissures.Time;
import edu.iris.Fissures.TimeRange;
import edu.iris.Fissures.Unit;
import edu.iris.Fissures.model.GlobalAreaImpl;
import edu.iris.Fissures.model.MicroSecondDate;
import edu.iris.Fissures.model.QuantityImpl;
import edu.iris.Fissures.model.UnitImpl;
import edu.iris.Fissures.network.ChannelImpl;
import edu.iris.Fissures.network.StationImpl;
import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.fissuresUtil.cache.AbstractJob;
import edu.sc.seis.fissuresUtil.cache.Job;
import edu.sc.seis.fissuresUtil.cache.JobTracker;
import edu.sc.seis.fissuresUtil.cache.ProxyEventAccessOperations;
import edu.sc.seis.fissuresUtil.cache.WorkerThreadPool;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooser;
import edu.sc.seis.fissuresUtil.chooser.ChannelChooserException;
import edu.sc.seis.fissuresUtil.chooser.ClockUtil;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionEvent;
import edu.sc.seis.fissuresUtil.chooser.StationSelectionListener;
import edu.sc.seis.fissuresUtil.display.DisplayUtils;
import edu.sc.seis.fissuresUtil.display.PlottableDisplay;
import edu.sc.seis.fissuresUtil.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.gee.CommonAccess;
import edu.sc.seis.gee.NetworkGateKeeper;
import edu.sc.seis.gee.NoNetworkException;
import edu.sc.seis.gee.configurator.ConfigurationException;
import edu.sc.seis.gee.task.ChannelChooserTask;
import edu.sc.seis.gee.task.CrocusPlottable;
import edu.sc.seis.gee.task.CrocusPlottableQueryParams;
import edu.sc.seis.gee.task.PlaceholderImage;
import edu.sc.seis.gee.task.QueryEventsTask;
import edu.sc.seis.gee.task.Task;
import edu.sc.seis.gee.task.TaskAction;
import edu.sc.seis.gee.task.TauPTask;
import edu.sc.seis.seisFile.SeisFileException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DateFormatter;
import net.sf.nachocalendar.CalendarFactory;
import net.sf.nachocalendar.components.CalendarUtils;
import net.sf.nachocalendar.components.DateField;
import org.apache.log4j.Category;

public class PlottableTask
extends JPanel
implements Task {
    WorkerThreadPool loaderPool = new WorkerThreadPool("Plottable Loader", 1);
    private int consecutiveFailures = 0;
    private static final Insets HORIZONTAL_SPACER = new Insets(0, 5, 0, 5);
    private static final Insets ZERO = new Insets(0, 0, 0, 0);
    private Map configParams;
    private PlottableDateChooser pDateChooser;
    private QueryEventsTask queryEventsTask;
    private TauPTask taupTask;
    private PlottableDisplay disp = new PlottableDisplay();
    private boolean initialized = false;
    private boolean dispAdded = false;
    private String host = "crocus.seis.sc.edu";
    private int port = 80;
    private ChannelChooserTask channelChooserTask;
    private JComboBox orientationSelector;
    static Category logger = Category.getInstance((String)PlottableTask.class.getName());
    private Timer reloadTimer;
    private DayReloader dayReloader;
    private StationSelector stationSelector = new StationSelector();
    private static final int FIFTEEN_MINUTES = 900000;
    private Task plottableTool = null;
    private PlaceholderImage placeholder;
    private JComponent placeholderPanel;
    private PlottableLoader plottableLoader = new PlottableLoader();

    @Override
    public void configure(Map params) throws ConfigurationException {
        this.setLayout(new BorderLayout());
        this.configParams = params;
        if (params.containsKey("Placeholder")) {
            String placeholderID = (String)params.get("Placeholder");
            TaskAction placeholderTA = CommonAccess.getCommonAccess().getTaskAction(placeholderID);
            this.placeholder = (PlaceholderImage)placeholderTA.getTask();
        }
        CommonAccess commonAccess = CommonAccess.getCommonAccess();
        String taskId = (String)this.configParams.get("queryEventsTask");
        TaskAction taskAction = commonAccess.getTaskAction(taskId);
        this.queryEventsTask = (QueryEventsTask)taskAction.getTask();
        this.host = (String)this.configParams.get("host");
        if (this.configParams.containsKey("port")) {
            this.port = Integer.parseInt((String)this.configParams.get("port"));
        }
        taskId = (String)this.configParams.get("TauPTask");
        taskAction = commonAccess.getTaskAction(taskId);
        try {
            this.taupTask = (TauPTask)taskAction.getTask();
        }
        catch (ConfigurationException e) {
            GlobalExceptionHandler.handle((String)"Problem loading taup task", (Throwable)e);
            return;
        }
        String taskID = (String)this.configParams.get("gee.task.id");
        TaskAction ta = commonAccess.getTaskAction(taskID);
        ta.addToToolBar(this.stationSelector);
        Thread t = new Thread((Runnable)new ChannelChooserLoader(), "Station Selector Loader");
        t.setPriority(4);
        t.start();
    }

    @Override
    public void invoke() throws Exception {
        if (this.placeholder != null) {
            this.placeholderPanel = this.placeholder.generateImagePanel();
            this.add(this.placeholderPanel);
        }
        if (!this.initialized) {
            if (!NetworkGateKeeper.accessAllowed()) {
                throw new NoNetworkException();
            }
            this.createGUI();
        }
    }

    public PlottableDisplay getDisplay() {
        return this.disp;
    }

    @Override
    public void destroy() {
        if (this.reloadTimer != null) {
            this.reloadTimer.stop();
        }
    }

    public void createGUI() throws Exception {
        if (!this.initialized) {
            Date start = PlottableTask.setTimeOnDate((Date)ClockUtil.now(), true);
            this.pDateChooser = new PlottableDateChooser(start);
            ScalingSliders ss = new ScalingSliders();
            Object[] orientationNames = new Object[]{"Up", "North", "East"};
            this.orientationSelector = new JComboBox<Object>(orientationNames);
            JLabel orientation = new JLabel("Orientation:");
            JPanel orientationPanel = new JPanel(new BorderLayout());
            GridBagLayout controlLayout = new GridBagLayout();
            JPanel controlPanel = new JPanel(controlLayout);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.weightx = 1.0;
            controlLayout.setConstraints(ss, gbc);
            controlPanel.add(ss);
            gbc.weightx = 0.0;
            controlLayout.setConstraints(this.pDateChooser, gbc);
            controlPanel.add(this.pDateChooser);
            controlLayout.setConstraints(orientationPanel, gbc);
            controlPanel.add(orientationPanel);
            this.add((Component)controlPanel, "North");
        }
        this.initialized = true;
    }

    public void loadData() {
        if (!this.dispAdded) {
            if (this.placeholderPanel != null) {
                this.remove(this.placeholderPanel);
            }
            this.add((Component)new JScrollPane((Component)this.disp), "Center");
            this.dispAdded = true;
        }
        this.loaderPool.invokeLater((Runnable)((Object)this.plottableLoader));
    }

    private void showData(ChannelId id, String stationName) {
    }

    private Arrival[][] getArrivalsFromEvent(EventAccessOperations[] events) throws ChannelChooserException {
        Arrival[][] arrivals = new Arrival[events.length][];
        Channel chan = this.getChannel();
        for (int i = 0; i < events.length; ++i) {
            arrivals[i] = this.taupTask.getArrivals(chan, events[i]);
        }
        return arrivals;
    }

    public Channel getChannel() throws ChannelChooserException {
        ChannelImpl[] channels = this.getChannels();
        String orientation = (String)this.orientationSelector.getSelectedItem();
        for (int i = 0; i < channels.length; ++i) {
            if (!DisplayUtils.getOrientationName((String)channels[i].get_id().channel_code).equals(orientation)) continue;
            return channels[i];
        }
        return null;
    }

    public ChannelImpl[] getChannels() throws ChannelChooserException {
        return this.stationSelector.getSelectedChannels();
    }

    private ChannelId getChannelId() throws ChannelChooserException {
        Channel chan = this.getChannel();
        if (chan == null) {
            JOptionPane.showMessageDialog(null, "You must select a station on the map before attempting to reload the data in the day viewer", "No station selected", 2);
            return null;
        }
        return this.getChannel().get_id();
    }

    private String getStationName() {
        return this.stationSelector.getStationName();
    }

    private Plottable[] getPlottable(ChannelId id) {
        try {
            CrocusPlottableQueryParams queryParams = new CrocusPlottableQueryParams(this.host);
            queryParams.setPort(this.port);
            queryParams.setChannel_id(id).setYear(this.getYear()).setJday(this.getJulianDay()).setModulo(14);
            CrocusPlottable plottableQuerier = new CrocusPlottable(queryParams);
            Plottable[] results = plottableQuerier.getPlottable();
            this.consecutiveFailures = 0;
            return results;
        }
        catch (SeisFileException e) {
            if (this.consecutiveFailures++ < 5) {
                return this.getPlottable(id);
            }
            GlobalExceptionHandler.handle((Throwable)e);
            return new Plottable[0];
        }
    }

    public void setPlottableTool(Task plottableTool) {
        if (this.plottableTool != null) {
            this.plottableTool.destroy();
        }
        this.plottableTool = plottableTool;
    }

    public Task getPlottableTool() {
        return this.plottableTool;
    }

    private int getJulianDay() {
        Date dateChosen = this.pDateChooser.getStart();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(dateChosen);
        int jday = calendar.get(6);
        return jday;
    }

    private int getYear() {
        Date dateChosen = this.pDateChooser.getStart();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(dateChosen);
        int year = calendar.get(1);
        return year;
    }

    private EventAccessOperations[] queryEvents(Date date) throws ConfigurationException, NoNetworkException {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime(date);
        GregorianCalendar gregorianCalendarBegin = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        GregorianCalendar gregorianCalendarEnd = new GregorianCalendar(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        gregorianCalendarBegin.setTimeZone(TimeZone.getTimeZone("GMT"));
        gregorianCalendarEnd.setTimeZone(TimeZone.getTimeZone("GMT"));
        Time startTime = new MicroSecondDate(gregorianCalendarBegin.getTime()).getFissuresTime();
        Time endTime = new MicroSecondDate(gregorianCalendarEnd.getTime()).getFissuresTime();
        TimeRange timeRange = new TimeRange(startTime, endTime);
        UnitImpl depthUnit = UnitImpl.KILOMETER;
        QuantityImpl minDepth = new QuantityImpl(0.0, (Unit)depthUnit);
        QuantityImpl maxDepth = new QuantityImpl(1000.0, (Unit)depthUnit);
        String[] magTypes = new String[]{};
        String[] catalogs = new String[]{"NEIC PDE"};
        String[] contributors = new String[]{};
        GlobalAreaImpl area = new GlobalAreaImpl();
        ProxyEventAccessOperations[] eventAccess = this.queryEventsTask.queryEvents((Area)area, (Quantity)minDepth, (Quantity)maxDepth, timeRange, magTypes, 5.5f, 10.0f, catalogs, contributors);
        return eventAccess;
    }

    public static Date setTimeOnDate(Date d, boolean isStart) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        cal.setTime(d);
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int millis = 0;
        if (!isStart) {
            hours = 23;
            minutes = 59;
            seconds = 59;
            millis = 999;
        }
        cal.set(11, hours);
        cal.set(12, minutes);
        cal.set(13, seconds);
        cal.set(14, millis);
        MicroSecondDate adjDate = new MicroSecondDate(cal.getTime());
        return adjDate;
    }

    private class PlottableDateChooser
    extends JPanel {
        private DateField startDF;
        private DateFormatter dateFormatter;

        public PlottableDateChooser(Date initialStartTime) {
            Box vBox = Box.createVerticalBox();
            vBox.add(Box.createVerticalGlue());
            vBox.add(new JLabel("Choose Day: "));
            SimpleDateFormat dFormat = new SimpleDateFormat("MMM dd, yyyy");
            dFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this.dateFormatter = new DateFormatter(dFormat);
            this.startDF = CalendarFactory.createDateField((DateFormatter)this.dateFormatter);
            this.startDF.setValue((Object)initialStartTime);
            vBox.add((Component)this.startDF);
            vBox.add(Box.createVerticalGlue());
            Box hBox = Box.createHorizontalBox();
            hBox.add(Box.createHorizontalGlue());
            hBox.add(vBox);
            hBox.add(Box.createHorizontalGlue());
            this.add(hBox);
        }

        public Date getStart() {
            Date start = this.getDate(this.startDF, true);
            return start;
        }

        public Date getEnd() {
            Date end = this.getDate(this.startDF, false);
            return end;
        }

        public Date getDate(DateField control, boolean isStart) {
            try {
                return PlottableTask.setTimeOnDate(CalendarUtils.convertToDate((Object)control.getValue()), isStart);
            }
            catch (ParseException e) {
                GlobalExceptionHandler.handle((String)"problem setting end date. returning now as the date", (Throwable)e);
                return ClockUtil.now();
            }
        }

        public void setStart(Date d) {
            this.setDate(this.startDF, d, true);
        }

        private void setDate(DateField control, Date d, boolean isStart) {
            control.setValue((Object)PlottableTask.setTimeOnDate(d, isStart));
        }

        public boolean isToday() {
            return CalendarUtils.isToday((Date)this.getStart());
        }
    }

    private class StationSelector
    extends JComboBox {
        private Map<String, StationImpl> stationName = new HashMap<String, StationImpl>();
        private ChannelChooser chanChooser;

        public StationSelector() {
            this.addItem("Select a station in the map to load data in the day viewer");
        }

        public void setChannelChooser(ChannelChooser chanChooser) {
            this.chanChooser = chanChooser;
            chanChooser.addStationSelectionListener(new StationSelectionListener(){

                public void stationSelectionChanged(StationSelectionEvent s) {
                    MicroSecondDate date = ClockUtil.now();
                    if (PlottableTask.this.pDateChooser != null) {
                        date = new MicroSecondDate(PlottableTask.this.pDateChooser.getStart());
                    }
                    StationSelector.this.setStations((Station[])s.getSelectedStations(date));
                }
            });
        }

        public void setStations(Station[] stations) {
            if (stations.length > 0) {
                this.removeAllItems();
                HashMap<String, StationImpl> newStationName = new HashMap<String, StationImpl>();
                int j = 0;
                for (int i = 0; i < stations.length; ++i) {
                    if (newStationName.containsKey(stations[i].getName())) continue;
                    newStationName.put(stations[i].getName(), (StationImpl)stations[i]);
                    this.addItem(stations[i].getName());
                    if (!this.stationName.containsKey(stations[i].getName())) {
                        this.setSelectedIndex(j);
                    }
                    ++j;
                }
                this.stationName = newStationName;
                try {
                    CommonAccess.getCommonAccess().getTaskAction(PlottableTask.this).checkDisplayLocation();
                }
                catch (ConfigurationException e) {
                    GlobalExceptionHandler.handle((Throwable)e);
                }
                PlottableTask.this.loadData();
            }
        }

        public ChannelImpl[] getSelectedChannels() throws ChannelChooserException {
            StationImpl selected;
            if (this.chanChooser != null && (selected = this.stationName.get(this.getSelectedItem())) != null) {
                List channels = this.chanChooser.getChannels(selected, new MicroSecondDate(PlottableTask.this.pDateChooser.getStart()));
                ArrayList<ChannelImpl> wantedChannels = new ArrayList<ChannelImpl>();
                for (ChannelImpl channelImpl : channels) {
                    if (!channelImpl.get_code().toUpperCase().startsWith("BH")) continue;
                    wantedChannels.add(channelImpl);
                }
                return wantedChannels.toArray(new ChannelImpl[0]);
            }
            return new ChannelImpl[0];
        }

        public String getStationName() {
            return (String)super.getSelectedItem();
        }
    }

    private class ScalingSliders
    extends JPanel {
        private ScalingSliders() {
            int min = 25;
            int max = 525;
            int start = 100;
            JSlider ampSlider = new JSlider(0, min, max, start);
            ampSlider.setMajorTickSpacing(100);
            ampSlider.setPaintTicks(true);
            Hashtable<Integer, JLabel> labelTable = new Hashtable<Integer, JLabel>();
            labelTable.put(new Integer(min), new JLabel("Tiny"));
            labelTable.put(new Integer(max), new JLabel("Huge"));
            ampSlider.setLabelTable(labelTable);
            ampSlider.setPaintLabels(true);
            ampSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ScalingSliders.this.fireAmplitudeChanged(ce);
                }
            });
            JLabel ampLabel = new JLabel("Amplitude:");
            min = 10;
            max = 110;
            start = 30;
            JSlider spacingSlider = new JSlider(0, min, max, start);
            spacingSlider.setMajorTickSpacing(20);
            spacingSlider.setPaintTicks(true);
            labelTable = new Hashtable();
            labelTable.put(new Integer(min), new JLabel("Close"));
            labelTable.put(new Integer(max), new JLabel("Distant"));
            spacingSlider.setLabelTable(labelTable);
            spacingSlider.setPaintLabels(true);
            spacingSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ce) {
                    ScalingSliders.this.fireSpacingChanged(ce);
                }
            });
            JLabel spacingLabel = new JLabel("Spacing:");
            GridBagLayout gb = new GridBagLayout();
            this.setLayout(gb);
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridwidth = -1;
            gb.setConstraints(ampLabel, gbc);
            this.add(ampLabel);
            gbc.weightx = 1.0;
            gbc.gridwidth = 0;
            gb.setConstraints(ampSlider, gbc);
            this.add(ampSlider);
            gbc.gridwidth = -1;
            gbc.weightx = 0.0;
            gbc.ipadx = 3;
            gb.setConstraints(spacingLabel, gbc);
            this.add(spacingLabel);
            gbc.weightx = 1.0;
            gbc.ipadx = 0;
            gbc.gridwidth = 0;
            gb.setConstraints(spacingSlider, gbc);
            this.add(spacingSlider);
        }

        public void fireAmplitudeChanged(ChangeEvent ce) {
            float amp = (float)((JSlider)ce.getSource()).getValue() / 100.0f;
            PlottableTask.this.disp.setAmpScale(amp);
        }

        public void fireSpacingChanged(ChangeEvent ce) {
            int offset = ((JSlider)ce.getSource()).getValue();
            PlottableTask.this.disp.setOffset(offset);
        }
    }

    private class DayReloader
    implements ActionListener {
        private DayReloader() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PlottableTask.this.pDateChooser.setStart((Date)ClockUtil.now());
            new PlottableLoader().run();
        }
    }

    private class PlottableLoader
    extends AbstractJob {
        public PlottableLoader() {
            super("Plottable Loader");
            JobTracker.getTracker().add((Job)this);
            this.setFinished();
        }

        public void runJob() {
            this.setFinished(false);
            try {
                ChannelId id = PlottableTask.this.getChannelId();
                if (id == null) {
                    return;
                }
                this.setStatus("Getting events");
                EventAccessOperations[] events = PlottableTask.this.queryEvents(PlottableTask.this.pDateChooser.getStart());
                Arrival[][] arrivals = PlottableTask.this.getArrivalsFromEvent(events);
                String stationName = PlottableTask.this.getStationName();
                this.setStatus("Updating day viewer");
                PlottableTask.this.disp.setPlottable(PlottableTask.this.getPlottable(id), stationName, (String)PlottableTask.this.orientationSelector.getSelectedItem(), PlottableTask.this.pDateChooser.getStart(), id, events, arrivals);
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Trouble getting events for plottable", (Throwable)e);
                this.setFinished();
                return;
            }
            catch (NoNetworkException e) {
            }
            catch (ChannelChooserException e) {
                GlobalExceptionHandler.handle((String)"Trouble getting channels for plottable", (Throwable)e);
                this.setFinished();
                return;
            }
            this.setStatus("Starting day viewer reloader");
            if (PlottableTask.this.reloadTimer != null) {
                PlottableTask.this.reloadTimer.removeActionListener(PlottableTask.this.dayReloader);
            } else {
                PlottableTask.this.reloadTimer = new Timer(900000, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                    }
                });
            }
            if (PlottableTask.this.pDateChooser.isToday() && NetworkGateKeeper.accessAllowed()) {
                PlottableTask.this.dayReloader = new DayReloader();
                PlottableTask.this.reloadTimer.addActionListener(PlottableTask.this.dayReloader);
                PlottableTask.this.reloadTimer.start();
            }
            this.setFinished();
        }
    }

    private class ChannelChooserLoader
    implements Runnable {
        private ChannelChooserLoader() {
        }

        @Override
        public void run() {
            CommonAccess commonAccess = CommonAccess.getCommonAccess();
            String taskId = (String)PlottableTask.this.configParams.get("channelChooserTask");
            TaskAction taskAction = commonAccess.getTaskAction(taskId);
            try {
                PlottableTask.this.channelChooserTask = (ChannelChooserTask)taskAction.getTask();
                PlottableTask.this.stationSelector.setChannelChooser(PlottableTask.this.channelChooserTask.getChannelChooser());
            }
            catch (NoNetworkException e) {
                GlobalExceptionHandler.handle((Throwable)e);
            }
            catch (ConfigurationException e) {
                GlobalExceptionHandler.handle((String)"Problem loading the channel chooser", (Throwable)e);
            }
        }
    }
}

